/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Stack;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathExistsException;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.s3a.impl.CallableSupplier;
import org.apache.hadoop.fs.s3a.impl.ExecutingStoreOperation;
import org.apache.hadoop.fs.s3a.impl.StoreContext;
import org.apache.hadoop.fs.store.audit.AuditSpan;
import org.apache.hadoop.fs.store.audit.AuditingFunctions;
import org.apache.hadoop.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyFromLocalOperation
extends ExecutingStoreOperation<Void> {
    private static final int LARGEST_N_FILES = 5;
    private static final Logger LOG = LoggerFactory.getLogger(CopyFromLocalOperation.class);
    private final CopyFromLocalOperationCallbacks callbacks;
    private final boolean deleteSource;
    private final boolean overwrite;
    private final Path source;
    private final ListeningExecutorService executor;
    private Path destination;
    private FileStatus destStatus;

    public CopyFromLocalOperation(StoreContext storeContext, Path source, Path destination, boolean deleteSource, boolean overwrite, CopyFromLocalOperationCallbacks callbacks) {
        super(storeContext);
        this.callbacks = callbacks;
        this.deleteSource = deleteSource;
        this.overwrite = overwrite;
        this.source = source;
        this.destination = destination;
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)storeContext.createThrottledExecutor(1));
    }

    @Override
    public Void execute() throws IOException, PathExistsException {
        LOG.debug("Copying local file from {} to {}", (Object)this.source, (Object)this.destination);
        File sourceFile = this.callbacks.pathToLocalFile(this.source);
        this.updateDestStatus(this.destination);
        if (this.getDestStatus().isPresent() && this.getDestStatus().get().isDirectory() && sourceFile.isDirectory()) {
            this.destination = new Path(this.destination, sourceFile.getName());
            LOG.debug("Destination updated to: {}", (Object)this.destination);
            this.updateDestStatus(this.destination);
        }
        this.checkSource(sourceFile);
        this.checkDestination(this.destination, sourceFile, this.overwrite);
        this.uploadSourceFromFS();
        if (this.deleteSource) {
            this.callbacks.deleteLocal(this.source, true);
        }
        return null;
    }

    private void updateDestStatus(Path dest) throws IOException {
        try {
            this.destStatus = this.callbacks.getFileStatus(dest);
        }
        catch (FileNotFoundException e) {
            this.destStatus = null;
        }
    }

    private void uploadSourceFromFS() throws IOException {
        File file;
        RemoteIterator<LocatedFileStatus> localFiles = this.listFilesAndDirs(this.source);
        ArrayList activeOps = new ArrayList();
        HashSet<Path> emptyDirs = new HashSet<Path>();
        ArrayList<UploadEntry> entries = new ArrayList<UploadEntry>();
        while (localFiles.hasNext()) {
            LocatedFileStatus sourceFile = (LocatedFileStatus)localFiles.next();
            Path sourceFilePath = sourceFile.getPath();
            emptyDirs.remove(sourceFilePath.getParent());
            if (sourceFile.isDirectory()) {
                emptyDirs.add(sourceFilePath);
                continue;
            }
            Path destPath = this.getFinalPath(sourceFilePath);
            entries.add(new UploadEntry(sourceFilePath, destPath, sourceFile.getLen()));
        }
        if (localFiles instanceof Closeable) {
            IOUtils.closeStream((Closeable)((Closeable)localFiles));
        }
        entries.sort((Comparator<UploadEntry>)new ReverseComparator((Comparator)new UploadEntry.SizeComparator()));
        int sortedUploadsCount = Math.min(5, entries.size());
        ArrayList<UploadEntry> markedForUpload = new ArrayList<UploadEntry>();
        for (int uploadNo = 0; uploadNo < sortedUploadsCount; ++uploadNo) {
            UploadEntry uploadEntry = (UploadEntry)entries.get(uploadNo);
            file = this.callbacks.pathToLocalFile(uploadEntry.source);
            activeOps.add(this.submitUpload(file, uploadEntry));
            markedForUpload.add(uploadEntry);
        }
        if (entries.isEmpty()) {
            emptyDirs.add(this.source);
        }
        entries.removeAll(markedForUpload);
        Collections.shuffle(entries);
        for (UploadEntry uploadEntry : entries) {
            file = this.callbacks.pathToLocalFile(uploadEntry.source);
            activeOps.add(this.submitUpload(file, uploadEntry));
        }
        for (Path emptyDir : emptyDirs) {
            Path emptyDirPath = this.getFinalPath(emptyDir);
            activeOps.add(this.submitCreateEmptyDir(emptyDirPath));
        }
        CallableSupplier.waitForCompletion(activeOps);
    }

    private CompletableFuture<Void> submitCreateEmptyDir(Path dir) {
        return CallableSupplier.submit((Executor)this.executor, AuditingFunctions.callableWithinAuditSpan((AuditSpan)this.getAuditSpan(), () -> {
            this.callbacks.createEmptyDir(dir, this.getStoreContext());
            return null;
        }));
    }

    private CompletableFuture<Void> submitUpload(File file, UploadEntry uploadEntry) {
        return CallableSupplier.submit((Executor)this.executor, AuditingFunctions.callableWithinAuditSpan((AuditSpan)this.getAuditSpan(), () -> {
            this.callbacks.copyLocalFileFromTo(file, uploadEntry.source, uploadEntry.destination);
            return null;
        }));
    }

    private void checkSource(File src) throws FileNotFoundException {
        if (!src.exists()) {
            throw new FileNotFoundException("No file: " + src.getPath());
        }
    }

    private void checkDestination(Path dest, File src, boolean overwrite) throws PathExistsException, FileAlreadyExistsException {
        if (!this.getDestStatus().isPresent()) {
            return;
        }
        if (src.isDirectory() && this.getDestStatus().get().isFile()) {
            throw new FileAlreadyExistsException("Source '" + src.getPath() + "' is directory and destination '" + dest + "' is file");
        }
        if (!overwrite) {
            throw new PathExistsException(dest + " already exists");
        }
    }

    private Path getFinalPath(Path src) throws PathIOException {
        URI currentSrcUri = src.toUri();
        URI relativeSrcUri = this.source.toUri().relativize(currentSrcUri);
        if (relativeSrcUri.equals(currentSrcUri)) {
            throw new PathIOException("Cannot get relative path for URI:" + relativeSrcUri);
        }
        Optional<FileStatus> status = this.getDestStatus();
        if (!relativeSrcUri.getPath().isEmpty()) {
            return new Path(this.destination, relativeSrcUri.getPath());
        }
        if (status.isPresent() && status.get().isDirectory()) {
            return new Path(this.destination, src.getName());
        }
        return this.destination;
    }

    private Optional<FileStatus> getDestStatus() {
        return Optional.ofNullable(this.destStatus);
    }

    private RemoteIterator<LocatedFileStatus> listFilesAndDirs(final Path path) throws IOException {
        return new RemoteIterator<LocatedFileStatus>(){
            private final Stack<RemoteIterator<LocatedFileStatus>> iterators = new Stack();
            private RemoteIterator<LocatedFileStatus> current = CopyFromLocalOperation.access$200(CopyFromLocalOperation.this).listLocalStatusIterator(path);
            private LocatedFileStatus curFile;

            public boolean hasNext() throws IOException {
                while (this.curFile == null) {
                    if (this.current.hasNext()) {
                        this.handleFileStat((LocatedFileStatus)this.current.next());
                        continue;
                    }
                    if (!this.iterators.empty()) {
                        this.current = this.iterators.pop();
                        continue;
                    }
                    return false;
                }
                return true;
            }

            private void handleFileStat(LocatedFileStatus stat) throws IOException {
                if (stat.isFile()) {
                    this.curFile = stat;
                } else {
                    this.curFile = stat;
                    this.iterators.push(this.current);
                    this.current = CopyFromLocalOperation.this.callbacks.listLocalStatusIterator(stat.getPath());
                }
            }

            public LocatedFileStatus next() throws IOException {
                if (this.hasNext()) {
                    LocatedFileStatus result = this.curFile;
                    this.curFile = null;
                    return result;
                }
                throw new NoSuchElementException("No more entry in " + path);
            }
        };
    }

    public static interface CopyFromLocalOperationCallbacks {
        public RemoteIterator<LocatedFileStatus> listLocalStatusIterator(Path var1) throws IOException;

        public FileStatus getFileStatus(Path var1) throws IOException;

        public File pathToLocalFile(Path var1);

        public boolean deleteLocal(Path var1, boolean var2) throws IOException;

        public void copyLocalFileFromTo(File var1, Path var2, Path var3) throws IOException;

        public boolean createEmptyDir(Path var1, StoreContext var2) throws IOException;
    }

    private static final class UploadEntry {
        private final Path source;
        private final Path destination;
        private final long size;

        private UploadEntry(Path source, Path destination, long size) {
            this.source = source;
            this.destination = destination;
            this.size = size;
        }

        static class SizeComparator
        implements Comparator<UploadEntry>,
        Serializable {
            SizeComparator() {
            }

            @Override
            public int compare(UploadEntry entry1, UploadEntry entry2) {
                return Long.compare(entry1.size, entry2.size);
            }
        }
    }
}

