/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.auth.delegation;

import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.AWSCredentialProviderList;
import org.apache.hadoop.fs.s3a.auth.MarshalledCredentialBinding;
import org.apache.hadoop.fs.s3a.auth.MarshalledCredentialProvider;
import org.apache.hadoop.fs.s3a.auth.MarshalledCredentials;
import org.apache.hadoop.fs.s3a.auth.RoleModel;
import org.apache.hadoop.fs.s3a.auth.STSClientFactory;
import org.apache.hadoop.fs.s3a.auth.delegation.AbstractS3ATokenIdentifier;
import org.apache.hadoop.fs.s3a.auth.delegation.DelegationConstants;
import org.apache.hadoop.fs.s3a.auth.delegation.DelegationTokenIOException;
import org.apache.hadoop.fs.s3a.auth.delegation.EncryptionSecrets;
import org.apache.hadoop.fs.s3a.auth.delegation.RoleTokenIdentifier;
import org.apache.hadoop.fs.s3a.auth.delegation.SessionTokenBinding;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.sts.model.Credentials;

public class RoleTokenBinding
extends SessionTokenBinding {
    private static final Logger LOG = LoggerFactory.getLogger(RoleTokenBinding.class);
    private static final RoleModel MODEL = new RoleModel();
    private static final String NAME = "RoleCredentials/001";
    @VisibleForTesting
    public static final String E_NO_ARN = "No role ARN defined in fs.s3a.assumed.role.arn";
    public static final String COMPONENT = "Role Delegation Token";
    private String roleArn;

    public RoleTokenBinding() {
        super(NAME, DelegationConstants.ROLE_TOKEN_KIND);
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        this.roleArn = this.getConfig().getTrimmed("fs.s3a.assumed.role.arn", "");
    }

    @Override
    public AWSCredentialProviderList bindToTokenIdentifier(AbstractS3ATokenIdentifier retrievedIdentifier) throws IOException {
        RoleTokenIdentifier tokenIdentifier = this.convertTokenIdentifier(retrievedIdentifier, RoleTokenIdentifier.class);
        this.setTokenIdentifier(Optional.of(tokenIdentifier));
        MarshalledCredentials marshalledCredentials = tokenIdentifier.getMarshalledCredentials();
        this.setExpirationDateTime(marshalledCredentials.getExpirationDateTime());
        return new AWSCredentialProviderList("Role Token Binding", new MarshalledCredentialProvider(COMPONENT, this.getFileSystem().getUri(), this.getConfig(), marshalledCredentials, MarshalledCredentials.CredentialTypeRequired.SessionOnly));
    }

    @Override
    public RoleTokenIdentifier createTokenIdentifier(Optional<RoleModel.Policy> policy, EncryptionSecrets encryptionSecrets, Text renewer) throws IOException {
        this.requireServiceStarted();
        Preconditions.checkState((!this.roleArn.isEmpty() ? 1 : 0) != 0, (Object)E_NO_ARN);
        String policyJson = policy.isPresent() ? MODEL.toJson(policy.get()) : "";
        STSClientFactory.STSClient client = this.prepareSTSClient().orElseThrow(() -> {
            LOG.error("Cannot issue delegation tokens because the credential providers listed in fs.s3a.aws.credentials.provider are returning session tokens");
            return new DelegationTokenIOException("Cannot issue S3A Role Delegation Tokens without full AWS credentials");
        });
        Credentials credentials = client.requestRole(this.roleArn, UUID.randomUUID().toString(), policyJson, this.getDuration(), TimeUnit.SECONDS);
        return new RoleTokenIdentifier(this.getCanonicalUri(), this.getOwnerText(), renewer, MarshalledCredentialBinding.fromSTSCredentials(credentials), encryptionSecrets, AbstractS3ATokenIdentifier.createDefaultOriginMessage() + " Role ARN=" + this.roleArn);
    }

    @Override
    public RoleTokenIdentifier createEmptyIdentifier() {
        return new RoleTokenIdentifier();
    }

    @Override
    public String getDescription() {
        return super.getDescription() + " Role ARN=" + (this.roleArn.isEmpty() ? "(none)" : '\"' + this.roleArn + '\"');
    }

    @Override
    protected String bindingName() {
        return "Role";
    }
}

