/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.auth;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.s3a.auth.RoleModel;

@InterfaceAudience.LimitedPrivate(value={"Tests"})
@InterfaceStability.Unstable
public final class RolePolicies {
    public static final String KMS_ALL_OPERATIONS = "kms:*";
    public static final String KMS_ENCRYPT = "kms:Encrypt";
    public static final String KMS_DECRYPT = "kms:Decrypt";
    public static final String KMS_ALL_KEYS = "*";
    public static final String KMS_GENERATE_DATA_KEY = "kms:GenerateDataKey";
    private static final String[] KMS_KEY_RW = new String[]{"kms:Decrypt", "kms:GenerateDataKey", "kms:Encrypt"};
    private static final String[] KMS_KEY_READ = new String[]{"kms:Decrypt"};
    public static final RoleModel.Statement STATEMENT_ALLOW_SSE_KMS_RW;
    public static final RoleModel.Statement STATEMENT_ALLOW_KMS_RW;
    public static final RoleModel.Statement STATEMENT_ALLOW_SSE_KMS_READ;
    public static final String S3_ALL_OPERATIONS = "s3:*";
    public static final String S3_ALL_BUCKETS = "arn:aws:s3:::*";
    public static final String S3_BUCKET_ALL_LIST = "s3:ListBucket*";
    public static final String S3_BUCKET_LIST_BUCKET = "s3:ListBucket";
    public static final String S3_BUCKET_LIST_MULTIPART_UPLOADS = "s3:ListBucketMultipartUploads";
    public static final String S3_LIST_MULTIPART_UPLOAD_PARTS = "s3:ListMultipartUploadParts";
    public static final String S3_ABORT_MULTIPART_UPLOAD = "s3:AbortMultipartUpload";
    public static final String S3_ALL_DELETE = "s3:Delete*";
    public static final String S3_DELETE_OBJECT = "s3:DeleteObject";
    public static final String S3_DELETE_OBJECT_TAGGING = "s3:DeleteObjectTagging";
    public static final String S3_DELETE_OBJECT_VERSION = "s3:DeleteObjectVersion";
    public static final String S3_DELETE_OBJECT_VERSION_TAGGING = "s3:DeleteObjectVersionTagging";
    public static final String S3_ALL_GET = "s3:Get*";
    public static final String S3_GET_OBJECT = "s3:GetObject";
    public static final String S3_GET_OBJECT_ACL = "s3:GetObjectAcl";
    public static final String S3_GET_OBJECT_TAGGING = "s3:GetObjectTagging";
    public static final String S3_GET_OBJECT_TORRENT = "s3:GetObjectTorrent";
    public static final String S3_GET_OBJECT_VERSION = "s3:GetObjectVersion";
    public static final String S3_GET_BUCKET_LOCATION = "s3:GetBucketLocation";
    public static final String S3_GET_OBJECT_VERSION_ACL = "s3:GetObjectVersionAcl";
    public static final String S3_GET_OBJECT_VERSION_TAGGING = "s3:GetObjectVersionTagging";
    public static final String S3_GET_OBJECT_VERSION_TORRENT = "s3:GetObjectVersionTorrent";
    public static final String S3_ALL_PUT = "s3:Put*";
    public static final String S3_PUT_OBJECT = "s3:PutObject";
    public static final String S3_PUT_OBJECT_ACL = "s3:PutObjectAcl";
    public static final String S3_PUT_OBJECT_TAGGING = "s3:PutObjectTagging";
    public static final String S3_PUT_OBJECT_VERSION_ACL = "s3:PutObjectVersionAcl";
    public static final String S3_PUT_OBJECT_VERSION_TAGGING = "s3:PutObjectVersionTagging";
    public static final String S3_RESTORE_OBJECT = "s3:RestoreObject";
    public static final String S3EXPRESS_CREATE_SESSION_POLICY = "s3express:CreateSession";
    private static final String[] S3_PATH_READ_OPERATIONS;
    private static final String[] S3_ROOT_READ_OPERATIONS;
    public static final List<String> S3_ROOT_READ_OPERATIONS_LIST;
    public static final String[] S3_BUCKET_READ_OPERATIONS;
    public static final List<String> S3_PATH_RW_OPERATIONS;
    public static final List<String> S3_PATH_WRITE_OPERATIONS;
    public static final List<String> S3_ROOT_RW_OPERATIONS;
    public static final RoleModel.Statement STATEMENT_ALL_S3;
    public static final RoleModel.Statement STATEMENT_ALL_S3_GET_BUCKET_LOCATION;

    private RolePolicies() {
    }

    public static List<RoleModel.Statement> allowS3Operations(String bucket, boolean write) {
        ArrayList statements = Lists.newArrayList((Object[])new RoleModel.Statement[]{RoleModel.statement(true, RolePolicies.bucketToArn(bucket), S3_GET_BUCKET_LOCATION, S3_BUCKET_ALL_LIST)});
        if (write) {
            statements.add(RoleModel.statement(true, RolePolicies.bucketObjectsToArn(bucket), S3_ROOT_RW_OPERATIONS));
        } else {
            statements.add(RoleModel.statement(true, RolePolicies.bucketObjectsToArn(bucket), S3_ROOT_READ_OPERATIONS_LIST));
        }
        return statements;
    }

    public static String bucketObjectsToArn(String bucket) {
        return String.format("arn:aws:s3:::%s/*", bucket);
    }

    public static String bucketToArn(String bucket) {
        return String.format("arn:aws:s3:::%s", bucket);
    }

    static {
        STATEMENT_ALLOW_KMS_RW = STATEMENT_ALLOW_SSE_KMS_RW = RoleModel.statement(true, KMS_ALL_KEYS, KMS_ALL_OPERATIONS);
        STATEMENT_ALLOW_SSE_KMS_READ = RoleModel.statement(true, KMS_ALL_KEYS, KMS_KEY_READ);
        S3_PATH_READ_OPERATIONS = new String[]{S3_GET_OBJECT};
        S3_ROOT_READ_OPERATIONS = new String[]{S3_ALL_GET};
        S3_ROOT_READ_OPERATIONS_LIST = Collections.unmodifiableList(Arrays.asList(S3_ALL_GET));
        S3_BUCKET_READ_OPERATIONS = new String[]{S3_ALL_GET, S3_BUCKET_ALL_LIST};
        S3_PATH_RW_OPERATIONS = Collections.unmodifiableList(Arrays.asList(S3_ALL_GET, S3_PUT_OBJECT, S3_PUT_OBJECT_ACL, S3_DELETE_OBJECT, S3_ABORT_MULTIPART_UPLOAD));
        S3_PATH_WRITE_OPERATIONS = Collections.unmodifiableList(Arrays.asList(S3_PUT_OBJECT, S3_PUT_OBJECT_ACL, S3_DELETE_OBJECT, S3_ABORT_MULTIPART_UPLOAD));
        S3_ROOT_RW_OPERATIONS = Collections.unmodifiableList(Arrays.asList(S3_ALL_GET, S3_PUT_OBJECT, S3_PUT_OBJECT_ACL, S3_DELETE_OBJECT, S3_ABORT_MULTIPART_UPLOAD));
        STATEMENT_ALL_S3 = RoleModel.statement(true, S3_ALL_BUCKETS, S3_ALL_OPERATIONS);
        STATEMENT_ALL_S3_GET_BUCKET_LOCATION = RoleModel.statement(true, S3_ALL_BUCKETS, S3_GET_BUCKET_LOCATION);
    }
}

