/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.s3a.DefaultS3ClientFactory;
import org.apache.hadoop.fs.s3a.S3ClientFactory;
import org.apache.hadoop.security.ssl.DelegatingSSLSocketFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class Constants {
    public static final String HADOOP_TMP_DIR = "hadoop.tmp.dir";
    public static final int MULTIPART_MIN_SIZE = 0x500000;
    public static final String ACCESS_KEY = "fs.s3a.access.key";
    public static final String SECRET_KEY = "fs.s3a.secret.key";
    public static final String AWS_CREDENTIALS_PROVIDER = "fs.s3a.aws.credentials.provider";
    public static final String S3A_SECURITY_CREDENTIAL_PROVIDER_PATH = "fs.s3a.security.credential.provider.path";
    public static final String SESSION_TOKEN = "fs.s3a.session.token";
    public static final String ASSUMED_ROLE_ARN = "fs.s3a.assumed.role.arn";
    public static final String ASSUMED_ROLE_SESSION_NAME = "fs.s3a.assumed.role.session.name";
    public static final String ASSUMED_ROLE_SESSION_DURATION = "fs.s3a.assumed.role.session.duration";
    public static final String ASSUMED_ROLE_STS_ENDPOINT = "fs.s3a.assumed.role.sts.endpoint";
    public static final String DEFAULT_ASSUMED_ROLE_STS_ENDPOINT = "";
    public static final String ASSUMED_ROLE_STS_ENDPOINT_REGION = "fs.s3a.assumed.role.sts.endpoint.region";
    public static final String ASSUMED_ROLE_STS_ENDPOINT_REGION_DEFAULT = "";
    public static final String ASSUMED_ROLE_SESSION_DURATION_DEFAULT = "1h";
    public static final String ASSUMED_ROLE_CREDENTIALS_PROVIDER = "fs.s3a.assumed.role.credentials.provider";
    public static final String ASSUMED_ROLE_POLICY = "fs.s3a.assumed.role.policy";
    public static final String ASSUMED_ROLE_CREDENTIALS_DEFAULT = "org.apache.hadoop.fs.s3a.SimpleAWSCredentialsProvider";
    public static final String MAX_TOTAL_TASKS = "fs.s3a.max.total.tasks";
    public static final int DEFAULT_MAX_TOTAL_TASKS = 32;
    public static final String MAXIMUM_CONNECTIONS = "fs.s3a.connection.maximum";
    public static final int DEFAULT_MAXIMUM_CONNECTIONS = 500;
    public static final String CONNECTION_TTL = "fs.s3a.connection.ttl";
    public static final Duration DEFAULT_CONNECTION_TTL_DURATION = Duration.ofMinutes(5L);
    public static final long DEFAULT_CONNECTION_TTL = DEFAULT_CONNECTION_TTL_DURATION.toMillis();
    public static final String SECURE_CONNECTIONS = "fs.s3a.connection.ssl.enabled";
    public static final boolean DEFAULT_SECURE_CONNECTIONS = true;
    public static final String ALLOW_REQUESTER_PAYS = "fs.s3a.requester.pays.enabled";
    public static final boolean DEFAULT_ALLOW_REQUESTER_PAYS = false;
    public static final String SSL_CHANNEL_MODE = "fs.s3a.ssl.channel.mode";
    public static final DelegatingSSLSocketFactory.SSLChannelMode DEFAULT_SSL_CHANNEL_MODE = DelegatingSSLSocketFactory.SSLChannelMode.Default_JSSE;
    public static final String ENDPOINT = "fs.s3a.endpoint";
    public static final String DEFAULT_ENDPOINT = "";
    public static final String CENTRAL_ENDPOINT = "s3.amazonaws.com";
    public static final String PATH_STYLE_ACCESS = "fs.s3a.path.style.access";
    public static final String PROXY_HOST = "fs.s3a.proxy.host";
    public static final String PROXY_PORT = "fs.s3a.proxy.port";
    public static final String PROXY_USERNAME = "fs.s3a.proxy.username";
    public static final String PROXY_PASSWORD = "fs.s3a.proxy.password";
    public static final String PROXY_DOMAIN = "fs.s3a.proxy.domain";
    public static final String PROXY_WORKSTATION = "fs.s3a.proxy.workstation";
    public static final String PROXY_SECURED = "fs.s3a.proxy.ssl.enabled";
    public static final String MAX_ERROR_RETRIES = "fs.s3a.attempts.maximum";
    public static final int DEFAULT_MAX_ERROR_RETRIES = 5;
    @InterfaceStability.Unstable
    public static final String EXPERIMENTAL_AWS_INTERNAL_THROTTLING = "fs.s3a.experimental.aws.s3.throttling";
    @InterfaceStability.Unstable
    public static final boolean EXPERIMENTAL_AWS_INTERNAL_THROTTLING_DEFAULT = true;
    public static final Duration MINIMUM_NETWORK_OPERATION_DURATION = Duration.ofSeconds(15L);
    public static final String ESTABLISH_TIMEOUT = "fs.s3a.connection.establish.timeout";
    public static final Duration DEFAULT_ESTABLISH_TIMEOUT_DURATION = Duration.ofSeconds(30L);
    public static final int DEFAULT_ESTABLISH_TIMEOUT = (int)DEFAULT_ESTABLISH_TIMEOUT_DURATION.toMillis();
    public static final String SOCKET_TIMEOUT = "fs.s3a.connection.timeout";
    public static final Duration DEFAULT_SOCKET_TIMEOUT_DURATION = Duration.ofSeconds(200L);
    public static final int DEFAULT_SOCKET_TIMEOUT = (int)DEFAULT_SOCKET_TIMEOUT_DURATION.toMillis();
    public static final String REQUEST_TIMEOUT = "fs.s3a.connection.request.timeout";
    public static final Duration DEFAULT_REQUEST_TIMEOUT_DURATION = Duration.ofSeconds(60L);
    public static final int DEFAULT_REQUEST_TIMEOUT = (int)DEFAULT_REQUEST_TIMEOUT_DURATION.toMillis();
    public static final String CONNECTION_ACQUISITION_TIMEOUT = "fs.s3a.connection.acquisition.timeout";
    public static final Duration DEFAULT_CONNECTION_ACQUISITION_TIMEOUT_DURATION = Duration.ofSeconds(60L);
    public static final String CONNECTION_KEEPALIVE = "fs.s3a.connection.keepalive";
    public static final boolean DEFAULT_CONNECTION_KEEPALIVE = false;
    public static final String CONNECTION_IDLE_TIME = "fs.s3a.connection.idle.time";
    public static final Duration DEFAULT_CONNECTION_IDLE_TIME_DURATION = Duration.ofSeconds(60L);
    public static final String CONNECTION_EXPECT_CONTINUE = "fs.s3a.connection.expect.continue";
    public static final boolean CONNECTION_EXPECT_CONTINUE_DEFAULT = true;
    public static final String SOCKET_SEND_BUFFER = "fs.s3a.socket.send.buffer";
    public static final int DEFAULT_SOCKET_SEND_BUFFER = 8192;
    public static final String SOCKET_RECV_BUFFER = "fs.s3a.socket.recv.buffer";
    public static final int DEFAULT_SOCKET_RECV_BUFFER = 8192;
    public static final String MAX_PAGING_KEYS = "fs.s3a.paging.maximum";
    public static final int DEFAULT_MAX_PAGING_KEYS = 5000;
    public static final String MAX_THREADS = "fs.s3a.threads.max";
    public static final int DEFAULT_MAX_THREADS = 96;
    public static final String KEEPALIVE_TIME = "fs.s3a.threads.keepalivetime";
    public static final Duration DEFAULT_KEEPALIVE_TIME_DURATION = Duration.ofSeconds(60L);
    public static final int DEFAULT_KEEPALIVE_TIME = (int)DEFAULT_KEEPALIVE_TIME_DURATION.getSeconds();
    public static final String MULTIPART_SIZE = "fs.s3a.multipart.size";
    public static final long DEFAULT_MULTIPART_SIZE = 0x4000000L;
    public static final String MIN_MULTIPART_THRESHOLD = "fs.s3a.multipart.threshold";
    public static final long DEFAULT_MIN_MULTIPART_THRESHOLD = 0x8000000L;
    public static final String MULTIPART_COPY_THRESHOLD = "fs.s3a.multipart.copy.threshold";
    public static final long MULTIPART_COPY_THRESHOLD_MAX = Integer.MAX_VALUE;
    public static final String ENABLE_MULTI_DELETE = "fs.s3a.multiobjectdelete.enable";
    public static final String BULK_DELETE_PAGE_SIZE = "fs.s3a.bulk.delete.page.size";
    public static final int BULK_DELETE_PAGE_SIZE_DEFAULT = 250;
    public static final String BUFFER_DIR = "fs.s3a.buffer.dir";
    @Deprecated
    public static final String FAST_UPLOAD = "fs.s3a.fast.upload";
    @Deprecated
    public static final boolean DEFAULT_FAST_UPLOAD = false;
    @Deprecated
    public static final String FAST_BUFFER_SIZE = "fs.s3a.fast.buffer.size";
    public static final int DEFAULT_FAST_BUFFER_SIZE = 0x100000;
    public static final String FAST_UPLOAD_BUFFER = "fs.s3a.fast.upload.buffer";
    public static final String FAST_UPLOAD_BUFFER_DISK = "disk";
    public static final String FAST_UPLOAD_BUFFER_ARRAY = "array";
    public static final String FAST_UPLOAD_BYTEBUFFER = "bytebuffer";
    public static final String DEFAULT_FAST_UPLOAD_BUFFER = "disk";
    public static final String FAST_UPLOAD_ACTIVE_BLOCKS = "fs.s3a.fast.upload.active.blocks";
    public static final int DEFAULT_FAST_UPLOAD_ACTIVE_BLOCKS = 4;
    public static final String DOWNGRADE_SYNCABLE_EXCEPTIONS = "fs.s3a.downgrade.syncable.exceptions";
    public static final boolean DOWNGRADE_SYNCABLE_EXCEPTIONS_DEFAULT = false;
    public static final String EXECUTOR_CAPACITY = "fs.s3a.executor.capacity";
    public static final int DEFAULT_EXECUTOR_CAPACITY = 16;
    public static final String CANNED_ACL = "fs.s3a.acl.default";
    public static final String DEFAULT_CANNED_ACL = "";
    public static final String CONTENT_ENCODING = "fs.s3a.object.content.encoding";
    public static final String STORAGE_CLASS = "fs.s3a.create.storage.class";
    public static final String STORAGE_CLASS_STANDARD = "standard";
    public static final String STORAGE_CLASS_REDUCED_REDUNDANCY = "reduced_redundancy";
    public static final String STORAGE_CLASS_GLACIER = "glacier";
    public static final String STORAGE_CLASS_STANDARD_INFREQUENT_ACCESS = "standard_ia";
    public static final String STORAGE_CLASS_ONEZONE_INFREQUENT_ACCESS = "onezone_ia";
    public static final String STORAGE_CLASS_INTELLIGENT_TIERING = "intelligent_tiering";
    public static final String STORAGE_CLASS_DEEP_ARCHIVE = "deep_archive";
    public static final String STORAGE_CLASS_OUTPOSTS = "outposts";
    public static final String STORAGE_CLASS_GLACIER_INSTANT_RETRIEVAL = "glacier_ir";
    public static final String PURGE_EXISTING_MULTIPART = "fs.s3a.multipart.purge";
    public static final boolean DEFAULT_PURGE_EXISTING_MULTIPART = false;
    public static final String PURGE_EXISTING_MULTIPART_AGE = "fs.s3a.multipart.purge.age";
    public static final long DEFAULT_PURGE_EXISTING_MULTIPART_AGE = Duration.ofDays(1L).getSeconds();
    @Deprecated
    public static final String SERVER_SIDE_ENCRYPTION_ALGORITHM = "fs.s3a.server-side-encryption-algorithm";
    @Deprecated
    public static final String SERVER_SIDE_ENCRYPTION_AES256 = "AES256";
    @Deprecated
    public static final String SERVER_SIDE_ENCRYPTION_KEY = "fs.s3a.server-side-encryption.key";
    public static final String S3_ENCRYPTION_ALGORITHM = "fs.s3a.encryption.algorithm";
    public static final String S3_ENCRYPTION_KEY = "fs.s3a.encryption.key";
    public static final String CUSTOM_SIGNERS = "fs.s3a.custom.signers";
    public static final String SIGNING_ALGORITHM = "fs.s3a.signing-algorithm";
    public static final String SIGNING_ALGORITHM_S3 = "fs.s3a." + "S3".toLowerCase() + ".signing-algorithm";
    @Deprecated
    public static final String SIGNING_ALGORITHM_DDB = "fs.s3a." + "DDB".toLowerCase() + "signing-algorithm";
    public static final String SIGNING_ALGORITHM_STS = "fs.s3a." + "STS".toLowerCase() + ".signing-algorithm";
    public static final String S3N_FOLDER_SUFFIX = "_$folder$";
    public static final String FS_S3A_BLOCK_SIZE = "fs.s3a.block.size";
    public static final String FS_S3A = "s3a";
    public static final String FS_S3A_PREFIX = "fs.s3a.";
    public static final String FS_S3A_BUCKET_PREFIX = "fs.s3a.bucket.";
    public static final int S3A_DEFAULT_PORT = 443;
    public static final String USER_AGENT_PREFIX = "fs.s3a.user.agent.prefix";
    public static final String AUTHORITATIVE_PATH = "fs.s3a.authoritative.path";
    public static final String[] DEFAULT_AUTHORITATIVE_PATH = new String[0];
    @Deprecated
    public static final String METADATASTORE_AUTHORITATIVE = "fs.s3a.metadatastore.authoritative";
    @Deprecated
    public static final boolean DEFAULT_METADATASTORE_AUTHORITATIVE = false;
    public static final String S3A_BUCKET_PROBE = "fs.s3a.bucket.probe";
    public static final int S3A_BUCKET_PROBE_DEFAULT = 0;
    @Deprecated
    public static final String METADATASTORE_METADATA_TTL = "fs.s3a.metadatastore.metadata.ttl";
    @Deprecated
    public static final long DEFAULT_METADATASTORE_METADATA_TTL = TimeUnit.MINUTES.toMillis(15L);
    public static final String READAHEAD_RANGE = "fs.s3a.readahead.range";
    public static final long DEFAULT_READAHEAD_RANGE = 65536L;
    public static final String ASYNC_DRAIN_THRESHOLD = "fs.s3a.input.async.drain.threshold";
    public static final int DEFAULT_ASYNC_DRAIN_THRESHOLD = 16000;
    public static final String INPUT_FADVISE = "fs.s3a.experimental.input.fadvise";
    public static final String INPUT_FADV_DEFAULT = "default";
    public static final String INPUT_FADV_NORMAL = "normal";
    public static final String INPUT_FADV_SEQUENTIAL = "sequential";
    public static final String INPUT_FADV_RANDOM = "random";
    public static final String STREAM_READ_GAUGE_INPUT_POLICY = "stream_read_gauge_input_policy";
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static final String S3_CLIENT_FACTORY_IMPL = "fs.s3a.s3.client.factory.impl";
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static final Class<? extends S3ClientFactory> DEFAULT_S3_CLIENT_FACTORY_IMPL = DefaultS3ClientFactory.class;
    @InterfaceAudience.Private
    public static final int MAX_MULTIPART_COUNT = 10000;
    @Deprecated
    public static final String S3_METADATA_STORE_IMPL = "fs.s3a.metadatastore.impl";
    @Deprecated
    public static final String FAIL_ON_METADATA_WRITE_ERROR = "fs.s3a.metadatastore.fail.on.write.error";
    @Deprecated
    public static final boolean FAIL_ON_METADATA_WRITE_ERROR_DEFAULT = true;
    @InterfaceStability.Unstable
    @Deprecated
    public static final String S3GUARD_CLI_PRUNE_AGE = "fs.s3a.s3guard.cli.prune.age";
    @Deprecated
    public static final String S3GUARD_DDB_REGION_KEY = "fs.s3a.s3guard.ddb.region";
    @Deprecated
    public static final String S3GUARD_DDB_TABLE_NAME_KEY = "fs.s3a.s3guard.ddb.table";
    @Deprecated
    public static final String S3GUARD_DDB_TABLE_TAG = "fs.s3a.s3guard.ddb.table.tag.";
    @Deprecated
    public static final String S3GUARD_DDB_TABLE_CREATE_KEY = "fs.s3a.s3guard.ddb.table.create";
    @Deprecated
    public static final String S3GUARD_DDB_TABLE_CAPACITY_READ_KEY = "fs.s3a.s3guard.ddb.table.capacity.read";
    @Deprecated
    public static final long S3GUARD_DDB_TABLE_CAPACITY_READ_DEFAULT = 0L;
    @Deprecated
    public static final String S3GUARD_DDB_TABLE_CAPACITY_WRITE_KEY = "fs.s3a.s3guard.ddb.table.capacity.write";
    @Deprecated
    public static final long S3GUARD_DDB_TABLE_CAPACITY_WRITE_DEFAULT = 0L;
    @Deprecated
    public static final String S3GUARD_DDB_TABLE_SSE_ENABLED = "fs.s3a.s3guard.ddb.table.sse.enabled";
    @Deprecated
    public static final String S3GUARD_DDB_TABLE_SSE_CMK = "fs.s3a.s3guard.ddb.table.sse.cmk";
    @Deprecated
    public static final int S3GUARD_DDB_BATCH_WRITE_REQUEST_LIMIT = 25;
    @Deprecated
    public static final String S3GUARD_DDB_MAX_RETRIES = "fs.s3a.s3guard.ddb.max.retries";
    @Deprecated
    public static final int S3GUARD_DDB_MAX_RETRIES_DEFAULT = 5;
    @Deprecated
    public static final String S3GUARD_DDB_THROTTLE_RETRY_INTERVAL = "fs.s3a.s3guard.ddb.throttle.retry.interval";
    @Deprecated
    public static final String S3GUARD_DDB_THROTTLE_RETRY_INTERVAL_DEFAULT = "100ms";
    @Deprecated
    @InterfaceStability.Unstable
    public static final String S3GUARD_DDB_BACKGROUND_SLEEP_MSEC_KEY = "fs.s3a.s3guard.ddb.background.sleep";
    @Deprecated
    public static final int S3GUARD_DDB_BACKGROUND_SLEEP_MSEC_DEFAULT = 25;
    @Deprecated
    public static final String S3GUARD_METASTORE_NULL = "org.apache.hadoop.fs.s3a.s3guard.NullMetadataStore";
    @Deprecated
    @InterfaceStability.Unstable
    public static final String S3GUARD_METASTORE_LOCAL = "org.apache.hadoop.fs.s3a.s3guard.LocalMetadataStore";
    @InterfaceStability.Unstable
    @Deprecated
    public static final String S3GUARD_METASTORE_LOCAL_MAX_RECORDS = "fs.s3a.s3guard.local.max_records";
    @Deprecated
    public static final int DEFAULT_S3GUARD_METASTORE_LOCAL_MAX_RECORDS = 256;
    @InterfaceStability.Unstable
    @Deprecated
    public static final String S3GUARD_METASTORE_LOCAL_ENTRY_TTL = "fs.s3a.s3guard.local.ttl";
    @Deprecated
    public static final int DEFAULT_S3GUARD_METASTORE_LOCAL_ENTRY_TTL = 60000;
    @Deprecated
    public static final String S3GUARD_METASTORE_DYNAMO = "org.apache.hadoop.fs.s3a.s3guard.DynamoDBMetadataStore";
    @Deprecated
    public static final String S3GUARD_DISABLED_WARN_LEVEL = "fs.s3a.s3guard.disabled.warn.level";
    @Deprecated
    public static final String DEFAULT_S3GUARD_DISABLED_WARN_LEVEL = "SILENT";
    @Deprecated
    public static final String FAIL_INJECT_INCONSISTENCY_KEY = "fs.s3a.failinject.inconsistency.key.substring";
    @Deprecated
    public static final String FAIL_INJECT_INCONSISTENCY_MSEC = "fs.s3a.failinject.inconsistency.msec";
    @Deprecated
    public static final String FAIL_INJECT_INCONSISTENCY_PROBABILITY = "fs.s3a.failinject.inconsistency.probability";
    @InterfaceStability.Unstable
    public static final String LIST_VERSION = "fs.s3a.list.version";
    @InterfaceStability.Unstable
    public static final int DEFAULT_LIST_VERSION = 2;
    @InterfaceStability.Unstable
    public static final String FAIL_INJECT_THROTTLE_PROBABILITY = "fs.s3a.failinject.throttle.probability";
    @InterfaceStability.Unstable
    public static final String FAIL_INJECT_CLIENT_FACTORY = "org.apache.hadoop.fs.s3a.InconsistentS3ClientFactory";
    public static final String RETRY_LIMIT = "fs.s3a.retry.limit";
    public static final int RETRY_LIMIT_DEFAULT = 7;
    public static final String RETRY_INTERVAL = "fs.s3a.retry.interval";
    public static final String RETRY_INTERVAL_DEFAULT = "500ms";
    public static final String RETRY_THROTTLE_LIMIT = "fs.s3a.retry.throttle.limit";
    public static final int RETRY_THROTTLE_LIMIT_DEFAULT = 20;
    public static final String RETRY_THROTTLE_INTERVAL = "fs.s3a.retry.throttle.interval";
    public static final String RETRY_THROTTLE_INTERVAL_DEFAULT = "500ms";
    public static final String ETAG_CHECKSUM_ENABLED = "fs.s3a.etag.checksum.enabled";
    public static final boolean ETAG_CHECKSUM_ENABLED_DEFAULT = false;
    public static final String CHANGE_DETECT_SOURCE = "fs.s3a.change.detection.source";
    public static final String CHANGE_DETECT_SOURCE_ETAG = "etag";
    public static final String CHANGE_DETECT_SOURCE_VERSION_ID = "versionid";
    public static final String CHANGE_DETECT_SOURCE_DEFAULT = "etag";
    public static final String CHANGE_DETECT_MODE = "fs.s3a.change.detection.mode";
    public static final String CHANGE_DETECT_MODE_CLIENT = "client";
    public static final String CHANGE_DETECT_MODE_SERVER = "server";
    public static final String CHANGE_DETECT_MODE_WARN = "warn";
    public static final String CHANGE_DETECT_MODE_NONE = "none";
    public static final String CHANGE_DETECT_MODE_DEFAULT = "server";
    public static final String CHANGE_DETECT_REQUIRE_VERSION = "fs.s3a.change.detection.version.required";
    public static final boolean CHANGE_DETECT_REQUIRE_VERSION_DEFAULT = true;
    @Deprecated
    public static final String S3GUARD_CONSISTENCY_RETRY_LIMIT = "fs.s3a.s3guard.consistency.retry.limit";
    @Deprecated
    public static final int S3GUARD_CONSISTENCY_RETRY_LIMIT_DEFAULT = 7;
    @Deprecated
    public static final String S3GUARD_CONSISTENCY_RETRY_INTERVAL = "fs.s3a.s3guard.consistency.retry.interval";
    @Deprecated
    public static final String S3GUARD_CONSISTENCY_RETRY_INTERVAL_DEFAULT = "2s";
    public static final String AWS_SERVICE_IDENTIFIER_S3 = "S3";
    @Deprecated
    public static final String AWS_SERVICE_IDENTIFIER_DDB = "DDB";
    public static final String AWS_SERVICE_IDENTIFIER_STS = "STS";
    public static final int THREAD_POOL_SHUTDOWN_DELAY_SECONDS = 30;
    public static final String DIRECTORY_MARKER_POLICY = "fs.s3a.directory.marker.retention";
    public static final String DIRECTORY_MARKER_POLICY_DELETE = "delete";
    public static final String DIRECTORY_MARKER_POLICY_KEEP = "keep";
    public static final String DIRECTORY_MARKER_POLICY_AUTHORITATIVE = "authoritative";
    public static final String DEFAULT_DIRECTORY_MARKER_POLICY = "keep";
    public static final String STORE_CAPABILITY_DIRECTORY_MARKER_AWARE = "fs.s3a.capability.directory.marker.aware";
    public static final String STORE_CAPABILITY_DIRECTORY_MARKER_POLICY_KEEP = "fs.s3a.capability.directory.marker.policy.keep";
    public static final String STORE_CAPABILITY_DIRECTORY_MARKER_POLICY_DELETE = "fs.s3a.capability.directory.marker.policy.delete";
    public static final String STORE_CAPABILITY_DIRECTORY_MARKER_POLICY_AUTHORITATIVE = "fs.s3a.capability.directory.marker.policy.authoritative";
    public static final String STORE_CAPABILITY_DIRECTORY_MARKER_ACTION_KEEP = "fs.s3a.capability.directory.marker.action.keep";
    public static final String STORE_CAPABILITY_DIRECTORY_MARKER_ACTION_DELETE = "fs.s3a.capability.directory.marker.action.delete";
    public static final String XA_HEADER_PREFIX = "header.";
    public static final String AWS_REGION = "fs.s3a.endpoint.region";
    public static final String AWS_S3_CENTRAL_REGION = "us-east-1";
    public static final String AWS_S3_DEFAULT_REGION = "us-east-2";
    public static final String FIPS_ENDPOINT = "fs.s3a.endpoint.fips";
    public static final boolean ENDPOINT_FIPS_DEFAULT = false;
    public static final String AWS_S3_ACCESSPOINT_REQUIRED = "fs.s3a.accesspoint.required";
    public static final String FS_S3A_CREATE_PERFORMANCE = "fs.s3a.create.performance";
    public static final boolean FS_S3A_CREATE_PERFORMANCE_DEFAULT = false;
    public static final String FS_S3A_CREATE_PERFORMANCE_ENABLED = "fs.s3a.create.performance.enabled";
    public static final String FS_S3A_CREATE_HEADER = "fs.s3a.create.header";
    public static final String AWS_S3_VECTOR_READS_MIN_SEEK_SIZE = "fs.s3a.vectored.read.min.seek.size";
    public static final String AWS_S3_VECTOR_READS_MAX_MERGED_READ_SIZE = "fs.s3a.vectored.read.max.merged.size";
    public static final int DEFAULT_AWS_S3_VECTOR_READS_MIN_SEEK_SIZE = 4096;
    public static final int DEFAULT_AWS_S3_VECTOR_READS_MAX_MERGED_READ_SIZE = 0x100000;
    public static final String PREFETCH_ENABLED_KEY = "fs.s3a.prefetch.enabled";
    public static final boolean PREFETCH_ENABLED_DEFAULT = false;
    public static final String PREFETCH_BLOCK_SIZE_KEY = "fs.s3a.prefetch.block.size";
    public static final int PREFETCH_BLOCK_DEFAULT_SIZE = 0x800000;
    public static final String PREFETCH_BLOCK_COUNT_KEY = "fs.s3a.prefetch.block.count";
    public static final int PREFETCH_BLOCK_DEFAULT_COUNT = 8;
    public static final String AWS_AUTH_CLASS_PREFIX = "com.amazonaws.auth";
    public static final String AWS_S3_VECTOR_ACTIVE_RANGE_READS = "fs.s3a.vectored.active.ranged.reads";
    public static final int DEFAULT_AWS_S3_VECTOR_ACTIVE_RANGE_READS = 4;
    public static final String MULTIPART_UPLOADS_ENABLED = "fs.s3a.multipart.uploads.enabled";
    public static final boolean DEFAULT_MULTIPART_UPLOAD_ENABLED = true;
    public static final String STORE_CAPABILITY_MULTIPART_UPLOAD_ENABLED = "fs.s3a.capability.multipart.uploads.enabled";
    @Deprecated
    public static final String STORE_CAPABILITY_DIRECTORY_MARKER_MULTIPART_UPLOAD_ENABLED = "fs.s3a.capability.multipart.uploads.enabled";
    public static final String BUCKET_REGION_HEADER = "x-amz-bucket-region";
    public static final String DIRECTORY_OPERATIONS_PURGE_UPLOADS = "fs.s3a.directory.operations.purge.uploads";
    public static final boolean DIRECTORY_OPERATIONS_PURGE_UPLOADS_DEFAULT = false;
    public static final String COPY_FROM_LOCAL_ENABLED = "fs.s3a.copy.from.local.enabled";
    public static final boolean COPY_FROM_LOCAL_ENABLED_DEFAULT = false;
    public static final String STORE_CAPABILITY_AWS_V2 = "fs.s3a.capability.aws.v2";
    public static final String S3EXPRESS_CREATE_SESSION = "fs.s3a.s3express.create.session";
    public static final boolean S3EXPRESS_CREATE_SESSION_DEFAULT = true;
    public static final String HTTP_SIGNER_ENABLED = "fs.s3a.http.signer.enabled";
    public static final boolean HTTP_SIGNER_ENABLED_DEFAULT = false;
    public static final String HTTP_SIGNER_CLASS_NAME = "fs.s3a.http.signer.class";
    public static final String CHECKSUM_VALIDATION = "fs.s3a.checksum.validation";
    public static final boolean CHECKSUM_VALIDATION_DEFAULT = false;
    public static final int DEFAULT_S3A_IO_RATE_LIMIT = 0;
    public static final String S3A_IO_RATE_LIMIT = "fs.s3a.io.rate.limit";

    private Constants() {
    }
}

