/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import javax.annotation.Nonnull;
import software.amazon.awssdk.arns.Arn;

public final class ArnResource {
    private static final String ACCESSPOINT_ENDPOINT_FORMAT = "s3-accesspoint.%s.amazonaws.com";
    private final String name;
    private final String ownerAccountId;
    private final String region;
    private final String fullArn;
    private final String partition;
    private final String accessPointRegionKey;

    private ArnResource(String name, String owner, String region, String partition, String fullArn) {
        this.name = name;
        this.ownerAccountId = owner;
        this.region = region;
        this.partition = partition;
        this.fullArn = fullArn;
        this.accessPointRegionKey = String.format("accesspoint-%s", region);
    }

    public String getName() {
        return this.name;
    }

    public String getOwnerAccountId() {
        return this.ownerAccountId;
    }

    public String getRegion() {
        return this.region;
    }

    public String getFullArn() {
        return this.fullArn;
    }

    public String getEndpoint() {
        return String.format(ACCESSPOINT_ENDPOINT_FORMAT, this.region);
    }

    @Nonnull
    public static ArnResource accessPointFromArn(String arn) throws IllegalArgumentException {
        Arn parsed = Arn.fromString((String)arn);
        if (!parsed.region().isPresent() || !parsed.accountId().isPresent() || parsed.resourceAsString().isEmpty()) {
            throw new IllegalArgumentException(String.format("Access Point Arn %s has an invalid format or missing properties", arn));
        }
        String resourceName = parsed.resource().resource();
        return new ArnResource(resourceName, (String)parsed.accountId().get(), (String)parsed.region().get(), parsed.partition(), arn);
    }
}

