/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionException;
import javax.security.auth.Subject;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public final class SubjectUtil {
    private static final MethodHandle CALL_AS = SubjectUtil.lookupCallAs();
    static final boolean HAS_CALL_AS = CALL_AS != null;
    private static final MethodHandle DO_AS = HAS_CALL_AS ? null : SubjectUtil.lookupDoAs();
    private static final MethodHandle DO_AS_THROW_EXCEPTION = HAS_CALL_AS ? null : SubjectUtil.lookupDoAsThrowException();
    private static final MethodHandle CURRENT = SubjectUtil.lookupCurrent();

    private static MethodHandle lookupCallAs() {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            try {
                return lookup.findStatic(Subject.class, "callAs", MethodType.methodType(Object.class, Subject.class, Callable.class));
            }
            catch (NoSuchMethodException x) {
                return null;
            }
        }
        catch (IllegalAccessException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static MethodHandle lookupDoAs() {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            MethodType signature = MethodType.methodType(Object.class, Subject.class, PrivilegedAction.class);
            return lookup.findStatic(Subject.class, "doAs", signature);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static MethodHandle lookupDoAsThrowException() {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            MethodType signature = MethodType.methodType(Object.class, Subject.class, PrivilegedExceptionAction.class);
            return lookup.findStatic(Subject.class, "doAs", signature);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static MethodHandle lookupCurrent() {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            return lookup.findStatic(Subject.class, "current", MethodType.methodType(Subject.class));
        }
        catch (NoSuchMethodException e) {
            MethodHandle getContext = SubjectUtil.lookupGetContext();
            MethodHandle getSubject = SubjectUtil.lookupGetSubject();
            return MethodHandles.filterReturnValue(getContext, getSubject);
        }
        catch (IllegalAccessException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static MethodHandle lookupGetSubject() {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            Class<?> contextKlass = ClassLoader.getSystemClassLoader().loadClass("java.security.AccessControlContext");
            return lookup.findStatic(Subject.class, "getSubject", MethodType.methodType(Subject.class, contextKlass));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static MethodHandle lookupGetContext() {
        try {
            Class<?> controllerKlass = ClassLoader.getSystemClassLoader().loadClass("java.security.AccessController");
            Class<?> contextKlass = ClassLoader.getSystemClassLoader().loadClass("java.security.AccessControlContext");
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            return lookup.findStatic(controllerKlass, "getContext", MethodType.methodType(contextKlass));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static <T> T callAs(Subject subject, Callable<T> action) throws CompletionException {
        Objects.requireNonNull(action);
        if (HAS_CALL_AS) {
            try {
                return (T)CALL_AS.invoke(subject, action);
            }
            catch (Throwable t) {
                throw SubjectUtil.sneakyThrow(t);
            }
        }
        try {
            return SubjectUtil.doAs(subject, SubjectUtil.callableToPrivilegedAction(action));
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    public static <T> T doAs(Subject subject, PrivilegedAction<T> action) {
        Objects.requireNonNull(action);
        if (HAS_CALL_AS) {
            try {
                return SubjectUtil.callAs(subject, SubjectUtil.privilegedActionToCallable(action));
            }
            catch (CompletionException ce) {
                Throwable cause = ce.getCause();
                if (cause != null) {
                    throw SubjectUtil.sneakyThrow(cause);
                }
                throw ce;
            }
        }
        try {
            return (T)DO_AS.invoke(subject, action);
        }
        catch (Throwable t) {
            throw SubjectUtil.sneakyThrow(t);
        }
    }

    public static <T> T doAs(Subject subject, PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        Objects.requireNonNull(action);
        if (HAS_CALL_AS) {
            try {
                return SubjectUtil.callAs(subject, SubjectUtil.privilegedExceptionActionToCallable(action));
            }
            catch (CompletionException ce) {
                Throwable cause = ce.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Exception) {
                    throw new PrivilegedActionException((Exception)cause);
                }
                throw SubjectUtil.sneakyThrow(cause);
            }
        }
        try {
            return (T)DO_AS_THROW_EXCEPTION.invoke(subject, action);
        }
        catch (Throwable t) {
            throw SubjectUtil.sneakyThrow(t);
        }
    }

    public static Subject current() {
        try {
            return CURRENT.invoke();
        }
        catch (Throwable t) {
            throw SubjectUtil.sneakyThrow(t);
        }
    }

    private static <T> PrivilegedAction<T> callableToPrivilegedAction(Callable<T> callable) {
        return () -> {
            try {
                return callable.call();
            }
            catch (Exception e) {
                throw SubjectUtil.sneakyThrow(e);
            }
        };
    }

    private static <T> Callable<T> privilegedExceptionActionToCallable(PrivilegedExceptionAction<T> action) {
        return action::run;
    }

    private static <T> Callable<T> privilegedActionToCallable(PrivilegedAction<T> action) {
        return action::run;
    }

    static <E extends Throwable> RuntimeException sneakyThrow(Throwable e) throws E {
        throw e;
    }

    private SubjectUtil() {
    }
}

