/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.util;

import java.util.Arrays;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.imps.DefaultACLProvider;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.ConfigurableZookeeperFactory;
import org.apache.curator.utils.ZookeeperFactory;
import org.apache.hadoop.security.authentication.util.ZookeeperClient;
import org.apache.zookeeper.client.ZKClientConfig;
import org.apache.zookeeper.common.ClientX509Util;
import org.apache.zookeeper.data.ACL;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestZookeeperClientCreation {
    private ZookeeperClient clientConfigurer;
    private CuratorFrameworkFactory.Builder cfBuilder;

    @BeforeEach
    public void setup() {
        this.clientConfigurer = (ZookeeperClient)Mockito.spy((Object)ZookeeperClient.configure());
        this.clientConfigurer.withConnectionString("dummy");
        this.cfBuilder = (CuratorFrameworkFactory.Builder)Mockito.spy((Object)CuratorFrameworkFactory.builder());
        Mockito.when((Object)this.clientConfigurer.createFrameworkFactoryBuilder()).thenReturn((Object)this.cfBuilder);
    }

    @Test
    public void testConnectionStringSet() {
        this.clientConfigurer.withConnectionString("conn").create();
        ((CuratorFrameworkFactory.Builder)Mockito.verify((Object)this.cfBuilder)).connectString("conn");
        this.verifyDefaultZKFactory();
        this.verifyDefaultNamespace();
        this.verifyDefaultSessionTimeout();
        this.verifyDefaultConnectionTimeout();
        this.verifyDefaultRetryPolicy();
        this.verifyDefaultAclProvider();
        this.verifyDefaultZKClientConfig();
    }

    @Test
    public void testZookeeperFactorySet() {
        ZookeeperFactory zkFactory = (ZookeeperFactory)Mockito.mock(ZookeeperFactory.class);
        this.clientConfigurer.withZookeeperFactory(zkFactory).create();
        ((CuratorFrameworkFactory.Builder)Mockito.verify((Object)this.cfBuilder)).zookeeperFactory(zkFactory);
        this.verifyDummyConnectionString();
        this.verifyDefaultNamespace();
        this.verifyDefaultSessionTimeout();
        this.verifyDefaultConnectionTimeout();
        this.verifyDefaultRetryPolicy();
        this.verifyDefaultAclProvider();
        this.verifyDefaultZKClientConfig();
    }

    @Test
    public void testNameSpaceSet() {
        this.clientConfigurer.withNamespace("someNS/someSubSpace").create();
        ((CuratorFrameworkFactory.Builder)Mockito.verify((Object)this.cfBuilder)).namespace("someNS/someSubSpace");
        this.verifyDummyConnectionString();
        this.verifyDefaultZKFactory();
        this.verifyDefaultSessionTimeout();
        this.verifyDefaultConnectionTimeout();
        this.verifyDefaultRetryPolicy();
        this.verifyDefaultAclProvider();
        this.verifyDefaultZKClientConfig();
    }

    @Test
    public void testSessionTimeoutSet() {
        this.clientConfigurer.withSessionTimeout(20000).create();
        ((CuratorFrameworkFactory.Builder)Mockito.verify((Object)this.cfBuilder)).sessionTimeoutMs(20000);
        this.verifyDummyConnectionString();
        this.verifyDefaultZKFactory();
        this.verifyDefaultNamespace();
        this.verifyDefaultConnectionTimeout();
        this.verifyDefaultRetryPolicy();
        this.verifyDefaultAclProvider();
        this.verifyDefaultZKClientConfig();
    }

    @Test
    public void testDefaultSessionTimeoutIsAffectedBySystemProperty() {
        System.setProperty("curator-default-session-timeout", "20000");
        this.setup();
        this.clientConfigurer.create();
        ((CuratorFrameworkFactory.Builder)Mockito.verify((Object)this.cfBuilder)).sessionTimeoutMs(20000);
        this.verifyDummyConnectionString();
        this.verifyDefaultZKFactory();
        this.verifyDefaultNamespace();
        this.verifyDefaultConnectionTimeout();
        this.verifyDefaultRetryPolicy();
        this.verifyDefaultAclProvider();
        this.verifyDefaultZKClientConfig();
        System.clearProperty("curator-default-session-timeout");
    }

    @Test
    public void testConnectionTimeoutSet() {
        this.clientConfigurer.withConnectionTimeout(50).create();
        ((CuratorFrameworkFactory.Builder)Mockito.verify((Object)this.cfBuilder)).connectionTimeoutMs(50);
        this.verifyDummyConnectionString();
        this.verifyDefaultZKFactory();
        this.verifyDefaultNamespace();
        this.verifyDefaultSessionTimeout();
        this.verifyDefaultRetryPolicy();
        this.verifyDefaultAclProvider();
        this.verifyDefaultZKClientConfig();
    }

    @Test
    public void testDefaultConnectionTimeoutIsAffectedBySystemProperty() {
        System.setProperty("curator-default-connection-timeout", "50");
        this.setup();
        this.clientConfigurer.create();
        ((CuratorFrameworkFactory.Builder)Mockito.verify((Object)this.cfBuilder)).connectionTimeoutMs(50);
        this.verifyDummyConnectionString();
        this.verifyDefaultZKFactory();
        this.verifyDefaultNamespace();
        this.verifyDefaultSessionTimeout();
        this.verifyDefaultRetryPolicy();
        this.verifyDefaultAclProvider();
        this.verifyDefaultZKClientConfig();
        System.clearProperty("curator-default-connection-timeout");
    }

    @Test
    public void testRetryPolicySet() {
        RetryPolicy policy = (RetryPolicy)Mockito.mock(RetryPolicy.class);
        this.clientConfigurer.withRetryPolicy(policy).create();
        ((CuratorFrameworkFactory.Builder)Mockito.verify((Object)this.cfBuilder)).retryPolicy(policy);
        this.verifyDummyConnectionString();
        this.verifyDefaultZKFactory();
        this.verifyDefaultNamespace();
        this.verifyDefaultSessionTimeout();
        this.verifyDefaultConnectionTimeout();
        this.verifyDefaultAclProvider();
        this.verifyDefaultZKClientConfig();
    }

    @Test
    public void testSaslAutTypeWithIBMJava() {
        this.testSaslAuthType("IBMJava");
    }

    @Test
    public void testSaslAuthTypeWithNonIBMJava() {
        this.testSaslAuthType("OracleJava");
    }

    @Test
    public void testSSLConfiguration() {
        this.clientConfigurer.enableSSL(true).withKeystore("keystoreLoc").withKeystorePassword("ksPass").withTruststore("truststoreLoc").withTruststorePassword("tsPass").create();
        ArgumentCaptor clientConfCaptor = ArgumentCaptor.forClass(ZKClientConfig.class);
        ((CuratorFrameworkFactory.Builder)Mockito.verify((Object)this.cfBuilder)).zkClientConfig((ZKClientConfig)clientConfCaptor.capture());
        ZKClientConfig conf = (ZKClientConfig)clientConfCaptor.getValue();
        Assertions.assertThat((String)conf.getProperty("zookeeper.client.secure")).isEqualTo((Object)"true");
        Assertions.assertThat((String)conf.getProperty("zookeeper.clientCnxnSocket")).isEqualTo((Object)"org.apache.zookeeper.ClientCnxnSocketNetty");
        try (ClientX509Util sslOpts = new ClientX509Util();){
            Assertions.assertThat((String)conf.getProperty(sslOpts.getSslKeystoreLocationProperty())).isEqualTo((Object)"keystoreLoc");
            Assertions.assertThat((String)conf.getProperty(sslOpts.getSslKeystorePasswdProperty())).isEqualTo((Object)"ksPass");
            Assertions.assertThat((String)conf.getProperty(sslOpts.getSslTruststoreLocationProperty())).isEqualTo((Object)"truststoreLoc");
            Assertions.assertThat((String)conf.getProperty(sslOpts.getSslTruststorePasswdProperty())).isEqualTo((Object)"tsPass");
        }
        this.verifyDummyConnectionString();
        this.verifyDefaultZKFactory();
        this.verifyDefaultNamespace();
        this.verifyDefaultSessionTimeout();
        this.verifyDefaultConnectionTimeout();
        this.verifyDefaultRetryPolicy();
        this.verifyDefaultAclProvider();
    }

    @Test
    public void testNoConnectionString() {
        this.clientConfigurer.withConnectionString(null);
        Throwable t = org.junit.jupiter.api.Assertions.assertThrows(NullPointerException.class, () -> this.clientConfigurer.create());
        Assertions.assertThat((String)t.getMessage()).contains(new CharSequence[]{"Zookeeper connection string cannot be null!"});
    }

    @Test
    public void testNoRetryPolicy() {
        this.clientConfigurer.withRetryPolicy(null);
        Throwable t = org.junit.jupiter.api.Assertions.assertThrows(NullPointerException.class, () -> this.clientConfigurer.create());
        Assertions.assertThat((String)t.getMessage()).contains(new CharSequence[]{"Zookeeper connection retry policy cannot be null!"});
    }

    @Test
    public void testNoAuthType() {
        this.clientConfigurer.withAuthType(null);
        Throwable t = org.junit.jupiter.api.Assertions.assertThrows(NullPointerException.class, () -> this.clientConfigurer.create());
        Assertions.assertThat((String)t.getMessage()).contains(new CharSequence[]{"Zookeeper authType cannot be null!"});
    }

    @Test
    public void testUnrecognizedAuthType() {
        this.clientConfigurer.withAuthType("something");
        Throwable t = org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.clientConfigurer.create());
        Assertions.assertThat((String)t.getMessage()).isEqualTo((Object)"Zookeeper authType must be one of [none, sasl]!");
    }

    @Test
    public void testSaslAuthTypeWithoutKeytab() {
        this.clientConfigurer.withAuthType("sasl");
        Throwable t = org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.clientConfigurer.create());
        Assertions.assertThat((String)t.getMessage()).isEqualTo((Object)"Zookeeper client's Kerberos Keytab must be specified!");
    }

    @Test
    public void testSaslAuthTypeWithEmptyKeytab() {
        this.clientConfigurer.withAuthType("sasl").withKeytab("");
        Throwable t = org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.clientConfigurer.create());
        Assertions.assertThat((String)t.getMessage()).isEqualTo((Object)"Zookeeper client's Kerberos Keytab must be specified!");
    }

    @Test
    public void testSaslAuthTypeWithoutPrincipal() {
        this.clientConfigurer.withAuthType("sasl").withKeytab("keytabLoc");
        Throwable t = org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.clientConfigurer.create());
        Assertions.assertThat((String)t.getMessage()).isEqualTo((Object)"Zookeeper client's Kerberos Principal must be specified!");
    }

    @Test
    public void testSaslAuthTypeWithEmptyPrincipal() {
        this.clientConfigurer.withAuthType("sasl").withKeytab("keytabLoc").withPrincipal("");
        Throwable t = org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.clientConfigurer.create());
        Assertions.assertThat((String)t.getMessage()).isEqualTo((Object)"Zookeeper client's Kerberos Principal must be specified!");
    }

    @Test
    public void testSaslAuthTypeWithoutJaasLoginEntryName() {
        this.clientConfigurer.withAuthType("sasl").withKeytab("keytabLoc").withPrincipal("principal").withJaasLoginEntryName(null);
        Throwable t = org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.clientConfigurer.create());
        Assertions.assertThat((String)t.getMessage()).isEqualTo((Object)"JAAS Login Entry name must be specified!");
    }

    @Test
    public void testSaslAuthTypeWithEmptyJaasLoginEntryName() {
        this.clientConfigurer.withAuthType("sasl").withKeytab("keytabLoc").withPrincipal("principal").withJaasLoginEntryName("");
        Throwable t = org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.clientConfigurer.create());
        Assertions.assertThat((String)t.getMessage()).isEqualTo((Object)"JAAS Login Entry name must be specified!");
    }

    @Test
    public void testSSLWithoutKeystore() {
        this.clientConfigurer.enableSSL(true);
        Throwable t = org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.clientConfigurer.create());
        Assertions.assertThat((String)t.getMessage()).isEqualTo((Object)"The keystore location parameter is empty for the ZooKeeper client connection.");
    }

    @Test
    public void testSSLWithEmptyKeystore() {
        this.clientConfigurer.enableSSL(true).withKeystore("");
        Throwable t = org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.clientConfigurer.create());
        Assertions.assertThat((String)t.getMessage()).isEqualTo((Object)"The keystore location parameter is empty for the ZooKeeper client connection.");
    }

    @Test
    public void testSSLWithoutTruststore() {
        this.clientConfigurer.enableSSL(true).withKeystore("keyStoreLoc");
        Throwable t = org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.clientConfigurer.create());
        Assertions.assertThat((String)t.getMessage()).isEqualTo((Object)"The truststore location parameter is empty for the ZooKeeper client connection.");
    }

    @Test
    public void testSSLWithEmptyTruststore() {
        this.clientConfigurer.enableSSL(true).withKeystore("keyStoreLoc").withTruststore("");
        Throwable t = org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.clientConfigurer.create());
        Assertions.assertThat((String)t.getMessage()).isEqualTo((Object)"The truststore location parameter is empty for the ZooKeeper client connection.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSaslAuthType(String vendor) {
        String origVendor = System.getProperty("java.vendor");
        System.setProperty("java.vendor", vendor);
        Configuration origConf = Configuration.getConfiguration();
        try {
            this.clientConfigurer.withAuthType("sasl").withKeytab("keytabLoc").withPrincipal("principal@some.host/SOME.REALM").withJaasLoginEntryName("TestEntry").create();
            ArgumentCaptor aclProviderCaptor = ArgumentCaptor.forClass(ZookeeperClient.SASLOwnerACLProvider.class);
            ((CuratorFrameworkFactory.Builder)Mockito.verify((Object)this.cfBuilder)).aclProvider((ACLProvider)aclProviderCaptor.capture());
            ZookeeperClient.SASLOwnerACLProvider aclProvider = (ZookeeperClient.SASLOwnerACLProvider)aclProviderCaptor.getValue();
            Assertions.assertThat((int)aclProvider.getDefaultAcl().size()).isEqualTo(1);
            Assertions.assertThat((String)((ACL)aclProvider.getDefaultAcl().get(0)).getId().getScheme()).isEqualTo((Object)"sasl");
            Assertions.assertThat((String)((ACL)aclProvider.getDefaultAcl().get(0)).getId().getId()).isEqualTo((Object)"principal");
            Assertions.assertThat((int)((ACL)aclProvider.getDefaultAcl().get(0)).getPerms()).isEqualTo(31);
            Arrays.stream(new String[]{"/", "/foo", "/foo/bar/baz", "/random/path"}).forEach(s -> {
                Assertions.assertThat((int)aclProvider.getAclForPath(s).size()).isEqualTo(1);
                Assertions.assertThat((String)((ACL)aclProvider.getAclForPath(s).get(0)).getId().getScheme()).isEqualTo((Object)"sasl");
                Assertions.assertThat((String)((ACL)aclProvider.getAclForPath(s).get(0)).getId().getId()).isEqualTo((Object)"principal");
                Assertions.assertThat((int)((ACL)aclProvider.getAclForPath(s).get(0)).getPerms()).isEqualTo(31);
            });
            Assertions.assertThat((String)System.getProperty("zookeeper.sasl.clientconfig")).isEqualTo((Object)"TestEntry");
            Assertions.assertThat((String)System.getProperty("zookeeper.authProvider.1")).isEqualTo((Object)"org.apache.zookeeper.server.auth.SASLAuthenticationProvider");
            Configuration config = Configuration.getConfiguration();
            Assertions.assertThat((int)config.getAppConfigurationEntry("TestEntry").length).isEqualTo(1);
            AppConfigurationEntry entry = config.getAppConfigurationEntry("TestEntry")[0];
            Assertions.assertThat(entry.getOptions().get("keyTab")).isEqualTo((Object)"keytabLoc");
            Assertions.assertThat(entry.getOptions().get("principal")).isEqualTo((Object)"principal@some.host/SOME.REALM");
            Assertions.assertThat(entry.getOptions().get("useKeyTab")).isEqualTo((Object)"true");
            Assertions.assertThat(entry.getOptions().get("storeKey")).isEqualTo((Object)"true");
            Assertions.assertThat(entry.getOptions().get("useTicketCache")).isEqualTo((Object)"false");
            Assertions.assertThat(entry.getOptions().get("refreshKrb5Config")).isEqualTo((Object)"true");
            if (System.getProperty("java.vendor").contains("IBM")) {
                Assertions.assertThat((String)entry.getLoginModuleName()).isEqualTo((Object)"com.ibm.security.auth.module.Krb5LoginModule");
            } else {
                Assertions.assertThat((String)entry.getLoginModuleName()).isEqualTo((Object)"com.sun.security.auth.module.Krb5LoginModule");
            }
        }
        finally {
            Configuration.setConfiguration(origConf);
            System.setProperty("java.vendor", origVendor);
        }
        this.verifyDummyConnectionString();
        this.verifyDefaultZKFactory();
        this.verifyDefaultNamespace();
        this.verifyDefaultSessionTimeout();
        this.verifyDefaultConnectionTimeout();
        this.verifyDefaultRetryPolicy();
        this.verifyDefaultZKClientConfig();
    }

    private void verifyDummyConnectionString() {
        ((CuratorFrameworkFactory.Builder)Mockito.verify((Object)this.cfBuilder)).connectString("dummy");
    }

    private void verifyDefaultNamespace() {
        ((CuratorFrameworkFactory.Builder)Mockito.verify((Object)this.cfBuilder)).namespace(null);
    }

    private void verifyDefaultZKFactory() {
        ((CuratorFrameworkFactory.Builder)Mockito.verify((Object)this.cfBuilder)).zookeeperFactory((ZookeeperFactory)ArgumentMatchers.isA(ConfigurableZookeeperFactory.class));
    }

    private void verifyDefaultSessionTimeout() {
        ((CuratorFrameworkFactory.Builder)Mockito.verify((Object)this.cfBuilder)).sessionTimeoutMs(60000);
    }

    private void verifyDefaultConnectionTimeout() {
        ((CuratorFrameworkFactory.Builder)Mockito.verify((Object)this.cfBuilder)).connectionTimeoutMs(15000);
    }

    private void verifyDefaultRetryPolicy() {
        ArgumentCaptor retry = ArgumentCaptor.forClass(ExponentialBackoffRetry.class);
        ((CuratorFrameworkFactory.Builder)Mockito.verify((Object)this.cfBuilder)).retryPolicy((RetryPolicy)retry.capture());
        ExponentialBackoffRetry policy = (ExponentialBackoffRetry)retry.getValue();
        Assertions.assertThat((int)policy.getBaseSleepTimeMs()).isEqualTo(1000);
        Assertions.assertThat((int)policy.getN()).isEqualTo(3);
    }

    private void verifyDefaultAclProvider() {
        ((CuratorFrameworkFactory.Builder)Mockito.verify((Object)this.cfBuilder)).aclProvider((ACLProvider)ArgumentMatchers.isA(DefaultACLProvider.class));
    }

    private void verifyDefaultZKClientConfig() {
        ArgumentCaptor clientConfCaptor = ArgumentCaptor.forClass(ZKClientConfig.class);
        ((CuratorFrameworkFactory.Builder)Mockito.verify((Object)this.cfBuilder)).zkClientConfig((ZKClientConfig)clientConfCaptor.capture());
        ZKClientConfig conf = (ZKClientConfig)clientConfCaptor.getValue();
        Assertions.assertThat((String)conf.getProperty("zookeeper.client.secure")).satisfiesAnyOf(value -> Assertions.assertThat((String)value).isNullOrEmpty(), value -> Assertions.assertThat((String)value).isEqualTo((Object)"false"));
        try (ClientX509Util sslOpts = new ClientX509Util();){
            Assertions.assertThat((String)conf.getProperty(sslOpts.getSslKeystoreLocationProperty())).isNullOrEmpty();
            Assertions.assertThat((String)conf.getProperty(sslOpts.getSslKeystorePasswdProperty())).isNullOrEmpty();
            Assertions.assertThat((String)conf.getProperty(sslOpts.getSslTruststoreLocationProperty())).isNullOrEmpty();
            Assertions.assertThat((String)conf.getProperty(sslOpts.getSslTruststorePasswdProperty())).isNullOrEmpty();
        }
    }
}

