/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.util;

import java.io.IOException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionException;
import javax.security.auth.Subject;
import org.apache.hadoop.security.authentication.util.SubjectUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSubjectUtil {
    private static final int JAVA_SPEC_VER = Math.max(8, Integer.parseInt(System.getProperty("java.specification.version").split("\\.")[0]));

    @Test
    void testHasCallAs() {
        Assertions.assertEquals((Object)(JAVA_SPEC_VER > 17 ? 1 : 0), (Object)SubjectUtil.HAS_CALL_AS);
    }

    @Test
    void testDoAsPrivilegedActionExceptionPropagation() {
        Throwable e = Assertions.assertThrows(Exception.class, () -> SubjectUtil.doAs((Subject)SubjectUtil.current(), (PrivilegedAction)new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                RuntimeException innerE = new RuntimeException("Inner Dummy RuntimeException");
                throw SubjectUtil.sneakyThrow((Throwable)new IOException("Dummy IOException", innerE));
            }
        }));
        if (JAVA_SPEC_VER > 11) {
            Assertions.assertInstanceOf(IOException.class, (Object)e);
            Assertions.assertEquals((Object)"Dummy IOException", (Object)e.getMessage());
            Assertions.assertInstanceOf(RuntimeException.class, (Object)e.getCause());
            Assertions.assertEquals((Object)"Inner Dummy RuntimeException", (Object)e.getCause().getMessage());
            Assertions.assertNull((Object)e.getCause().getCause());
        } else {
            Assertions.assertInstanceOf(PrivilegedActionException.class, (Object)e);
            Assertions.assertNull((Object)e.getMessage());
            Assertions.assertInstanceOf(IOException.class, (Object)e.getCause());
            Assertions.assertEquals((Object)"Dummy IOException", (Object)e.getCause().getMessage());
            Assertions.assertInstanceOf(RuntimeException.class, (Object)e.getCause().getCause());
            Assertions.assertEquals((Object)"Inner Dummy RuntimeException", (Object)e.getCause().getCause().getMessage());
            Assertions.assertNull((Object)e.getCause().getCause().getCause());
        }
        e = Assertions.assertThrows(PrivilegedActionException.class, () -> SubjectUtil.doAs((Subject)SubjectUtil.current(), (PrivilegedAction)new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                throw SubjectUtil.sneakyThrow((Throwable)new PrivilegedActionException(null));
            }
        }));
        if (JAVA_SPEC_VER > 11) {
            Assertions.assertInstanceOf(PrivilegedActionException.class, (Object)e);
            Assertions.assertNull((Object)e.getMessage());
            Assertions.assertNull((Object)e.getCause());
        } else {
            Assertions.assertInstanceOf(PrivilegedActionException.class, (Object)e);
            Assertions.assertNull((Object)e.getMessage());
            Assertions.assertInstanceOf(PrivilegedActionException.class, (Object)e.getCause());
            Assertions.assertNull((Object)e.getCause().getMessage());
            Assertions.assertNull((Object)e.getCause().getCause());
        }
        e = Assertions.assertThrows(RuntimeException.class, () -> SubjectUtil.doAs((Subject)SubjectUtil.current(), (PrivilegedAction)new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                throw new RuntimeException("Dummy RuntimeException");
            }
        }));
        Assertions.assertInstanceOf(RuntimeException.class, (Object)e);
        Assertions.assertEquals((Object)"Dummy RuntimeException", (Object)e.getMessage());
        Assertions.assertNull((Object)e.getCause());
        e = Assertions.assertThrows(CompletionException.class, () -> SubjectUtil.doAs((Subject)SubjectUtil.current(), (PrivilegedAction)new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                throw new CompletionException("Dummy CompletionException", null);
            }
        }));
        Assertions.assertInstanceOf(CompletionException.class, (Object)e);
        Assertions.assertEquals((Object)"Dummy CompletionException", (Object)e.getMessage());
        Assertions.assertNull((Object)e.getCause());
        e = Assertions.assertThrows(LinkageError.class, () -> SubjectUtil.doAs((Subject)SubjectUtil.current(), (PrivilegedAction)new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                throw new LinkageError("Dummy LinkageError");
            }
        }));
        Assertions.assertInstanceOf(LinkageError.class, (Object)e);
        Assertions.assertEquals((Object)"Dummy LinkageError", (Object)e.getMessage());
        Assertions.assertNull((Object)e.getCause());
        Assertions.assertThrows(NullPointerException.class, () -> SubjectUtil.doAs((Subject)SubjectUtil.current(), (PrivilegedAction)null));
    }

    @Test
    void testDoAsPrivilegedExceptionActionExceptionPropagation() {
        Throwable e = Assertions.assertThrows(PrivilegedActionException.class, () -> SubjectUtil.doAs((Subject)SubjectUtil.current(), (PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                RuntimeException innerE = new RuntimeException("Inner Dummy RuntimeException");
                throw new IOException("Dummy IOException", innerE);
            }
        }));
        Assertions.assertInstanceOf(PrivilegedActionException.class, (Object)e);
        Assertions.assertNull((Object)e.getMessage());
        Assertions.assertInstanceOf(IOException.class, (Object)e.getCause());
        Assertions.assertEquals((Object)"Dummy IOException", (Object)e.getCause().getMessage());
        Assertions.assertInstanceOf(RuntimeException.class, (Object)e.getCause().getCause());
        Assertions.assertEquals((Object)"Inner Dummy RuntimeException", (Object)e.getCause().getCause().getMessage());
        Assertions.assertNull((Object)e.getCause().getCause().getCause());
        e = Assertions.assertThrows(PrivilegedActionException.class, () -> SubjectUtil.doAs((Subject)SubjectUtil.current(), (PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                throw new PrivilegedActionException(null);
            }
        }));
        Assertions.assertInstanceOf(PrivilegedActionException.class, (Object)e);
        Assertions.assertNull((Object)e.getMessage());
        Assertions.assertInstanceOf(PrivilegedActionException.class, (Object)e.getCause());
        Assertions.assertNull((Object)e.getCause().getMessage());
        Assertions.assertNull((Object)e.getCause().getCause());
        e = Assertions.assertThrows(RuntimeException.class, () -> SubjectUtil.doAs((Subject)SubjectUtil.current(), (PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                throw new RuntimeException("Dummy RuntimeException");
            }
        }));
        Assertions.assertInstanceOf(RuntimeException.class, (Object)e);
        Assertions.assertEquals((Object)"Dummy RuntimeException", (Object)e.getMessage());
        Assertions.assertNull((Object)e.getCause());
        e = Assertions.assertThrows(CompletionException.class, () -> SubjectUtil.doAs((Subject)SubjectUtil.current(), (PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                throw new CompletionException(null);
            }
        }));
        Assertions.assertInstanceOf(CompletionException.class, (Object)e);
        Assertions.assertNull((Object)e.getMessage());
        Assertions.assertNull((Object)e.getCause());
        e = Assertions.assertThrows(LinkageError.class, () -> SubjectUtil.doAs((Subject)SubjectUtil.current(), (PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                throw new LinkageError("Dummy LinkageError");
            }
        }));
        Assertions.assertInstanceOf(LinkageError.class, (Object)e);
        Assertions.assertEquals((Object)"Dummy LinkageError", (Object)e.getMessage());
        Assertions.assertNull((Object)e.getCause());
        Assertions.assertThrows(NullPointerException.class, () -> SubjectUtil.doAs((Subject)SubjectUtil.current(), (PrivilegedExceptionAction)null));
    }

    @Test
    void testCallAsExceptionPropagation() {
        Throwable e = Assertions.assertThrows(CompletionException.class, () -> SubjectUtil.callAs((Subject)SubjectUtil.current(), (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                RuntimeException innerE = new RuntimeException("Inner Dummy RuntimeException");
                throw new IOException("Dummy IOException", innerE);
            }
        }));
        Assertions.assertInstanceOf(CompletionException.class, (Object)e);
        if (JAVA_SPEC_VER > 11) {
            Assertions.assertEquals((Object)"java.io.IOException: Dummy IOException", (Object)e.getMessage());
            Assertions.assertInstanceOf(IOException.class, (Object)e.getCause());
            Assertions.assertEquals((Object)"Dummy IOException", (Object)e.getCause().getMessage());
            Assertions.assertInstanceOf(RuntimeException.class, (Object)e.getCause().getCause());
            Assertions.assertEquals((Object)"Inner Dummy RuntimeException", (Object)e.getCause().getCause().getMessage());
            Assertions.assertNull((Object)e.getCause().getCause().getCause());
        } else {
            Assertions.assertEquals((Object)"java.security.PrivilegedActionException: java.io.IOException: Dummy IOException", (Object)e.getMessage());
            Assertions.assertInstanceOf(PrivilegedActionException.class, (Object)e.getCause());
            Assertions.assertNull((Object)e.getCause().getMessage());
            Assertions.assertInstanceOf(IOException.class, (Object)e.getCause().getCause());
            Assertions.assertEquals((Object)"Dummy IOException", (Object)e.getCause().getCause().getMessage());
            Assertions.assertInstanceOf(RuntimeException.class, (Object)e.getCause().getCause().getCause());
            Assertions.assertEquals((Object)"Inner Dummy RuntimeException", (Object)e.getCause().getCause().getCause().getMessage());
            Assertions.assertNull((Object)e.getCause().getCause().getCause().getCause());
        }
        e = Assertions.assertThrows(CompletionException.class, () -> SubjectUtil.callAs((Subject)SubjectUtil.current(), (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                throw new PrivilegedActionException(null);
            }
        }));
        Assertions.assertInstanceOf(CompletionException.class, (Object)e);
        if (JAVA_SPEC_VER > 11) {
            Assertions.assertEquals((Object)"java.security.PrivilegedActionException", (Object)e.getMessage());
            Assertions.assertInstanceOf(PrivilegedActionException.class, (Object)e.getCause());
            Assertions.assertNull((Object)e.getCause().getMessage());
            Assertions.assertNull((Object)e.getCause().getCause());
        } else {
            Assertions.assertEquals((Object)"java.security.PrivilegedActionException: java.security.PrivilegedActionException", (Object)e.getMessage());
            Assertions.assertInstanceOf(PrivilegedActionException.class, (Object)e.getCause());
            Assertions.assertNull((Object)e.getCause().getMessage());
            Assertions.assertInstanceOf(PrivilegedActionException.class, (Object)e.getCause().getCause());
            Assertions.assertNull((Object)e.getCause().getCause().getMessage());
            Assertions.assertNull((Object)e.getCause().getCause().getCause());
        }
        e = Assertions.assertThrows(CompletionException.class, () -> SubjectUtil.callAs((Subject)SubjectUtil.current(), (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                throw new RuntimeException("Dummy RuntimeException");
            }
        }));
        Assertions.assertInstanceOf(CompletionException.class, (Object)e);
        Assertions.assertEquals((Object)"java.lang.RuntimeException: Dummy RuntimeException", (Object)e.getMessage());
        Assertions.assertInstanceOf(RuntimeException.class, (Object)e.getCause());
        Assertions.assertEquals((Object)"Dummy RuntimeException", (Object)e.getCause().getMessage());
        Assertions.assertNull((Object)e.getCause().getCause());
        e = Assertions.assertThrows(CompletionException.class, () -> SubjectUtil.callAs((Subject)SubjectUtil.current(), (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                throw new CompletionException(null);
            }
        }));
        Assertions.assertInstanceOf(CompletionException.class, (Object)e);
        Assertions.assertEquals((Object)"java.util.concurrent.CompletionException", (Object)e.getMessage());
        Assertions.assertInstanceOf(CompletionException.class, (Object)e.getCause());
        Assertions.assertNull((Object)e.getCause().getMessage());
        e = Assertions.assertThrows(LinkageError.class, () -> SubjectUtil.callAs((Subject)SubjectUtil.current(), (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                throw new LinkageError("Dummy LinkageError");
            }
        }));
        Assertions.assertInstanceOf(LinkageError.class, (Object)e);
        Assertions.assertEquals((Object)"Dummy LinkageError", (Object)e.getMessage());
        Assertions.assertNull((Object)e.getCause());
        Assertions.assertThrows(NullPointerException.class, () -> SubjectUtil.callAs((Subject)SubjectUtil.current(), null));
    }

    @Test
    void testSneakyThrow() {
        IOException e = (IOException)Assertions.assertThrows(IOException.class, this::throwCheckedException);
        Assertions.assertEquals((Object)"Dummy IOException", (Object)e.getMessage());
    }

    private void throwCheckedException() {
        throw SubjectUtil.sneakyThrow((Throwable)new IOException("Dummy IOException"));
    }
}

