/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.util;

import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.hadoop.security.authentication.util.Signer;
import org.apache.hadoop.security.authentication.util.SignerException;
import org.apache.hadoop.security.authentication.util.SignerSecretProvider;
import org.apache.hadoop.security.authentication.util.StringSignerSecretProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSigner {
    @Test
    public void testNullAndEmptyString() throws Exception {
        Signer signer = new Signer((SignerSecretProvider)this.createStringSignerSecretProvider());
        try {
            signer.sign(null);
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Throwable ex) {
            Assertions.fail();
        }
        try {
            signer.sign("");
            Assertions.fail();
        }
        catch (IllegalArgumentException ex) {
        }
        catch (Throwable ex) {
            Assertions.fail();
        }
    }

    @Test
    public void testSignature() throws Exception {
        Signer signer = new Signer((SignerSecretProvider)this.createStringSignerSecretProvider());
        String s1 = signer.sign("ok");
        String s2 = signer.sign("ok");
        String s3 = signer.sign("wrong");
        Assertions.assertEquals((Object)s1, (Object)s2);
        Assertions.assertNotEquals((Object)s1, (Object)s3);
    }

    @Test
    public void testVerify() throws Exception {
        Signer signer = new Signer((SignerSecretProvider)this.createStringSignerSecretProvider());
        String t = "test";
        String s = signer.sign(t);
        String e = signer.verifyAndExtract(s);
        Assertions.assertEquals((Object)t, (Object)e);
    }

    @Test
    public void testInvalidSignedText() throws Exception {
        Signer signer = new Signer((SignerSecretProvider)this.createStringSignerSecretProvider());
        try {
            signer.verifyAndExtract("test");
            Assertions.fail();
        }
        catch (SignerException signerException) {
        }
        catch (Throwable ex) {
            Assertions.fail();
        }
    }

    @Test
    public void testTampering() throws Exception {
        Signer signer = new Signer((SignerSecretProvider)this.createStringSignerSecretProvider());
        String t = "test";
        Object s = signer.sign(t);
        s = (String)s + "x";
        try {
            signer.verifyAndExtract((String)s);
            Assertions.fail();
        }
        catch (SignerException signerException) {
        }
        catch (Throwable ex) {
            Assertions.fail();
        }
    }

    private StringSignerSecretProvider createStringSignerSecretProvider() throws Exception {
        StringSignerSecretProvider secretProvider = new StringSignerSecretProvider();
        Properties secretProviderProps = new Properties();
        secretProviderProps.setProperty("signature.secret", "secret");
        secretProvider.init(secretProviderProps, null, -1L);
        return secretProvider;
    }

    @Test
    public void testMultipleSecrets() throws Exception {
        TestSignerSecretProvider secretProvider = new TestSignerSecretProvider();
        Signer signer = new Signer((SignerSecretProvider)secretProvider);
        secretProvider.setCurrentSecret("secretB");
        String t1 = "test";
        String s1 = signer.sign(t1);
        String e1 = signer.verifyAndExtract(s1);
        Assertions.assertEquals((Object)t1, (Object)e1);
        secretProvider.setPreviousSecret("secretA");
        String t2 = "test";
        String s2 = signer.sign(t2);
        String e2 = signer.verifyAndExtract(s2);
        Assertions.assertEquals((Object)t2, (Object)e2);
        Assertions.assertEquals((Object)s1, (Object)s2);
        secretProvider.setCurrentSecret("secretC");
        secretProvider.setPreviousSecret("secretB");
        String t3 = "test";
        String s3 = signer.sign(t3);
        String e3 = signer.verifyAndExtract(s3);
        Assertions.assertEquals((Object)t3, (Object)e3);
        Assertions.assertNotEquals((Object)s1, (Object)s3);
        String e1b = signer.verifyAndExtract(s1);
        Assertions.assertEquals((Object)t1, (Object)e1b);
        secretProvider.setCurrentSecret("secretD");
        secretProvider.setPreviousSecret("secretC");
        try {
            signer.verifyAndExtract(s1);
            Assertions.fail();
        }
        catch (SignerException signerException) {
            // empty catch block
        }
    }

    class TestSignerSecretProvider
    extends SignerSecretProvider {
        private byte[] currentSecret;
        private byte[] previousSecret;

        TestSignerSecretProvider() {
        }

        public void init(Properties config, ServletContext servletContext, long tokenValidity) {
        }

        public byte[] getCurrentSecret() {
            return this.currentSecret;
        }

        public byte[][] getAllSecrets() {
            return new byte[][]{this.currentSecret, this.previousSecret};
        }

        public void setCurrentSecret(String secretStr) {
            this.currentSecret = secretStr.getBytes();
        }

        public void setPreviousSecret(String previousSecretStr) {
            this.previousSecret = previousSecretStr.getBytes();
        }
    }
}

