/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.util;

import org.apache.hadoop.security.authentication.util.RolloverSignerSecretProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRolloverSignerSecretProvider {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetAndRollSecrets() throws Exception {
        long rolloverFrequency = 15000L;
        byte[] secret1 = "doctor".getBytes();
        byte[] secret2 = "who".getBytes();
        byte[] secret3 = "tardis".getBytes();
        TRolloverSignerSecretProvider secretProvider = new TRolloverSignerSecretProvider(new byte[][]{secret1, secret2, secret3});
        try {
            secretProvider.init(null, null, rolloverFrequency);
            byte[] currentSecret = secretProvider.getCurrentSecret();
            byte[][] allSecrets = secretProvider.getAllSecrets();
            Assertions.assertArrayEquals((byte[])secret1, (byte[])currentSecret);
            Assertions.assertEquals((int)2, (int)allSecrets.length);
            Assertions.assertArrayEquals((byte[])secret1, (byte[])allSecrets[0]);
            Assertions.assertNull((Object)allSecrets[1]);
            Thread.sleep(rolloverFrequency + 2000L);
            currentSecret = secretProvider.getCurrentSecret();
            allSecrets = secretProvider.getAllSecrets();
            Assertions.assertArrayEquals((byte[])secret2, (byte[])currentSecret);
            Assertions.assertEquals((int)2, (int)allSecrets.length);
            Assertions.assertArrayEquals((byte[])secret2, (byte[])allSecrets[0]);
            Assertions.assertArrayEquals((byte[])secret1, (byte[])allSecrets[1]);
            Thread.sleep(rolloverFrequency + 2000L);
            currentSecret = secretProvider.getCurrentSecret();
            allSecrets = secretProvider.getAllSecrets();
            Assertions.assertArrayEquals((byte[])secret3, (byte[])currentSecret);
            Assertions.assertEquals((int)2, (int)allSecrets.length);
            Assertions.assertArrayEquals((byte[])secret3, (byte[])allSecrets[0]);
            Assertions.assertArrayEquals((byte[])secret2, (byte[])allSecrets[1]);
            Thread.sleep(rolloverFrequency + 2000L);
        }
        finally {
            secretProvider.destroy();
        }
    }

    class TRolloverSignerSecretProvider
    extends RolloverSignerSecretProvider {
        private byte[][] newSecretSequence;
        private int newSecretSequenceIndex;

        public TRolloverSignerSecretProvider(byte[][] newSecretSequence) throws Exception {
            this.newSecretSequence = newSecretSequence;
            this.newSecretSequenceIndex = 0;
        }

        protected byte[] generateNewSecret() {
            return this.newSecretSequence[this.newSecretSequenceIndex++];
        }
    }
}

