/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.util;

import java.util.Random;
import org.apache.hadoop.security.authentication.util.RandomSignerSecretProvider;
import org.apache.hadoop.security.authentication.util.RolloverSignerSecretProvider;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestRandomSignerSecretProvider {
    private final int timeout = 500;
    private final long rolloverFrequency = 250L;

    public TestRandomSignerSecretProvider() {
        LogManager.getLogger((String)RolloverSignerSecretProvider.LOG.getName()).setLevel(Level.DEBUG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetAndRollSecrets() throws Exception {
        long seed = System.currentTimeMillis();
        Random rand = new Random(seed);
        byte[] secret1 = this.generateNewSecret(rand);
        byte[] secret2 = this.generateNewSecret(rand);
        byte[] secret3 = this.generateNewSecret(rand);
        MockRandomSignerSecretProvider secretProvider = (MockRandomSignerSecretProvider)((Object)Mockito.spy((Object)((Object)new MockRandomSignerSecretProvider(seed))));
        try {
            secretProvider.init(null, null, 250L);
            byte[] currentSecret = secretProvider.getCurrentSecret();
            byte[][] allSecrets = secretProvider.getAllSecrets();
            Assertions.assertArrayEquals((byte[])secret1, (byte[])currentSecret);
            Assertions.assertEquals((int)2, (int)allSecrets.length);
            Assertions.assertArrayEquals((byte[])secret1, (byte[])allSecrets[0]);
            Assertions.assertNull((Object)allSecrets[1]);
            ((MockRandomSignerSecretProvider)((Object)Mockito.verify((Object)((Object)secretProvider), (VerificationMode)Mockito.timeout((long)500L).atLeastOnce()))).rollSecret();
            secretProvider.realRollSecret();
            currentSecret = secretProvider.getCurrentSecret();
            allSecrets = secretProvider.getAllSecrets();
            Assertions.assertArrayEquals((byte[])secret2, (byte[])currentSecret);
            Assertions.assertEquals((int)2, (int)allSecrets.length);
            Assertions.assertArrayEquals((byte[])secret2, (byte[])allSecrets[0]);
            Assertions.assertArrayEquals((byte[])secret1, (byte[])allSecrets[1]);
            ((MockRandomSignerSecretProvider)((Object)Mockito.verify((Object)((Object)secretProvider), (VerificationMode)Mockito.timeout((long)500L).atLeast(2)))).rollSecret();
            secretProvider.realRollSecret();
            currentSecret = secretProvider.getCurrentSecret();
            allSecrets = secretProvider.getAllSecrets();
            Assertions.assertArrayEquals((byte[])secret3, (byte[])currentSecret);
            Assertions.assertEquals((int)2, (int)allSecrets.length);
            Assertions.assertArrayEquals((byte[])secret3, (byte[])allSecrets[0]);
            Assertions.assertArrayEquals((byte[])secret2, (byte[])allSecrets[1]);
            ((MockRandomSignerSecretProvider)((Object)Mockito.verify((Object)((Object)secretProvider), (VerificationMode)Mockito.timeout((long)500L).atLeast(3)))).rollSecret();
            secretProvider.realRollSecret();
        }
        finally {
            secretProvider.destroy();
        }
    }

    private byte[] generateNewSecret(Random rand) {
        byte[] secret = new byte[32];
        rand.nextBytes(secret);
        return secret;
    }

    private class MockRandomSignerSecretProvider
    extends RandomSignerSecretProvider {
        MockRandomSignerSecretProvider(long seed) {
            super(seed);
        }

        protected synchronized void rollSecret() {
        }

        public void realRollSecret() {
            super.rollSecret();
        }
    }
}

