/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.util;

import java.io.IOException;
import org.apache.hadoop.security.authentication.KerberosTestUtils;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestKerberosName {
    @BeforeEach
    public void setUp() throws Exception {
        System.setProperty("java.security.krb5.realm", KerberosTestUtils.getRealm());
        System.setProperty("java.security.krb5.kdc", "localhost:88");
        String rules = "RULE:[1:$1@$0](.*@YAHOO\\.COM)s/@.*//\nRULE:[2:$1](johndoe)s/^.*$/guest/\nRULE:[2:$1;$2](^.*;admin$)s/;admin$//\nRULE:[2:$2](root)\nDEFAULT";
        KerberosName.setRuleMechanism((String)"hadoop");
        KerberosName.setRules((String)rules);
        KerberosName.printRules();
    }

    private void checkTranslation(String from, String to) throws Exception {
        System.out.println("Translate " + from);
        KerberosName nm = new KerberosName(from);
        String simple = nm.getShortName();
        System.out.println("to " + simple);
        Assertions.assertEquals((Object)to, (Object)simple, (String)"short name incorrect");
    }

    @Test
    public void testRules() throws Exception {
        this.checkTranslation("omalley@" + KerberosTestUtils.getRealm(), "omalley");
        this.checkTranslation("hdfs/10.0.0.1@" + KerberosTestUtils.getRealm(), "hdfs");
        this.checkTranslation("oom@YAHOO.COM", "oom");
        this.checkTranslation("johndoe/zoo@FOO.COM", "guest");
        this.checkTranslation("joe/admin@FOO.COM", "joe");
        this.checkTranslation("joe/root@FOO.COM", "root");
    }

    private void checkBadName(String name) {
        System.out.println("Checking " + name + " to ensure it is bad.");
        try {
            new KerberosName(name);
            Assertions.fail((String)("didn't get exception for " + name));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkBadTranslation(String from) {
        System.out.println("Checking bad translation for " + from);
        KerberosName nm = new KerberosName(from);
        try {
            nm.getShortName();
            Assertions.fail((String)("didn't get exception for " + from));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testAntiPatterns() throws Exception {
        KerberosName.setRuleMechanism((String)"hadoop");
        this.checkBadName("owen/owen/owen@FOO.COM");
        this.checkBadName("owen@foo/bar.com");
        this.checkBadTranslation("foo@ACME.COM");
        this.checkBadTranslation("root/joe@FOO.COM");
        KerberosName.setRuleMechanism((String)"mit");
        this.checkTranslation("foo@ACME.COM", "foo@ACME.COM");
        this.checkTranslation("root/joe@FOO.COM", "root/joe@FOO.COM");
    }

    @Test
    public void testParsing() throws Exception {
        String principalNameFull = "HTTP/abc.com@EXAMPLE.COM";
        String principalNameWoRealm = "HTTP/abc.com";
        String principalNameWoHost = "HTTP@EXAMPLE.COM";
        KerberosName kerbNameFull = new KerberosName("HTTP/abc.com@EXAMPLE.COM");
        Assertions.assertEquals((Object)"HTTP", (Object)kerbNameFull.getServiceName());
        Assertions.assertEquals((Object)"abc.com", (Object)kerbNameFull.getHostName());
        Assertions.assertEquals((Object)"EXAMPLE.COM", (Object)kerbNameFull.getRealm());
        KerberosName kerbNamewoRealm = new KerberosName("HTTP/abc.com");
        Assertions.assertEquals((Object)"HTTP", (Object)kerbNamewoRealm.getServiceName());
        Assertions.assertEquals((Object)"abc.com", (Object)kerbNamewoRealm.getHostName());
        Assertions.assertEquals(null, (Object)kerbNamewoRealm.getRealm());
        KerberosName kerbNameWoHost = new KerberosName("HTTP@EXAMPLE.COM");
        Assertions.assertEquals((Object)"HTTP", (Object)kerbNameWoHost.getServiceName());
        Assertions.assertEquals(null, (Object)kerbNameWoHost.getHostName());
        Assertions.assertEquals((Object)"EXAMPLE.COM", (Object)kerbNameWoHost.getRealm());
    }

    @Test
    public void testToLowerCase() throws Exception {
        String rules = "RULE:[1:$1]/L\nRULE:[2:$1]/L\nRULE:[2:$1;$2](^.*;admin$)s/;admin$///L\nRULE:[2:$1;$2](^.*;guest$)s/;guest$//g/L\nDEFAULT";
        KerberosName.setRules((String)rules);
        KerberosName.printRules();
        this.checkTranslation("Joe@FOO.COM", "joe");
        this.checkTranslation("Joe/root@FOO.COM", "joe");
        this.checkTranslation("Joe/admin@FOO.COM", "joe");
        this.checkTranslation("Joe/guestguest@FOO.COM", "joe");
    }

    @Test
    public void testInvalidRuleMechanism() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> KerberosName.setRuleMechanism((String)"INVALID_MECHANISM"));
    }

    @AfterEach
    public void clear() {
        System.clearProperty("java.security.krb5.realm");
        System.clearProperty("java.security.krb5.kdc");
    }
}

