/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.util;

import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.hadoop.security.authentication.util.JaasConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestJaasConfiguration {
    @Test
    public void test() throws Exception {
        String krb5LoginModuleName = System.getProperty("java.vendor").contains("IBM") ? "com.ibm.security.auth.module.Krb5LoginModule" : "com.sun.security.auth.module.Krb5LoginModule";
        JaasConfiguration jConf = new JaasConfiguration("foo", "foo/localhost", "/some/location/foo.keytab");
        AppConfigurationEntry[] entries = jConf.getAppConfigurationEntry("bar");
        Assertions.assertNull((Object)entries);
        entries = jConf.getAppConfigurationEntry("foo");
        Assertions.assertEquals((int)1, (int)entries.length);
        AppConfigurationEntry entry = entries[0];
        Assertions.assertEquals((Object)AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, (Object)entry.getControlFlag());
        Assertions.assertEquals((Object)krb5LoginModuleName, (Object)entry.getLoginModuleName());
        Map<String, ?> options = entry.getOptions();
        Assertions.assertEquals((Object)"/some/location/foo.keytab", options.get("keyTab"));
        Assertions.assertEquals((Object)"foo/localhost", options.get("principal"));
        Assertions.assertEquals((Object)"true", options.get("useKeyTab"));
        Assertions.assertEquals((Object)"true", options.get("storeKey"));
        Assertions.assertEquals((Object)"false", options.get("useTicketCache"));
        Assertions.assertEquals((Object)"true", options.get("refreshKrb5Config"));
        Assertions.assertEquals((int)6, (int)options.size());
    }
}

