/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.util;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Properties;
import org.apache.hadoop.security.authentication.util.FileSignerSecretProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestFileSignerSecretProvider {
    @Test
    public void testGetSecrets() throws Exception {
        File testDir = new File(System.getProperty("test.build.data", "target/test-dir"));
        testDir.mkdirs();
        String secretValue = "hadoop";
        File secretFile = new File(testDir, "http-secret.txt");
        FileWriter writer = new FileWriter(secretFile);
        writer.write(secretValue);
        ((Writer)writer).close();
        FileSignerSecretProvider secretProvider = new FileSignerSecretProvider();
        Properties secretProviderProps = new Properties();
        secretProviderProps.setProperty("signature.secret.file", secretFile.getAbsolutePath());
        secretProvider.init(secretProviderProps, null, -1L);
        Assertions.assertArrayEquals((byte[])secretValue.getBytes(), (byte[])secretProvider.getCurrentSecret());
        byte[][] allSecrets = secretProvider.getAllSecrets();
        Assertions.assertEquals((int)1, (int)allSecrets.length);
        Assertions.assertArrayEquals((byte[])secretValue.getBytes(), (byte[])allSecrets[0]);
    }

    @Test
    public void testEmptySecretFileThrows() throws Exception {
        File secretFile = File.createTempFile("test_empty_secret", ".txt");
        Assertions.assertTrue((boolean)secretFile.exists());
        FileSignerSecretProvider secretProvider = new FileSignerSecretProvider();
        Properties secretProviderProps = new Properties();
        secretProviderProps.setProperty("signature.secret.file", secretFile.getAbsolutePath());
        Exception exception = (Exception)Assertions.assertThrows(RuntimeException.class, () -> secretProvider.init(secretProviderProps, null, -1L));
        Assertions.assertTrue((boolean)exception.getMessage().startsWith("No secret in signature secret file:"));
    }
}

