/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.util;

import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.util.AuthToken;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestAuthToken {
    @Test
    public void testConstructor() throws Exception {
        try {
            new AuthToken(null, "p", "t");
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Throwable ex) {
            Assertions.fail();
        }
        try {
            new AuthToken("", "p", "t");
            Assertions.fail();
        }
        catch (IllegalArgumentException ex) {
        }
        catch (Throwable ex) {
            Assertions.fail();
        }
        try {
            new AuthToken("u", null, "t");
            Assertions.fail();
        }
        catch (IllegalArgumentException ex) {
        }
        catch (Throwable ex) {
            Assertions.fail();
        }
        try {
            new AuthToken("u", "", "t");
            Assertions.fail();
        }
        catch (IllegalArgumentException ex) {
        }
        catch (Throwable ex) {
            Assertions.fail();
        }
        try {
            new AuthToken("u", "p", null);
            Assertions.fail();
        }
        catch (IllegalArgumentException ex) {
        }
        catch (Throwable ex) {
            Assertions.fail();
        }
        try {
            new AuthToken("u", "p", "");
            Assertions.fail();
        }
        catch (IllegalArgumentException ex) {
        }
        catch (Throwable ex) {
            Assertions.fail();
        }
        new AuthToken("u", "p", "t");
    }

    @Test
    public void testGetters() throws Exception {
        long expires = System.currentTimeMillis() + 50L;
        AuthToken token = new AuthToken("u", "p", "t");
        token.setExpires(expires);
        Assertions.assertEquals((Object)"u", (Object)token.getUserName());
        Assertions.assertEquals((Object)"p", (Object)token.getName());
        Assertions.assertEquals((Object)"t", (Object)token.getType());
        Assertions.assertEquals((long)expires, (long)token.getExpires());
        Assertions.assertFalse((boolean)token.isExpired());
        Thread.sleep(70L);
        Assertions.assertTrue((boolean)token.isExpired());
    }

    @Test
    public void testToStringAndParse() throws Exception {
        long expires = System.currentTimeMillis() + 50L;
        AuthToken token = new AuthToken("u", "p", "t");
        token.setExpires(expires);
        String str = token.toString();
        token = AuthToken.parse((String)str);
        Assertions.assertEquals((Object)"p", (Object)token.getName());
        Assertions.assertEquals((Object)"t", (Object)token.getType());
        Assertions.assertEquals((long)expires, (long)token.getExpires());
        Assertions.assertFalse((boolean)token.isExpired());
        Thread.sleep(70L);
        Assertions.assertTrue((boolean)token.isExpired());
    }

    @Test
    public void testParseValidAndInvalid() throws Exception {
        long expires = System.currentTimeMillis() + 50L;
        AuthToken token = new AuthToken("u", "p", "t");
        token.setExpires(expires);
        String ostr = token.toString();
        String str1 = "\"" + ostr + "\"";
        AuthToken.parse((String)str1);
        String str2 = ostr + "&s=1234";
        AuthToken.parse((String)str2);
        String str = ostr.substring(0, ostr.indexOf("e="));
        try {
            AuthToken.parse((String)str);
            Assertions.fail();
        }
        catch (AuthenticationException authenticationException) {
        }
        catch (Exception ex) {
            Assertions.fail();
        }
    }
}

