/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.server;

import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.authentication.server.PseudoAuthenticationHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestPseudoAuthenticationHandler {
    @Test
    public void testInit() throws Exception {
        PseudoAuthenticationHandler handler = new PseudoAuthenticationHandler();
        try {
            Properties props = new Properties();
            props.setProperty("simple.anonymous.allowed", "false");
            handler.init(props);
            Assertions.assertEquals((Object)false, (Object)handler.getAcceptAnonymous());
        }
        finally {
            handler.destroy();
        }
    }

    @Test
    public void testType() throws Exception {
        PseudoAuthenticationHandler handler = new PseudoAuthenticationHandler();
        Assertions.assertEquals((Object)"simple", (Object)handler.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAnonymousOn() throws Exception {
        PseudoAuthenticationHandler handler = new PseudoAuthenticationHandler();
        try {
            Properties props = new Properties();
            props.setProperty("simple.anonymous.allowed", "true");
            handler.init(props);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            AuthenticationToken token = handler.authenticate(request, response);
            Assertions.assertEquals((Object)AuthenticationToken.ANONYMOUS, (Object)token);
        }
        finally {
            handler.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAnonymousOff() throws Exception {
        PseudoAuthenticationHandler handler = new PseudoAuthenticationHandler();
        try {
            Properties props = new Properties();
            props.setProperty("simple.anonymous.allowed", "false");
            handler.init(props);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            AuthenticationToken token = handler.authenticate(request, response);
            Assertions.assertNull((Object)token);
        }
        finally {
            handler.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _testUserName(boolean anonymous) throws Exception {
        PseudoAuthenticationHandler handler = new PseudoAuthenticationHandler();
        try {
            Properties props = new Properties();
            props.setProperty("simple.anonymous.allowed", Boolean.toString(anonymous));
            handler.init(props);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            Mockito.when((Object)request.getQueryString()).thenReturn((Object)"user.name=user");
            AuthenticationToken token = handler.authenticate(request, response);
            Assertions.assertNotNull((Object)token);
            Assertions.assertEquals((Object)"user", (Object)token.getUserName());
            Assertions.assertEquals((Object)"user", (Object)token.getName());
            Assertions.assertEquals((Object)"simple", (Object)token.getType());
        }
        finally {
            handler.destroy();
        }
    }

    @Test
    public void testUserNameAnonymousOff() throws Exception {
        this._testUserName(false);
    }

    @Test
    public void testUserNameAnonymousOn() throws Exception {
        this._testUserName(true);
    }
}

