/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.server;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.io.File;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.minikdc.KerberosSecurityTestcase;
import org.apache.hadoop.security.authentication.KerberosTestUtils;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.authentication.server.JWTRedirectAuthenticationHandler;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestJWTRedirectAuthenticationHandler
extends KerberosSecurityTestcase {
    private static final String SERVICE_URL = "https://localhost:8888/resource";
    private static final String REDIRECT_LOCATION = "https://localhost:8443/authserver?originalUrl=https://localhost:8888/resource";
    RSAPublicKey publicKey = null;
    RSAPrivateKey privateKey = null;
    JWTRedirectAuthenticationHandler handler = null;

    @Test
    public void testNoPublicKeyJWT() throws Exception {
        try {
            Properties props = this.getProperties();
            this.handler.init(props);
            SignedJWT jwt = this.getJWT("bob", new Date(new Date().getTime() + 5000L), this.privateKey);
            Cookie cookie = new Cookie("hadoop-jwt", jwt.serialize());
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
            Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer(SERVICE_URL));
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            Mockito.when((Object)response.encodeRedirectURL(SERVICE_URL)).thenReturn((Object)SERVICE_URL);
            AuthenticationToken token = this.handler.alternateAuthenticate(request, response);
            Assertions.fail((String)"alternateAuthentication should have thrown a ServletException");
        }
        catch (ServletException se) {
            Assertions.assertTrue((boolean)se.getMessage().contains("Public key for signature validation must be provisioned"));
        }
        catch (AuthenticationException ae) {
            Assertions.fail((String)"alternateAuthentication should NOT have thrown a AuthenticationException");
        }
    }

    @Test
    public void testCustomCookieNameJWT() throws Exception {
        try {
            this.handler.setPublicKey(this.publicKey);
            Properties props = this.getProperties();
            props.put("jwt.cookie.name", "jowt");
            this.handler.init(props);
            SignedJWT jwt = this.getJWT("bob", new Date(new Date().getTime() + 5000L), this.privateKey);
            Cookie cookie = new Cookie("jowt", jwt.serialize());
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
            Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer(SERVICE_URL));
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            Mockito.when((Object)response.encodeRedirectURL(SERVICE_URL)).thenReturn((Object)SERVICE_URL);
            AuthenticationToken token = this.handler.alternateAuthenticate(request, response);
            Assertions.assertEquals((Object)"bob", (Object)token.getUserName());
        }
        catch (ServletException se) {
            Assertions.fail((String)("alternateAuthentication should NOT have thrown a ServletException: " + se.getMessage()));
        }
        catch (AuthenticationException ae) {
            Assertions.fail((String)"alternateAuthentication should NOT have thrown a AuthenticationException");
        }
    }

    @Test
    public void testNoProviderURLJWT() throws Exception {
        try {
            this.handler.setPublicKey(this.publicKey);
            Properties props = this.getProperties();
            props.remove("authentication.provider.url");
            this.handler.init(props);
            SignedJWT jwt = this.getJWT("bob", new Date(new Date().getTime() + 5000L), this.privateKey);
            Cookie cookie = new Cookie("hadoop-jwt", jwt.serialize());
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
            Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer(SERVICE_URL));
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            Mockito.when((Object)response.encodeRedirectURL(SERVICE_URL)).thenReturn((Object)SERVICE_URL);
            AuthenticationToken token = this.handler.alternateAuthenticate(request, response);
            Assertions.fail((String)"alternateAuthentication should have thrown an AuthenticationException");
        }
        catch (ServletException se) {
            Assertions.assertTrue((boolean)se.getMessage().contains("Authentication provider URL must not be null"));
        }
        catch (AuthenticationException ae) {
            Assertions.fail((String)"alternateAuthentication should NOT have thrown a AuthenticationException");
        }
    }

    @Test
    public void testUnableToParseJWT() throws Exception {
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
            kpg.initialize(2048);
            KeyPair kp = kpg.genKeyPair();
            RSAPublicKey publicKey = (RSAPublicKey)kp.getPublic();
            this.handler.setPublicKey(publicKey);
            Properties props = this.getProperties();
            this.handler.init(props);
            SignedJWT jwt = this.getJWT("bob", new Date(new Date().getTime() + 5000L), this.privateKey);
            Cookie cookie = new Cookie("hadoop-jwt", "ljm" + jwt.serialize());
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
            Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer(SERVICE_URL));
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            Mockito.when((Object)response.encodeRedirectURL(SERVICE_URL)).thenReturn((Object)SERVICE_URL);
            AuthenticationToken token = this.handler.alternateAuthenticate(request, response);
            ((HttpServletResponse)Mockito.verify((Object)response)).sendRedirect(REDIRECT_LOCATION);
        }
        catch (ServletException se) {
            Assertions.fail((String)"alternateAuthentication should NOT have thrown a ServletException");
        }
        catch (AuthenticationException ae) {
            Assertions.fail((String)"alternateAuthentication should NOT have thrown a AuthenticationException");
        }
    }

    @Test
    public void testFailedSignatureValidationJWT() throws Exception {
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
            kpg.initialize(2048);
            KeyPair kp = kpg.genKeyPair();
            RSAPublicKey publicKey = (RSAPublicKey)kp.getPublic();
            this.handler.setPublicKey(publicKey);
            Properties props = this.getProperties();
            this.handler.init(props);
            SignedJWT jwt = this.getJWT("bob", new Date(new Date().getTime() + 5000L), this.privateKey);
            Cookie cookie = new Cookie("hadoop-jwt", jwt.serialize());
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
            Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer(SERVICE_URL));
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            Mockito.when((Object)response.encodeRedirectURL(SERVICE_URL)).thenReturn((Object)SERVICE_URL);
            AuthenticationToken token = this.handler.alternateAuthenticate(request, response);
            ((HttpServletResponse)Mockito.verify((Object)response)).sendRedirect(REDIRECT_LOCATION);
        }
        catch (ServletException se) {
            Assertions.fail((String)"alternateAuthentication should NOT have thrown a ServletException");
        }
        catch (AuthenticationException ae) {
            Assertions.fail((String)"alternateAuthentication should NOT have thrown a AuthenticationException");
        }
    }

    @Test
    public void testExpiredJWT() throws Exception {
        try {
            this.handler.setPublicKey(this.publicKey);
            Properties props = this.getProperties();
            this.handler.init(props);
            SignedJWT jwt = this.getJWT("bob", new Date(new Date().getTime() - 1000L), this.privateKey);
            Cookie cookie = new Cookie("hadoop-jwt", jwt.serialize());
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
            Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer(SERVICE_URL));
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            Mockito.when((Object)response.encodeRedirectURL(SERVICE_URL)).thenReturn((Object)SERVICE_URL);
            AuthenticationToken token = this.handler.alternateAuthenticate(request, response);
            ((HttpServletResponse)Mockito.verify((Object)response)).sendRedirect(REDIRECT_LOCATION);
        }
        catch (ServletException se) {
            Assertions.fail((String)"alternateAuthentication should NOT have thrown a ServletException");
        }
        catch (AuthenticationException ae) {
            Assertions.fail((String)"alternateAuthentication should NOT have thrown a AuthenticationException");
        }
    }

    @Test
    public void testNoExpirationJWT() throws Exception {
        try {
            this.handler.setPublicKey(this.publicKey);
            Properties props = this.getProperties();
            this.handler.init(props);
            SignedJWT jwt = this.getJWT("bob", null, this.privateKey);
            Cookie cookie = new Cookie("hadoop-jwt", jwt.serialize());
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
            Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer(SERVICE_URL));
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            Mockito.when((Object)response.encodeRedirectURL(SERVICE_URL)).thenReturn((Object)SERVICE_URL);
            AuthenticationToken token = this.handler.alternateAuthenticate(request, response);
            Assertions.assertNotNull((Object)token, (String)"Token should not be null.");
            Assertions.assertEquals((Object)"bob", (Object)token.getUserName());
        }
        catch (ServletException se) {
            Assertions.fail((String)"alternateAuthentication should NOT have thrown a ServletException");
        }
        catch (AuthenticationException ae) {
            Assertions.fail((String)"alternateAuthentication should NOT have thrown a AuthenticationException");
        }
    }

    @Test
    public void testInvalidAudienceJWT() throws Exception {
        try {
            this.handler.setPublicKey(this.publicKey);
            Properties props = this.getProperties();
            props.put("expected.jwt.audiences", "foo");
            this.handler.init(props);
            SignedJWT jwt = this.getJWT("bob", new Date(new Date().getTime() + 5000L), this.privateKey);
            Cookie cookie = new Cookie("hadoop-jwt", jwt.serialize());
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
            Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer(SERVICE_URL));
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            Mockito.when((Object)response.encodeRedirectURL(SERVICE_URL)).thenReturn((Object)SERVICE_URL);
            AuthenticationToken token = this.handler.alternateAuthenticate(request, response);
            ((HttpServletResponse)Mockito.verify((Object)response)).sendRedirect(REDIRECT_LOCATION);
        }
        catch (ServletException se) {
            Assertions.fail((String)"alternateAuthentication should NOT have thrown a ServletException");
        }
        catch (AuthenticationException ae) {
            Assertions.fail((String)"alternateAuthentication should NOT have thrown a AuthenticationException");
        }
    }

    @Test
    public void testValidAudienceJWT() throws Exception {
        try {
            this.handler.setPublicKey(this.publicKey);
            Properties props = this.getProperties();
            props.put("expected.jwt.audiences", "bar");
            this.handler.init(props);
            SignedJWT jwt = this.getJWT("bob", new Date(new Date().getTime() + 5000L), this.privateKey);
            Cookie cookie = new Cookie("hadoop-jwt", jwt.serialize());
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
            Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer(SERVICE_URL));
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            Mockito.when((Object)response.encodeRedirectURL(SERVICE_URL)).thenReturn((Object)SERVICE_URL);
            AuthenticationToken token = this.handler.alternateAuthenticate(request, response);
            Assertions.assertEquals((Object)"bob", (Object)token.getUserName());
        }
        catch (ServletException se) {
            Assertions.fail((String)"alternateAuthentication should NOT have thrown a ServletException");
        }
        catch (AuthenticationException ae) {
            Assertions.fail((String)"alternateAuthentication should NOT have thrown an AuthenticationException");
        }
    }

    @Test
    public void testValidJWT() throws Exception {
        try {
            this.handler.setPublicKey(this.publicKey);
            Properties props = this.getProperties();
            this.handler.init(props);
            SignedJWT jwt = this.getJWT("alice", new Date(new Date().getTime() + 5000L), this.privateKey);
            Cookie cookie = new Cookie("hadoop-jwt", jwt.serialize());
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
            Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer(SERVICE_URL));
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            Mockito.when((Object)response.encodeRedirectURL(SERVICE_URL)).thenReturn((Object)SERVICE_URL);
            AuthenticationToken token = this.handler.alternateAuthenticate(request, response);
            Assertions.assertNotNull((Object)token, (String)"Token should not be null.");
            Assertions.assertEquals((Object)"alice", (Object)token.getUserName());
        }
        catch (ServletException se) {
            Assertions.fail((String)"alternateAuthentication should NOT have thrown a ServletException.");
        }
        catch (AuthenticationException ae) {
            Assertions.fail((String)"alternateAuthentication should NOT have thrown an AuthenticationException");
        }
    }

    @Test
    public void testOrigURLWithQueryString() throws Exception {
        this.handler.setPublicKey(this.publicKey);
        Properties props = this.getProperties();
        this.handler.init(props);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer(SERVICE_URL));
        Mockito.when((Object)request.getQueryString()).thenReturn((Object)"name=value");
        String loginURL = this.handler.constructLoginURL(request);
        Assertions.assertNotNull((Object)loginURL, (String)"loginURL should not be null.");
        Assertions.assertEquals((Object)"https://localhost:8443/authserver?originalUrl=https://localhost:8888/resource?name=value", (Object)loginURL);
    }

    @Test
    public void testOrigURLNoQueryString() throws Exception {
        this.handler.setPublicKey(this.publicKey);
        Properties props = this.getProperties();
        this.handler.init(props);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer(SERVICE_URL));
        Mockito.when((Object)request.getQueryString()).thenReturn(null);
        String loginURL = this.handler.constructLoginURL(request);
        Assertions.assertNotNull((Object)loginURL, (String)"LoginURL should not be null.");
        Assertions.assertEquals((Object)REDIRECT_LOCATION, (Object)loginURL);
    }

    @BeforeEach
    public void setup() throws Exception, NoSuchAlgorithmException {
        this.setupKerberosRequirements();
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(2048);
        KeyPair kp = kpg.genKeyPair();
        this.publicKey = (RSAPublicKey)kp.getPublic();
        this.privateKey = (RSAPrivateKey)kp.getPrivate();
        this.handler = new JWTRedirectAuthenticationHandler();
    }

    protected void setupKerberosRequirements() throws Exception {
        String[] keytabUsers = new String[]{"HTTP/host1", "HTTP/host2", "HTTP2/host1", "XHTTP/host"};
        String keytab = KerberosTestUtils.getKeytabFile();
        this.getKdc().createPrincipal(new File(keytab), keytabUsers);
    }

    @AfterEach
    public void teardown() throws Exception {
        this.handler.destroy();
    }

    protected Properties getProperties() {
        Properties props = new Properties();
        props.setProperty("authentication.provider.url", "https://localhost:8443/authserver");
        props.setProperty("kerberos.principal", KerberosTestUtils.getServerPrincipal());
        props.setProperty("kerberos.keytab", KerberosTestUtils.getKeytabFile());
        return props;
    }

    protected SignedJWT getJWT(String sub, Date expires, RSAPrivateKey privateKey) throws Exception {
        JWTClaimsSet claimsSet = new JWTClaimsSet.Builder().subject(sub).issueTime(new Date(new Date().getTime())).issuer("https://c2id.com").claim("scope", (Object)"openid").audience("bar").expirationTime(expires).build();
        ArrayList<String> aud = new ArrayList<String>();
        aud.add("bar");
        JWSHeader header = new JWSHeader.Builder(JWSAlgorithm.RS256).build();
        SignedJWT signedJWT = new SignedJWT(header, claimsSet);
        RSASSASigner signer = new RSASSASigner((PrivateKey)privateKey);
        signedJWT.sign((JWSSigner)signer);
        return signedJWT;
    }
}

