/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.server;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.HttpCookie;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.hadoop.security.authentication.server.AuthenticationHandler;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.authentication.server.KerberosAuthenticationHandler;
import org.apache.hadoop.security.authentication.server.PseudoAuthenticationHandler;
import org.apache.hadoop.security.authentication.util.Signer;
import org.apache.hadoop.security.authentication.util.SignerSecretProvider;
import org.apache.hadoop.security.authentication.util.StringSignerSecretProvider;
import org.apache.hadoop.security.authentication.util.StringSignerSecretProviderCreator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestAuthenticationFilter {
    private static final long TOKEN_VALIDITY_SEC = 1000L;
    private static final long TOKEN_MAX_INACTIVE_INTERVAL = 1000L;

    @Test
    public void testGetConfiguration() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
        Mockito.when((Object)config.getInitParameter("config.prefix")).thenReturn((Object)"");
        Mockito.when((Object)config.getInitParameter("a")).thenReturn((Object)"A");
        Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("a")).elements());
        Properties props = filter.getConfiguration("", config);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"A", (Object)props.getProperty("a"));
        config = (FilterConfig)Mockito.mock(FilterConfig.class);
        Mockito.when((Object)config.getInitParameter("config.prefix")).thenReturn((Object)"foo");
        Mockito.when((Object)config.getInitParameter("foo.a")).thenReturn((Object)"A");
        Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("foo.a")).elements());
        props = filter.getConfiguration("foo.", config);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"A", (Object)props.getProperty("a"));
    }

    @Test
    public void testInitEmpty() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector().elements());
            filter.init(config);
            org.junit.jupiter.api.Assertions.fail();
        }
        catch (ServletException ex) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)"Authentication type must be specified: simple|kerberos|<class>", (Object)ex.getMessage());
        }
        catch (Exception ex) {
            org.junit.jupiter.api.Assertions.fail();
        }
        finally {
            filter.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFallbackToRandomSecretProvider() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)"simple");
            Mockito.when((Object)config.getInitParameter("token.validity")).thenReturn((Object)new Long(1000L).toString());
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "token.validity")).elements());
            ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
            Mockito.when((Object)context.getAttribute("signer.secret.provider.object")).thenReturn(null);
            Mockito.when((Object)config.getServletContext()).thenReturn((Object)context);
            filter.init(config);
            org.junit.jupiter.api.Assertions.assertEquals(PseudoAuthenticationHandler.class, filter.getAuthenticationHandler().getClass());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)filter.isRandomSecret());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)filter.isCustomSignerSecretProvider());
            org.junit.jupiter.api.Assertions.assertNull((Object)filter.getCookieDomain());
            org.junit.jupiter.api.Assertions.assertNull((Object)filter.getCookiePath());
            org.junit.jupiter.api.Assertions.assertEquals((long)1000L, (long)filter.getValidity());
        }
        finally {
            filter.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInit() throws Exception {
        FilterConfig config;
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config2 = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config2.getInitParameter("type")).thenReturn((Object)"simple");
            Mockito.when((Object)config2.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type")).elements());
            ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
            Mockito.when((Object)context.getAttribute("signer.secret.provider.object")).thenReturn((Object)new SignerSecretProvider(){

                public void init(Properties config, ServletContext servletContext, long tokenValidity) {
                }

                public byte[] getCurrentSecret() {
                    return null;
                }

                public byte[][] getAllSecrets() {
                    return null;
                }
            });
            Mockito.when((Object)config2.getServletContext()).thenReturn((Object)context);
            filter.init(config2);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)filter.isRandomSecret());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)filter.isCustomSignerSecretProvider());
        }
        finally {
            filter.destroy();
        }
        File testDir = new File(System.getProperty("test.build.data", "target/test-dir"));
        testDir.mkdirs();
        String secretValue = "hadoop";
        File secretFile = new File(testDir, "http-secret.txt");
        FileWriter writer = new FileWriter(secretFile);
        writer.write(secretValue);
        ((Writer)writer).close();
        filter = new AuthenticationFilter();
        try {
            config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)"simple");
            Mockito.when((Object)config.getInitParameter("signature.secret.file")).thenReturn((Object)secretFile.getAbsolutePath());
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "signature.secret.file")).elements());
            ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
            Mockito.when((Object)context.getAttribute("signer.secret.provider.object")).thenReturn(null);
            Mockito.when((Object)config.getServletContext()).thenReturn((Object)context);
            filter.init(config);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)filter.isRandomSecret());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)filter.isCustomSignerSecretProvider());
        }
        finally {
            filter.destroy();
        }
        filter = new AuthenticationFilter();
        try {
            config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)"simple");
            Mockito.when((Object)config.getInitParameter("cookie.domain")).thenReturn((Object)".foo.com");
            Mockito.when((Object)config.getInitParameter("cookie.path")).thenReturn((Object)"/bar");
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "cookie.domain", "cookie.path")).elements());
            TestAuthenticationFilter.getMockedServletContextWithStringSigner(config);
            filter.init(config);
            org.junit.jupiter.api.Assertions.assertEquals((Object)".foo.com", (Object)filter.getCookieDomain());
            org.junit.jupiter.api.Assertions.assertEquals((Object)"/bar", (Object)filter.getCookiePath());
        }
        finally {
            filter.destroy();
        }
        DummyAuthenticationHandler.reset();
        filter = new AuthenticationFilter();
        try {
            config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"true");
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "management.operation.return")).elements());
            TestAuthenticationFilter.getMockedServletContextWithStringSigner(config);
            filter.init(config);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)DummyAuthenticationHandler.init);
        }
        finally {
            filter.destroy();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)DummyAuthenticationHandler.destroy);
        }
        filter = new AuthenticationFilter();
        try {
            config = (FilterConfig)Mockito.mock(FilterConfig.class);
            ServletContext sc = (ServletContext)Mockito.mock(ServletContext.class);
            Mockito.when((Object)config.getServletContext()).thenReturn((Object)sc);
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)"kerberos");
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type")).elements());
            filter.init(config);
        }
        catch (ServletException servletException) {
        }
        finally {
            org.junit.jupiter.api.Assertions.assertEquals(KerberosAuthenticationHandler.class, filter.getAuthenticationHandler().getClass());
            filter.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmptySecretFileFallbacksToRandomSecret() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)"simple");
            File secretFile = File.createTempFile("test_empty_secret", ".txt");
            secretFile.deleteOnExit();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)secretFile.exists());
            Mockito.when((Object)config.getInitParameter("signature.secret.file")).thenReturn((Object)secretFile.getAbsolutePath());
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "signature.secret.file")).elements());
            ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
            Mockito.when((Object)context.getAttribute("signer.secret.provider.object")).thenReturn(null);
            Mockito.when((Object)config.getServletContext()).thenReturn((Object)context);
            filter.init(config);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)filter.isRandomSecret());
        }
        finally {
            filter.destroy();
        }
    }

    @Test
    public void testInitCaseSensitivity() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)"SimPle");
            Mockito.when((Object)config.getInitParameter("token.validity")).thenReturn((Object)new Long(1000L).toString());
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "token.validity")).elements());
            TestAuthenticationFilter.getMockedServletContextWithStringSigner(config);
            filter.init(config);
            org.junit.jupiter.api.Assertions.assertEquals(PseudoAuthenticationHandler.class, filter.getAuthenticationHandler().getClass());
        }
        finally {
            filter.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetRequestURL() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"true");
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "management.operation.return")).elements());
            TestAuthenticationFilter.getMockedServletContextWithStringSigner(config);
            filter.init(config);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer("http://foo:8080/bar"));
            Mockito.when((Object)request.getQueryString()).thenReturn((Object)"a=A&b=B");
            org.junit.jupiter.api.Assertions.assertEquals((Object)"http://foo:8080/bar?a=A&b=B", (Object)filter.getRequestURL(request));
        }
        finally {
            filter.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetToken() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"true");
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameter("signature.secret")).thenReturn((Object)"secret");
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "signature.secret", "management.operation.return")).elements());
            SignerSecretProvider secretProvider = TestAuthenticationFilter.getMockedServletContextWithStringSigner(config);
            filter.init(config);
            AuthenticationToken token = new AuthenticationToken("u", "p", "dummy");
            token.setExpires(System.currentTimeMillis() + 1000L);
            Signer signer = new Signer(secretProvider);
            String tokenSigned = signer.sign(token.toString());
            Cookie cookie = new Cookie("hadoop.auth", tokenSigned);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
            AuthenticationToken newToken = filter.getToken(request);
            org.junit.jupiter.api.Assertions.assertEquals((Object)token.toString(), (Object)newToken.toString());
        }
        finally {
            filter.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetTokenExpired() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"true");
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameter("signature.secret")).thenReturn((Object)"secret");
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "signature.secret", "management.operation.return")).elements());
            TestAuthenticationFilter.getMockedServletContextWithStringSigner(config);
            filter.init(config);
            AuthenticationToken token = new AuthenticationToken("u", "p", "dummy");
            token.setExpires(System.currentTimeMillis() - 1000L);
            StringSignerSecretProvider secretProvider = StringSignerSecretProviderCreator.newStringSignerSecretProvider();
            Properties secretProviderProps = new Properties();
            secretProviderProps.setProperty("signature.secret", "secret");
            secretProvider.init(secretProviderProps, null, 1000L);
            Signer signer = new Signer((SignerSecretProvider)secretProvider);
            String tokenSigned = signer.sign(token.toString());
            Cookie cookie = new Cookie("hadoop.auth", tokenSigned);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
            boolean failed = false;
            try {
                filter.getToken(request);
            }
            catch (AuthenticationException ex) {
                org.junit.jupiter.api.Assertions.assertEquals((Object)"AuthenticationToken expired", (Object)ex.getMessage());
                failed = true;
            }
            finally {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)failed, (String)"token not expired");
            }
        }
        finally {
            filter.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetTokenInvalidType() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"true");
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameter("signature.secret")).thenReturn((Object)"secret");
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "signature.secret", "management.operation.return")).elements());
            TestAuthenticationFilter.getMockedServletContextWithStringSigner(config);
            filter.init(config);
            AuthenticationToken token = new AuthenticationToken("u", "p", "invalidtype");
            token.setExpires(System.currentTimeMillis() + 1000L);
            StringSignerSecretProvider secretProvider = StringSignerSecretProviderCreator.newStringSignerSecretProvider();
            Properties secretProviderProps = new Properties();
            secretProviderProps.setProperty("signature.secret", "secret");
            secretProvider.init(secretProviderProps, null, 1000L);
            Signer signer = new Signer((SignerSecretProvider)secretProvider);
            String tokenSigned = signer.sign(token.toString());
            Cookie cookie = new Cookie("hadoop.auth", tokenSigned);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
            boolean failed = false;
            try {
                filter.getToken(request);
            }
            catch (AuthenticationException ex) {
                org.junit.jupiter.api.Assertions.assertEquals((Object)"Invalid AuthenticationToken type", (Object)ex.getMessage());
                failed = true;
            }
            finally {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)failed, (String)"token not invalid type");
            }
        }
        finally {
            filter.destroy();
        }
    }

    private static SignerSecretProvider getMockedServletContextWithStringSigner(FilterConfig config) throws Exception {
        Properties secretProviderProps = new Properties();
        secretProviderProps.setProperty("signature.secret", "secret");
        StringSignerSecretProvider secretProvider = StringSignerSecretProviderCreator.newStringSignerSecretProvider();
        secretProvider.init(secretProviderProps, null, 1000L);
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        Mockito.when((Object)context.getAttribute("signer.secret.provider.object")).thenReturn((Object)secretProvider);
        Mockito.when((Object)config.getServletContext()).thenReturn((Object)context);
        return secretProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDoFilterNotAuthenticated() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"true");
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "management.operation.return")).elements());
            TestAuthenticationFilter.getMockedServletContextWithStringSigner(config);
            filter.init(config);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer("http://foo:8080/bar"));
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
            ((FilterChain)Mockito.doAnswer((Answer)new Answer<Object>(){

                public Object answer(InvocationOnMock invocation) throws Throwable {
                    org.junit.jupiter.api.Assertions.fail();
                    return null;
                }
            }).when((Object)chain)).doFilter((ServletRequest)ArgumentMatchers.any(), (ServletResponse)ArgumentMatchers.any());
            Mockito.when((Object)response.containsHeader("WWW-Authenticate")).thenReturn((Object)true);
            filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
            ((HttpServletResponse)Mockito.verify((Object)response)).sendError(401, "Authentication required");
        }
        finally {
            filter.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDoFilterNotAuthenticatedLowerCase() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"true");
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "management.operation.return")).elements());
            TestAuthenticationFilter.getMockedServletContextWithStringSigner(config);
            filter.init(config);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer("http://foo:8080/bar"));
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
            ((FilterChain)Mockito.doAnswer(invocation -> {
                org.junit.jupiter.api.Assertions.fail();
                return null;
            }).when((Object)chain)).doFilter((ServletRequest)ArgumentMatchers.any(), (ServletResponse)ArgumentMatchers.any());
            Mockito.when((Object)response.containsHeader("www-authenticate")).thenReturn((Object)true);
            filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
            ((HttpServletResponse)Mockito.verify((Object)response)).sendError(401, "Authentication required");
        }
        finally {
            filter.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _testDoFilterAuthentication(boolean withDomainPath, boolean invalidToken, boolean expired) throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
        Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"true");
        Mockito.when((Object)config.getInitParameter("expired.token")).thenReturn((Object)Boolean.toString(expired));
        Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
        Mockito.when((Object)config.getInitParameter("token.validity")).thenReturn((Object)new Long(1000L).toString());
        Mockito.when((Object)config.getInitParameter("signature.secret")).thenReturn((Object)"secret");
        Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "token.validity", "signature.secret", "management.operation.return", "expired.token")).elements());
        TestAuthenticationFilter.getMockedServletContextWithStringSigner(config);
        if (withDomainPath) {
            Mockito.when((Object)config.getInitParameter("cookie.domain")).thenReturn((Object)".foo.com");
            Mockito.when((Object)config.getInitParameter("cookie.path")).thenReturn((Object)"/bar");
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "token.validity", "signature.secret", "cookie.domain", "cookie.path", "management.operation.return")).elements());
        }
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getParameter("authenticated")).thenReturn((Object)"true");
        Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer("http://foo:8080/bar"));
        Mockito.when((Object)request.getQueryString()).thenReturn((Object)"authenticated=true");
        if (invalidToken) {
            Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{new Cookie("hadoop.auth", "foo")});
        }
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
        final HashMap cookieMap = new HashMap();
        ((HttpServletResponse)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                String cookieHeader = (String)invocation.getArguments()[1];
                TestAuthenticationFilter.parseCookieMap(cookieHeader, cookieMap);
                return null;
            }
        }).when((Object)response)).addHeader((String)Mockito.eq((Object)"Set-Cookie"), Mockito.anyString());
        try {
            filter.init(config);
            filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
            if (expired) {
                ((HttpServletResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.never())).addHeader((String)Mockito.eq((Object)"Set-Cookie"), Mockito.anyString());
            } else {
                String v = (String)cookieMap.get("hadoop.auth");
                org.junit.jupiter.api.Assertions.assertNotNull((Object)v, (String)"cookie missing");
                org.junit.jupiter.api.Assertions.assertTrue((v.contains("u=") && v.contains("p=") && v.contains("t=") && v.contains("e=") && v.contains("s=") ? 1 : 0) != 0);
                ((FilterChain)Mockito.verify((Object)chain)).doFilter((ServletRequest)ArgumentMatchers.any(ServletRequest.class), (ServletResponse)ArgumentMatchers.any(ServletResponse.class));
                StringSignerSecretProvider secretProvider = StringSignerSecretProviderCreator.newStringSignerSecretProvider();
                Properties secretProviderProps = new Properties();
                secretProviderProps.setProperty("signature.secret", "secret");
                secretProvider.init(secretProviderProps, null, 1000L);
                Signer signer = new Signer((SignerSecretProvider)secretProvider);
                String value = signer.verifyAndExtract(v);
                AuthenticationToken token = AuthenticationToken.parse((String)value);
                Assertions.assertThat((long)token.getExpires()).isNotEqualTo(0L);
                if (withDomainPath) {
                    org.junit.jupiter.api.Assertions.assertEquals((Object)".foo.com", cookieMap.get("Domain"));
                    org.junit.jupiter.api.Assertions.assertEquals((Object)"/bar", cookieMap.get("Path"));
                } else {
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)cookieMap.containsKey("Domain"));
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)cookieMap.containsKey("Path"));
                }
            }
        }
        finally {
            filter.destroy();
        }
    }

    private static void parseCookieMap(String cookieHeader, Map<String, String> cookieMap) {
        List<HttpCookie> cookies = HttpCookie.parse(cookieHeader);
        for (HttpCookie cookie : cookies) {
            if (!"hadoop.auth".equals(cookie.getName())) continue;
            cookieMap.put(cookie.getName(), cookie.getValue());
            if (cookie.getPath() != null) {
                cookieMap.put("Path", cookie.getPath());
            }
            if (cookie.getDomain() == null) continue;
            cookieMap.put("Domain", cookie.getDomain());
        }
    }

    @Test
    public void testDoFilterAuthentication() throws Exception {
        this._testDoFilterAuthentication(false, false, false);
    }

    @Test
    public void testDoFilterAuthenticationImmediateExpiration() throws Exception {
        this._testDoFilterAuthentication(false, false, true);
    }

    @Test
    public void testDoFilterAuthenticationWithInvalidToken() throws Exception {
        this._testDoFilterAuthentication(false, true, false);
    }

    @Test
    public void testDoFilterAuthenticationWithDomainPath() throws Exception {
        this._testDoFilterAuthentication(true, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDoFilterAuthenticated() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"true");
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "management.operation.return")).elements());
            TestAuthenticationFilter.getMockedServletContextWithStringSigner(config);
            filter.init(config);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer("http://foo:8080/bar"));
            AuthenticationToken token = new AuthenticationToken("u", "p", "t");
            token.setExpires(System.currentTimeMillis() + 1000L);
            StringSignerSecretProvider secretProvider = StringSignerSecretProviderCreator.newStringSignerSecretProvider();
            Properties secretProviderProps = new Properties();
            secretProviderProps.setProperty("signature.secret", "secret");
            secretProvider.init(secretProviderProps, null, 1000L);
            Signer signer = new Signer((SignerSecretProvider)secretProvider);
            String tokenSigned = signer.sign(token.toString());
            Cookie cookie = new Cookie("hadoop.auth", tokenSigned);
            Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
            ((FilterChain)Mockito.doAnswer((Answer)new Answer<Object>(){

                public Object answer(InvocationOnMock invocation) throws Throwable {
                    Object[] args = invocation.getArguments();
                    HttpServletRequest request = (HttpServletRequest)args[0];
                    org.junit.jupiter.api.Assertions.assertEquals((Object)"u", (Object)request.getRemoteUser());
                    org.junit.jupiter.api.Assertions.assertEquals((Object)"p", (Object)request.getUserPrincipal().getName());
                    return null;
                }
            }).when((Object)chain)).doFilter((ServletRequest)ArgumentMatchers.any(), (ServletResponse)ArgumentMatchers.any());
            filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        }
        finally {
            filter.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDoFilterAuthenticationFailure() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"true");
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "management.operation.return")).elements());
            TestAuthenticationFilter.getMockedServletContextWithStringSigner(config);
            filter.init(config);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer("http://foo:8080/bar"));
            Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[0]);
            Mockito.when((Object)request.getHeader("WWW-Authenticate")).thenReturn((Object)"dummyauth");
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
            final HashMap cookieMap = new HashMap();
            ((HttpServletResponse)Mockito.doAnswer((Answer)new Answer<Object>(){

                public Object answer(InvocationOnMock invocation) throws Throwable {
                    Object[] args = invocation.getArguments();
                    TestAuthenticationFilter.parseCookieMap((String)args[1], cookieMap);
                    return null;
                }
            }).when((Object)response)).addHeader((String)Mockito.eq((Object)"Set-Cookie"), Mockito.anyString());
            ((FilterChain)Mockito.doAnswer((Answer)new Answer<Object>(){

                public Object answer(InvocationOnMock invocation) throws Throwable {
                    org.junit.jupiter.api.Assertions.fail((String)"shouldn't get here");
                    return null;
                }
            }).when((Object)chain)).doFilter((ServletRequest)ArgumentMatchers.any(), (ServletResponse)ArgumentMatchers.any());
            filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
            ((HttpServletResponse)Mockito.verify((Object)response)).sendError(403, "AUTH FAILED");
            ((HttpServletResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.never())).setHeader((String)Mockito.eq((Object)"WWW-Authenticate"), Mockito.anyString());
            String value = (String)cookieMap.get("hadoop.auth");
            org.junit.jupiter.api.Assertions.assertNotNull((Object)value, (String)"cookie missing");
            org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)value);
        }
        finally {
            filter.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDoFilterAuthenticatedExpired() throws Exception {
        String secret = "secret";
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"true");
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameter("signature.secret")).thenReturn((Object)secret);
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "signature.secret", "management.operation.return")).elements());
            TestAuthenticationFilter.getMockedServletContextWithStringSigner(config);
            filter.init(config);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer("http://foo:8080/bar"));
            AuthenticationToken token = new AuthenticationToken("u", "p", "dummy");
            token.setExpires(System.currentTimeMillis() - 1000L);
            StringSignerSecretProvider secretProvider = StringSignerSecretProviderCreator.newStringSignerSecretProvider();
            Properties secretProviderProps = new Properties();
            secretProviderProps.setProperty("signature.secret", secret);
            secretProvider.init(secretProviderProps, null, 1000L);
            Signer signer = new Signer((SignerSecretProvider)secretProvider);
            String tokenSigned = signer.sign(token.toString());
            Cookie cookie = new Cookie("hadoop.auth", tokenSigned);
            Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            Mockito.when((Object)response.containsHeader("WWW-Authenticate")).thenReturn((Object)true);
            FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
            TestAuthenticationFilter.verifyUnauthorized(filter, request, response, chain);
        }
        finally {
            filter.destroy();
        }
    }

    @Test
    public void testDoFilterAuthenticationAuthorized() throws Exception {
        long maxInactives = System.currentTimeMillis() + 1000L;
        long expires = System.currentTimeMillis() + 1000L;
        boolean authorized = true;
        this._testDoFilterAuthenticationMaxInactiveInterval(maxInactives, expires, authorized);
    }

    @Test
    public void testDoFilterAuthenticationUnauthorizedExpired() throws Exception {
        long maxInactives = System.currentTimeMillis() + 1000L;
        long expires = System.currentTimeMillis() - 1000L;
        boolean authorized = false;
        this._testDoFilterAuthenticationMaxInactiveInterval(maxInactives, expires, authorized);
    }

    @Test
    public void testDoFilterAuthenticationUnauthorizedInactived() throws Exception {
        long maxInactives = System.currentTimeMillis() - 1000L;
        long expires = System.currentTimeMillis() + 1000L;
        boolean authorized = false;
        this._testDoFilterAuthenticationMaxInactiveInterval(maxInactives, expires, authorized);
    }

    @Test
    public void testDoFilterAuthenticationUnauthorizedInactivedExpired() throws Exception {
        long maxInactives = System.currentTimeMillis() - 1000L;
        long expires = System.currentTimeMillis() - 1000L;
        boolean authorized = false;
        this._testDoFilterAuthenticationMaxInactiveInterval(maxInactives, expires, authorized);
    }

    @Test
    public void testTokenWithValidActivityInterval() throws Exception {
        long maxInactives = System.currentTimeMillis() + 1000L;
        long expires = System.currentTimeMillis() + 1000L;
        this._testDoFilterAuthenticationMaxInactiveInterval(maxInactives, -1L, expires, true, false);
        maxInactives = System.currentTimeMillis() + 1000L;
        expires = System.currentTimeMillis() + 1000L;
        this._testDoFilterAuthenticationMaxInactiveInterval(maxInactives, 1000L, expires, true, true);
    }

    @Test
    public void testTokenWithExpiredActivityIntervaln() throws Exception {
        long maxInactives = System.currentTimeMillis() - 1000L;
        long expires = System.currentTimeMillis() + 1000L;
        this._testDoFilterAuthenticationMaxInactiveInterval(maxInactives, -1L, expires, false, false);
        maxInactives = System.currentTimeMillis() + 1000L;
        expires = System.currentTimeMillis() + 1000L;
        this._testDoFilterAuthenticationMaxInactiveInterval(maxInactives, -1L, expires, true, false);
    }

    @Test
    public void testTokenWithNoActivityIntervals() throws Exception {
        long expires = System.currentTimeMillis() + 1000L;
        this._testDoFilterAuthenticationMaxInactiveInterval(-1L, -1L, expires, true, false);
        expires = System.currentTimeMillis() + 1000L;
        this._testDoFilterAuthenticationMaxInactiveInterval(-1L, 1000L, expires, true, true);
    }

    private void _testDoFilterAuthenticationMaxInactiveInterval(long maxInactivesInToken, long expires, boolean authorized) throws Exception {
        this._testDoFilterAuthenticationMaxInactiveInterval(maxInactivesInToken, 1000L, expires, authorized, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _testDoFilterAuthenticationMaxInactiveInterval(long maxInactivesInToken, long maxInactivesOnServer, long expires, boolean authorized, boolean newCookie) throws Exception {
        String secret = "secret";
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"true");
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameter("signature.secret")).thenReturn((Object)secret);
            Mockito.when((Object)config.getInitParameter("token.max-inactive-interval")).thenReturn((Object)Long.toString(maxInactivesOnServer));
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "signature.secret", "token.max-inactive-interval", "management.operation.return")).elements());
            TestAuthenticationFilter.getMockedServletContextWithStringSigner(config);
            filter.init(config);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer("http://foo:8080/bar"));
            AuthenticationToken token = new AuthenticationToken("u", "p", "dummy");
            token.setMaxInactives(maxInactivesInToken);
            token.setExpires(expires);
            StringSignerSecretProvider secretProvider = StringSignerSecretProviderCreator.newStringSignerSecretProvider();
            Properties secretProviderProps = new Properties();
            secretProviderProps.setProperty("signature.secret", secret);
            secretProvider.init(secretProviderProps, null, 1000L);
            Signer signer = new Signer((SignerSecretProvider)secretProvider);
            String tokenSigned = signer.sign(token.toString());
            Cookie cookie = new Cookie("hadoop.auth", tokenSigned);
            Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            Mockito.when((Object)response.containsHeader("WWW-Authenticate")).thenReturn((Object)true);
            FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
            if (authorized) {
                TestAuthenticationFilter.verifyAuthorized(filter, request, response, chain, newCookie);
            } else {
                TestAuthenticationFilter.verifyUnauthorized(filter, request, response, chain);
            }
        }
        finally {
            filter.destroy();
        }
    }

    private static void verifyAuthorized(AuthenticationFilter filter, HttpServletRequest request, HttpServletResponse response, FilterChain chain, boolean newCookie) throws Exception {
        final HashMap cookieMap = new HashMap();
        ((HttpServletResponse)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                String cookieHeader = (String)invocation.getArguments()[1];
                TestAuthenticationFilter.parseCookieMap(cookieHeader, cookieMap);
                return null;
            }
        }).when((Object)response)).addHeader((String)Mockito.eq((Object)"Set-Cookie"), Mockito.anyString());
        filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        if (newCookie) {
            String v = (String)cookieMap.get("hadoop.auth");
            org.junit.jupiter.api.Assertions.assertNotNull((Object)v, (String)"cookie missing");
            org.junit.jupiter.api.Assertions.assertTrue((v.contains("u=") && v.contains("p=") && v.contains("t=") && v.contains("i=") && v.contains("e=") && v.contains("s=") ? 1 : 0) != 0);
            ((FilterChain)Mockito.verify((Object)chain)).doFilter((ServletRequest)ArgumentMatchers.any(ServletRequest.class), (ServletResponse)ArgumentMatchers.any(ServletResponse.class));
            StringSignerSecretProvider secretProvider = StringSignerSecretProviderCreator.newStringSignerSecretProvider();
            Properties secretProviderProps = new Properties();
            secretProviderProps.setProperty("signature.secret", "secret");
            secretProvider.init(secretProviderProps, null, 1000L);
            Signer signer = new Signer((SignerSecretProvider)secretProvider);
            String value = signer.verifyAndExtract(v);
            AuthenticationToken token = AuthenticationToken.parse((String)value);
            Assertions.assertThat((long)token.getMaxInactives()).isNotEqualTo(0L);
            Assertions.assertThat((long)token.getExpires()).isNotEqualTo(0L);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)token.isExpired(), (String)"Token is expired.");
        } else {
            org.junit.jupiter.api.Assertions.assertTrue((!cookieMap.containsKey("hadoop.auth") ? 1 : 0) != 0, (String)"cookie is present");
        }
    }

    private static void verifyUnauthorized(AuthenticationFilter filter, HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        final HashMap cookieMap = new HashMap();
        ((HttpServletResponse)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                String cookieHeader = (String)invocation.getArguments()[1];
                TestAuthenticationFilter.parseCookieMap(cookieHeader, cookieMap);
                return null;
            }
        }).when((Object)response)).addHeader((String)Mockito.eq((Object)"Set-Cookie"), Mockito.anyString());
        filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        ((HttpServletResponse)Mockito.verify((Object)response)).sendError(Mockito.eq((int)401), Mockito.anyString());
        ((FilterChain)Mockito.verify((Object)chain, (VerificationMode)Mockito.never())).doFilter((ServletRequest)ArgumentMatchers.any(ServletRequest.class), (ServletResponse)ArgumentMatchers.any(ServletResponse.class));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)cookieMap.containsKey("hadoop.auth"), (String)"cookie is missing");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", cookieMap.get("hadoop.auth"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDoFilterAuthenticatedInvalidType() throws Exception {
        String secret = "secret";
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"true");
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameter("signature.secret")).thenReturn((Object)secret);
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "signature.secret", "management.operation.return")).elements());
            TestAuthenticationFilter.getMockedServletContextWithStringSigner(config);
            filter.init(config);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer("http://foo:8080/bar"));
            AuthenticationToken token = new AuthenticationToken("u", "p", "invalidtype");
            token.setExpires(System.currentTimeMillis() + 1000L);
            StringSignerSecretProvider secretProvider = StringSignerSecretProviderCreator.newStringSignerSecretProvider();
            Properties secretProviderProps = new Properties();
            secretProviderProps.setProperty("signature.secret", secret);
            secretProvider.init(secretProviderProps, null, 1000L);
            Signer signer = new Signer((SignerSecretProvider)secretProvider);
            String tokenSigned = signer.sign(token.toString());
            Cookie cookie = new Cookie("hadoop.auth", tokenSigned);
            Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            Mockito.when((Object)response.containsHeader("WWW-Authenticate")).thenReturn((Object)true);
            FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
            TestAuthenticationFilter.verifyUnauthorized(filter, request, response, chain);
        }
        finally {
            filter.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testManagementOperation() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"false");
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "management.operation.return")).elements());
            TestAuthenticationFilter.getMockedServletContextWithStringSigner(config);
            filter.init(config);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer("http://foo:8080/bar"));
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
            filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
            ((HttpServletResponse)Mockito.verify((Object)response)).setStatus(202);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{response});
            Mockito.reset((Object[])new HttpServletRequest[]{request});
            Mockito.reset((Object[])new HttpServletResponse[]{response});
            AuthenticationToken token = new AuthenticationToken("u", "p", "t");
            token.setExpires(System.currentTimeMillis() + 1000L);
            StringSignerSecretProvider secretProvider = StringSignerSecretProviderCreator.newStringSignerSecretProvider();
            Properties secretProviderProps = new Properties();
            secretProviderProps.setProperty("signature.secret", "secret");
            secretProvider.init(secretProviderProps, null, 1000L);
            Signer signer = new Signer((SignerSecretProvider)secretProvider);
            String tokenSigned = signer.sign(token.toString());
            Cookie cookie = new Cookie("hadoop.auth", tokenSigned);
            Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
            Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer());
            filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
            ((HttpServletResponse)Mockito.verify((Object)response)).setStatus(202);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{response});
        }
        finally {
            filter.destroy();
        }
    }

    public static class DummyAuthenticationHandler
    implements AuthenticationHandler {
        public static boolean init;
        public static boolean managementOperationReturn;
        public static boolean destroy;
        public static boolean expired;
        public static final String TYPE = "dummy";

        public static void reset() {
            init = false;
            destroy = false;
        }

        public void init(Properties config) throws ServletException {
            init = true;
            managementOperationReturn = config.getProperty("management.operation.return", "true").equals("true");
            expired = config.getProperty("expired.token", "false").equals("true");
        }

        public boolean managementOperation(AuthenticationToken token, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
            if (!managementOperationReturn) {
                response.setStatus(202);
            }
            return managementOperationReturn;
        }

        public void destroy() {
            destroy = true;
        }

        public String getType() {
            return TYPE;
        }

        public AuthenticationToken authenticate(HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
            AuthenticationToken token = null;
            String param = request.getParameter("authenticated");
            if (param != null && param.equals("true")) {
                token = new AuthenticationToken("u", "p", "t");
                token.setExpires(expired ? 0L : System.currentTimeMillis() + 1000L);
            } else if (request.getHeader("WWW-Authenticate") == null) {
                response.setHeader("WWW-Authenticate", "dummyauth");
            } else {
                throw new AuthenticationException("AUTH FAILED");
            }
            return token;
        }
    }
}

