/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.server;

import java.io.IOException;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AltKerberosAuthenticationHandler;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.authentication.server.KerberosAuthenticationHandler;
import org.apache.hadoop.security.authentication.server.TestKerberosAuthenticationHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;

public class TestAltKerberosAuthenticationHandler
extends TestKerberosAuthenticationHandler {
    @Override
    protected KerberosAuthenticationHandler getNewAuthenticationHandler() {
        return new AltKerberosAuthenticationHandler(){

            public AuthenticationToken alternateAuthenticate(HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
                return new AuthenticationToken("A", "B", this.getType());
            }
        };
    }

    @Override
    protected String getExpectedType() {
        return "alt-kerberos";
    }

    @Test
    @Timeout(value=60L)
    public void testAlternateAuthenticationAsBrowser() throws Exception {
        if (this.handler != null) {
            this.handler.destroy();
            this.handler = null;
        }
        this.handler = this.getNewAuthenticationHandler();
        Properties props = this.getDefaultProperties();
        props.setProperty("alt-kerberos.non-browser.user-agents", "foo, bar");
        try {
            this.handler.init(props);
        }
        catch (Exception ex) {
            this.handler = null;
            throw ex;
        }
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)request.getHeader("User-Agent")).thenReturn((Object)"Some Browser");
        AuthenticationToken token = this.handler.authenticate(request, response);
        Assertions.assertEquals((Object)"A", (Object)token.getUserName());
        Assertions.assertEquals((Object)"B", (Object)token.getName());
        Assertions.assertEquals((Object)this.getExpectedType(), (Object)token.getType());
    }

    @Test
    @Timeout(value=60L)
    public void testNonDefaultNonBrowserUserAgentAsBrowser() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        if (this.handler != null) {
            this.handler.destroy();
            this.handler = null;
        }
        this.handler = this.getNewAuthenticationHandler();
        Properties props = this.getDefaultProperties();
        props.setProperty("alt-kerberos.non-browser.user-agents", "foo, bar");
        try {
            this.handler.init(props);
        }
        catch (Exception ex) {
            this.handler = null;
            throw ex;
        }
        Mockito.when((Object)request.getHeader("User-Agent")).thenReturn((Object)"blah");
        AuthenticationToken token = this.handler.authenticate(request, response);
        Assertions.assertEquals((Object)"A", (Object)token.getUserName());
        Assertions.assertEquals((Object)"B", (Object)token.getName());
        Assertions.assertEquals((Object)this.getExpectedType(), (Object)token.getType());
    }

    @Test
    @Timeout(value=60L)
    public void testNonDefaultNonBrowserUserAgentAsNonBrowser() throws Exception {
        if (this.handler != null) {
            this.handler.destroy();
            this.handler = null;
        }
        this.handler = this.getNewAuthenticationHandler();
        Properties props = this.getDefaultProperties();
        props.setProperty("alt-kerberos.non-browser.user-agents", "foo, bar");
        try {
            this.handler.init(props);
        }
        catch (Exception ex) {
            this.handler = null;
            throw ex;
        }
        this.testRequestWithoutAuthorization();
        this.testRequestWithInvalidAuthorization();
        this.testRequestWithAuthorization();
        this.testRequestWithInvalidKerberosAuthorization();
    }
}

