/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.util;

import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.Random;
import javax.servlet.ServletContext;
import org.apache.curator.test.TestingServer;
import org.apache.hadoop.security.authentication.util.RolloverSignerSecretProvider;
import org.apache.hadoop.security.authentication.util.ZKSignerSecretProvider;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestZKSignerSecretProvider {
    private TestingServer zkServer;
    private final int timeout = 100;
    private final long rolloverFrequency = 50L;

    public TestZKSignerSecretProvider() {
        LogManager.getLogger((String)RolloverSignerSecretProvider.LOG.getName()).setLevel(Level.DEBUG);
    }

    @Before
    public void setup() throws Exception {
        this.zkServer = new TestingServer();
    }

    @After
    public void teardown() throws Exception {
        if (this.zkServer != null) {
            this.zkServer.stop();
            this.zkServer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOne() throws Exception {
        long seed = System.currentTimeMillis();
        Random rand = new Random(seed);
        byte[] secret2 = this.generateNewSecret(rand);
        byte[] secret1 = this.generateNewSecret(rand);
        byte[] secret3 = this.generateNewSecret(rand);
        MockZKSignerSecretProvider secretProvider = (MockZKSignerSecretProvider)((Object)Mockito.spy((Object)((Object)new MockZKSignerSecretProvider(seed))));
        Properties config = new Properties();
        config.setProperty("signer.secret.provider.zookeeper.connection.string", this.zkServer.getConnectString());
        config.setProperty("signer.secret.provider.zookeeper.path", "/secret");
        try {
            secretProvider.init(config, this.getDummyServletContext(), 50L);
            byte[] currentSecret = secretProvider.getCurrentSecret();
            byte[][] allSecrets = secretProvider.getAllSecrets();
            Assert.assertArrayEquals((byte[])secret1, (byte[])currentSecret);
            Assert.assertEquals((long)2L, (long)allSecrets.length);
            Assert.assertArrayEquals((byte[])secret1, (byte[])allSecrets[0]);
            Assert.assertNull((Object)allSecrets[1]);
            ((MockZKSignerSecretProvider)((Object)Mockito.verify((Object)((Object)secretProvider), (VerificationMode)Mockito.timeout((long)100L).atLeastOnce()))).rollSecret();
            secretProvider.realRollSecret();
            currentSecret = secretProvider.getCurrentSecret();
            allSecrets = secretProvider.getAllSecrets();
            Assert.assertArrayEquals((byte[])secret2, (byte[])currentSecret);
            Assert.assertEquals((long)2L, (long)allSecrets.length);
            Assert.assertArrayEquals((byte[])secret2, (byte[])allSecrets[0]);
            Assert.assertArrayEquals((byte[])secret1, (byte[])allSecrets[1]);
            ((MockZKSignerSecretProvider)((Object)Mockito.verify((Object)((Object)secretProvider), (VerificationMode)Mockito.timeout((long)100L).atLeast(2)))).rollSecret();
            secretProvider.realRollSecret();
            currentSecret = secretProvider.getCurrentSecret();
            allSecrets = secretProvider.getAllSecrets();
            Assert.assertArrayEquals((byte[])secret3, (byte[])currentSecret);
            Assert.assertEquals((long)2L, (long)allSecrets.length);
            Assert.assertArrayEquals((byte[])secret3, (byte[])allSecrets[0]);
            Assert.assertArrayEquals((byte[])secret2, (byte[])allSecrets[1]);
            ((MockZKSignerSecretProvider)((Object)Mockito.verify((Object)((Object)secretProvider), (VerificationMode)Mockito.timeout((long)100L).atLeast(3)))).rollSecret();
            secretProvider.realRollSecret();
        }
        finally {
            secretProvider.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpgradeChangeSecretLength() throws Exception {
        long seed = System.currentTimeMillis();
        Random rand = new Random(seed);
        byte[] secret2 = Long.toString(rand.nextLong()).getBytes(StandardCharsets.UTF_8);
        byte[] secret1 = Long.toString(rand.nextLong()).getBytes(StandardCharsets.UTF_8);
        byte[] secret3 = Long.toString(rand.nextLong()).getBytes(StandardCharsets.UTF_8);
        rand = new Random(seed);
        byte[] secret4 = this.generateNewSecret(rand);
        byte[] secret5 = this.generateNewSecret(rand);
        byte[] secret6 = this.generateNewSecret(rand);
        byte[] secret7 = this.generateNewSecret(rand);
        MockZKSignerSecretProvider oldSecretProvider = (MockZKSignerSecretProvider)((Object)Mockito.spy((Object)((Object)new OldMockZKSignerSecretProvider(seed))));
        Properties config = new Properties();
        config.setProperty("signer.secret.provider.zookeeper.connection.string", this.zkServer.getConnectString());
        config.setProperty("signer.secret.provider.zookeeper.path", "/secret");
        try {
            oldSecretProvider.init(config, this.getDummyServletContext(), 50L);
            byte[] currentSecret = oldSecretProvider.getCurrentSecret();
            byte[][] allSecrets = oldSecretProvider.getAllSecrets();
            Assert.assertArrayEquals((byte[])secret1, (byte[])currentSecret);
            Assert.assertEquals((long)2L, (long)allSecrets.length);
            Assert.assertArrayEquals((byte[])secret1, (byte[])allSecrets[0]);
            Assert.assertNull((Object)allSecrets[1]);
            oldSecretProvider.realRollSecret();
            currentSecret = oldSecretProvider.getCurrentSecret();
            allSecrets = oldSecretProvider.getAllSecrets();
            Assert.assertArrayEquals((byte[])secret2, (byte[])currentSecret);
            Assert.assertEquals((long)2L, (long)allSecrets.length);
            Assert.assertArrayEquals((byte[])secret2, (byte[])allSecrets[0]);
            Assert.assertArrayEquals((byte[])secret1, (byte[])allSecrets[1]);
        }
        finally {
            oldSecretProvider.destroy();
        }
        MockZKSignerSecretProvider newSecretProvider = (MockZKSignerSecretProvider)((Object)Mockito.spy((Object)((Object)new MockZKSignerSecretProvider(seed))));
        try {
            newSecretProvider.init(config, this.getDummyServletContext(), 50L);
            byte[] currentSecret = newSecretProvider.getCurrentSecret();
            byte[][] allSecrets = newSecretProvider.getAllSecrets();
            Assert.assertArrayEquals((byte[])secret2, (byte[])currentSecret);
            Assert.assertEquals((long)2L, (long)allSecrets.length);
            Assert.assertArrayEquals((byte[])secret2, (byte[])allSecrets[0]);
            Assert.assertArrayEquals((byte[])secret1, (byte[])allSecrets[1]);
            newSecretProvider.realRollSecret();
            currentSecret = newSecretProvider.getCurrentSecret();
            allSecrets = newSecretProvider.getAllSecrets();
            Assert.assertArrayEquals((byte[])secret3, (byte[])currentSecret);
            Assert.assertEquals((long)2L, (long)allSecrets.length);
            Assert.assertArrayEquals((byte[])secret3, (byte[])allSecrets[0]);
            Assert.assertArrayEquals((byte[])secret2, (byte[])allSecrets[1]);
            newSecretProvider.realRollSecret();
            currentSecret = newSecretProvider.getCurrentSecret();
            allSecrets = newSecretProvider.getAllSecrets();
            Assert.assertArrayEquals((byte[])secret6, (byte[])currentSecret);
            Assert.assertEquals((long)2L, (long)allSecrets.length);
            Assert.assertArrayEquals((byte[])secret6, (byte[])allSecrets[0]);
            Assert.assertArrayEquals((byte[])secret3, (byte[])allSecrets[1]);
            newSecretProvider.realRollSecret();
            currentSecret = newSecretProvider.getCurrentSecret();
            allSecrets = newSecretProvider.getAllSecrets();
            Assert.assertArrayEquals((byte[])secret7, (byte[])currentSecret);
            Assert.assertEquals((long)2L, (long)allSecrets.length);
            Assert.assertArrayEquals((byte[])secret7, (byte[])allSecrets[0]);
            Assert.assertArrayEquals((byte[])secret6, (byte[])allSecrets[1]);
        }
        finally {
            newSecretProvider.destroy();
        }
    }

    @Test
    public void testMultiple1() throws Exception {
        this.testMultiple(1);
    }

    @Test
    public void testMultiple2() throws Exception {
        this.testMultiple(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testMultiple(int order) throws Exception {
        long seedA = System.currentTimeMillis();
        Random rand = new Random(seedA);
        byte[] secretA2 = this.generateNewSecret(rand);
        byte[] secretA1 = this.generateNewSecret(rand);
        byte[] secretA3 = this.generateNewSecret(rand);
        byte[] secretA4 = this.generateNewSecret(rand);
        long seedB = System.currentTimeMillis() + rand.nextLong();
        rand = new Random(seedB);
        byte[] secretB2 = this.generateNewSecret(rand);
        byte[] secretB1 = this.generateNewSecret(rand);
        byte[] secretB3 = this.generateNewSecret(rand);
        byte[] secretB4 = this.generateNewSecret(rand);
        MockZKSignerSecretProvider secretProviderA = (MockZKSignerSecretProvider)((Object)Mockito.spy((Object)((Object)new MockZKSignerSecretProvider(seedA))));
        MockZKSignerSecretProvider secretProviderB = (MockZKSignerSecretProvider)((Object)Mockito.spy((Object)((Object)new MockZKSignerSecretProvider(seedB))));
        Properties config = new Properties();
        config.setProperty("signer.secret.provider.zookeeper.connection.string", this.zkServer.getConnectString());
        config.setProperty("signer.secret.provider.zookeeper.path", "/secret");
        try {
            secretProviderA.init(config, this.getDummyServletContext(), 50L);
            secretProviderB.init(config, this.getDummyServletContext(), 50L);
            byte[] currentSecretA = secretProviderA.getCurrentSecret();
            byte[][] allSecretsA = secretProviderA.getAllSecrets();
            byte[] currentSecretB = secretProviderB.getCurrentSecret();
            byte[][] allSecretsB = secretProviderB.getAllSecrets();
            Assert.assertArrayEquals((byte[])secretA1, (byte[])currentSecretA);
            Assert.assertArrayEquals((byte[])secretA1, (byte[])currentSecretB);
            Assert.assertEquals((long)2L, (long)allSecretsA.length);
            Assert.assertEquals((long)2L, (long)allSecretsB.length);
            Assert.assertArrayEquals((byte[])secretA1, (byte[])allSecretsA[0]);
            Assert.assertArrayEquals((byte[])secretA1, (byte[])allSecretsB[0]);
            Assert.assertNull((Object)allSecretsA[1]);
            Assert.assertNull((Object)allSecretsB[1]);
            ((MockZKSignerSecretProvider)((Object)Mockito.verify((Object)((Object)secretProviderA), (VerificationMode)Mockito.timeout((long)100L).atLeastOnce()))).rollSecret();
            ((MockZKSignerSecretProvider)((Object)Mockito.verify((Object)((Object)secretProviderB), (VerificationMode)Mockito.timeout((long)100L).atLeastOnce()))).rollSecret();
            secretProviderA.realRollSecret();
            secretProviderB.realRollSecret();
            currentSecretA = secretProviderA.getCurrentSecret();
            allSecretsA = secretProviderA.getAllSecrets();
            Assert.assertArrayEquals((byte[])secretA2, (byte[])currentSecretA);
            Assert.assertEquals((long)2L, (long)allSecretsA.length);
            Assert.assertArrayEquals((byte[])secretA2, (byte[])allSecretsA[0]);
            Assert.assertArrayEquals((byte[])secretA1, (byte[])allSecretsA[1]);
            currentSecretB = secretProviderB.getCurrentSecret();
            allSecretsB = secretProviderB.getAllSecrets();
            Assert.assertArrayEquals((byte[])secretA2, (byte[])currentSecretB);
            Assert.assertEquals((long)2L, (long)allSecretsA.length);
            Assert.assertArrayEquals((byte[])secretA2, (byte[])allSecretsB[0]);
            Assert.assertArrayEquals((byte[])secretA1, (byte[])allSecretsB[1]);
            ((MockZKSignerSecretProvider)((Object)Mockito.verify((Object)((Object)secretProviderA), (VerificationMode)Mockito.timeout((long)100L).atLeast(2)))).rollSecret();
            ((MockZKSignerSecretProvider)((Object)Mockito.verify((Object)((Object)secretProviderB), (VerificationMode)Mockito.timeout((long)100L).atLeastOnce()))).rollSecret();
            switch (order) {
                case 1: {
                    secretProviderA.realRollSecret();
                    secretProviderB.realRollSecret();
                    secretProviderA.realRollSecret();
                    secretProviderB.realRollSecret();
                    break;
                }
                case 2: {
                    secretProviderB.realRollSecret();
                    secretProviderA.realRollSecret();
                    secretProviderB.realRollSecret();
                    secretProviderA.realRollSecret();
                    break;
                }
                default: {
                    throw new Exception("Invalid order selected");
                }
            }
            currentSecretA = secretProviderA.getCurrentSecret();
            allSecretsA = secretProviderA.getAllSecrets();
            currentSecretB = secretProviderB.getCurrentSecret();
            allSecretsB = secretProviderB.getAllSecrets();
            Assert.assertArrayEquals((byte[])currentSecretA, (byte[])currentSecretB);
            Assert.assertEquals((long)2L, (long)allSecretsA.length);
            Assert.assertEquals((long)2L, (long)allSecretsB.length);
            Assert.assertArrayEquals((byte[])allSecretsA[0], (byte[])allSecretsB[0]);
            Assert.assertArrayEquals((byte[])allSecretsA[1], (byte[])allSecretsB[1]);
            switch (order) {
                case 1: {
                    Assert.assertArrayEquals((byte[])secretA4, (byte[])allSecretsA[0]);
                    return;
                }
                case 2: {
                    Assert.assertArrayEquals((byte[])secretB4, (byte[])allSecretsA[0]);
                    return;
                }
            }
            return;
        }
        finally {
            secretProviderB.destroy();
            secretProviderA.destroy();
        }
    }

    private ServletContext getDummyServletContext() {
        ServletContext servletContext = (ServletContext)Mockito.mock(ServletContext.class);
        Mockito.when((Object)servletContext.getAttribute("signer.secret.provider.zookeeper.curator.client")).thenReturn(null);
        return servletContext;
    }

    private byte[] generateNewSecret(Random rand) {
        byte[] secret = new byte[32];
        rand.nextBytes(secret);
        return secret;
    }

    private class MockZKSignerSecretProvider
    extends ZKSignerSecretProvider {
        MockZKSignerSecretProvider(long seed) {
            super(seed);
        }

        protected synchronized void rollSecret() {
        }

        public void realRollSecret() {
            super.rollSecret();
        }
    }

    private class OldMockZKSignerSecretProvider
    extends MockZKSignerSecretProvider {
        private Random rand;

        OldMockZKSignerSecretProvider(long seed) {
            super(seed);
            this.rand = new Random(seed);
        }

        protected byte[] generateRandomSecret() {
            return Long.toString(this.rand.nextLong()).getBytes(StandardCharsets.UTF_8);
        }
    }
}

