/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.client;

import java.lang.invoke.CallSite;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.client.Authenticator;
import org.apache.hadoop.security.authentication.client.ConnectionConfigurator;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestAuthenticatedURL {
    @Test
    public void testToken() throws Exception {
        AuthenticatedURL.Token token = new AuthenticatedURL.Token();
        Assert.assertFalse((boolean)token.isSet());
        token = new AuthenticatedURL.Token("foo");
        Assert.assertTrue((boolean)token.isSet());
        Assert.assertEquals((Object)"foo", (Object)token.toString());
    }

    @Test
    public void testInjectToken() throws Exception {
        HttpURLConnection conn = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        AuthenticatedURL.Token token = new AuthenticatedURL.Token();
        token.set("foo");
        AuthenticatedURL.injectToken((HttpURLConnection)conn, (AuthenticatedURL.Token)token);
        ((HttpURLConnection)Mockito.verify((Object)conn)).addRequestProperty((String)Mockito.eq((Object)"Cookie"), Mockito.anyString());
    }

    @Test
    public void testExtractTokenOK() throws Exception {
        HttpURLConnection conn = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        Mockito.when((Object)conn.getResponseCode()).thenReturn((Object)200);
        String tokenStr = "foo";
        HashMap headers = new HashMap();
        ArrayList<CallSite> cookies = new ArrayList<CallSite>();
        cookies.add((CallSite)((Object)("hadoop.auth=" + tokenStr)));
        headers.put("Set-Cookie", cookies);
        Mockito.when(conn.getHeaderFields()).thenReturn(headers);
        AuthenticatedURL.Token token = new AuthenticatedURL.Token();
        AuthenticatedURL.extractToken((HttpURLConnection)conn, (AuthenticatedURL.Token)token);
        Assert.assertEquals((Object)tokenStr, (Object)token.toString());
    }

    @Test
    public void testExtractTokenFail() throws Exception {
        HttpURLConnection conn = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        Mockito.when((Object)conn.getResponseCode()).thenReturn((Object)401);
        String tokenStr = "foo";
        HashMap headers = new HashMap();
        ArrayList<CallSite> cookies = new ArrayList<CallSite>();
        cookies.add((CallSite)((Object)("hadoop.auth=" + tokenStr)));
        headers.put("Set-Cookie", cookies);
        Mockito.when(conn.getHeaderFields()).thenReturn(headers);
        AuthenticatedURL.Token token = new AuthenticatedURL.Token();
        token.set("bar");
        try {
            AuthenticatedURL.extractToken((HttpURLConnection)conn, (AuthenticatedURL.Token)token);
            Assert.fail();
        }
        catch (AuthenticationException ex) {
            Assert.assertFalse((boolean)token.isSet());
        }
        catch (Exception ex) {
            Assert.fail();
        }
    }

    @Test
    public void testExtractTokenCookieHeader() throws Exception {
        HttpURLConnection conn = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        Mockito.when((Object)conn.getResponseCode()).thenReturn((Object)200);
        String tokenStr = "foo";
        HashMap headers = new HashMap();
        ArrayList<CallSite> cookies = new ArrayList<CallSite>();
        cookies.add((CallSite)((Object)("hadoop.auth=" + tokenStr)));
        headers.put("Set-Cookie", cookies);
        Mockito.when(conn.getHeaderFields()).thenReturn(headers);
        AuthenticatedURL.Token token = new AuthenticatedURL.Token();
        AuthenticatedURL.extractToken((HttpURLConnection)conn, (AuthenticatedURL.Token)token);
        Assert.assertTrue((boolean)token.isSet());
    }

    @Test
    public void testExtractTokenLowerCaseCookieHeader() throws Exception {
        HttpURLConnection conn = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        Mockito.when((Object)conn.getResponseCode()).thenReturn((Object)200);
        String tokenStr = "foo";
        HashMap headers = new HashMap();
        ArrayList<CallSite> cookies = new ArrayList<CallSite>();
        cookies.add((CallSite)((Object)("hadoop.auth=" + tokenStr)));
        headers.put("set-cookie", cookies);
        Mockito.when(conn.getHeaderFields()).thenReturn(headers);
        AuthenticatedURL.Token token = new AuthenticatedURL.Token();
        AuthenticatedURL.extractToken((HttpURLConnection)conn, (AuthenticatedURL.Token)token);
        Assert.assertTrue((boolean)token.isSet());
    }

    @Test
    public void testConnectionConfigurator() throws Exception {
        HttpURLConnection conn = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        Mockito.when((Object)conn.getResponseCode()).thenReturn((Object)401);
        ConnectionConfigurator connConf = (ConnectionConfigurator)Mockito.mock(ConnectionConfigurator.class);
        Mockito.when((Object)connConf.configure((HttpURLConnection)Mockito.any())).thenReturn((Object)conn);
        Authenticator authenticator = (Authenticator)Mockito.mock(Authenticator.class);
        AuthenticatedURL aURL = new AuthenticatedURL(authenticator, connConf);
        aURL.openConnection(new URL("http://foo"), new AuthenticatedURL.Token());
        ((ConnectionConfigurator)Mockito.verify((Object)connConf)).configure((HttpURLConnection)Mockito.any());
    }

    @Test
    public void testGetAuthenticator() throws Exception {
        Authenticator authenticator = (Authenticator)Mockito.mock(Authenticator.class);
        AuthenticatedURL aURL = new AuthenticatedURL(authenticator);
        Assert.assertEquals((Object)authenticator, (Object)aURL.getAuthenticator());
    }
}

