/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.client;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.ServerSocket;
import java.net.URL;
import java.security.Principal;
import java.util.EnumSet;
import java.util.Properties;
import javax.servlet.DispatcherType;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.Authenticator;
import org.apache.hadoop.security.authentication.client.ConnectionConfigurator;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.auth.SPNegoScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.junit.Assert;

public class AuthenticatorTestCase {
    private Server server;
    private String host = null;
    private int port = -1;
    ServletContextHandler context;
    private static Properties authenticatorConfig;
    private String POST = "test";

    protected static void setAuthenticationHandlerConfig(Properties config) {
        authenticatorConfig = config;
    }

    protected int getLocalPort() throws Exception {
        ServerSocket ss = new ServerSocket(0);
        int ret = ss.getLocalPort();
        ss.close();
        return ret;
    }

    protected void start() throws Exception {
        this.startJetty();
    }

    protected void startJetty() throws Exception {
        this.server = new Server();
        this.context = new ServletContextHandler();
        this.context.setContextPath("/foo");
        this.server.setHandler((Handler)this.context);
        this.context.addFilter(new FilterHolder(TestFilter.class), "/*", EnumSet.of(DispatcherType.REQUEST));
        this.context.addServlet(new ServletHolder(TestServlet.class), "/bar");
        this.host = "localhost";
        this.port = this.getLocalPort();
        ServerConnector connector = new ServerConnector(this.server);
        connector.setHost(this.host);
        connector.setPort(this.port);
        this.server.setConnectors(new Connector[]{connector});
        this.server.start();
        System.out.println("Running embedded servlet container at: http://" + this.host + ":" + this.port);
    }

    protected void stop() throws Exception {
        this.stopJetty();
    }

    protected void stopJetty() throws Exception {
        try {
            this.server.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.server.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String getBaseURL() {
        return "http://" + this.host + ":" + this.port + "/foo/bar";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _testAuthentication(Authenticator authenticator, boolean doPost) throws Exception {
        this.start();
        try {
            URL url = new URL(this.getBaseURL());
            AuthenticatedURL.Token token = new AuthenticatedURL.Token();
            Assert.assertFalse((boolean)token.isSet());
            TestConnectionConfigurator connConf = new TestConnectionConfigurator();
            AuthenticatedURL aUrl = new AuthenticatedURL(authenticator, (ConnectionConfigurator)connConf);
            HttpURLConnection conn = aUrl.openConnection(url, token);
            Assert.assertTrue((boolean)connConf.invoked);
            String tokenStr = token.toString();
            if (doPost) {
                conn.setRequestMethod("POST");
                conn.setDoOutput(true);
            }
            conn.connect();
            if (doPost) {
                OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream());
                writer.write(this.POST);
                ((Writer)writer).close();
            }
            Assert.assertEquals((long)200L, (long)conn.getResponseCode());
            if (doPost) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                String echo = reader.readLine();
                Assert.assertEquals((Object)this.POST, (Object)echo);
                Assert.assertNull((Object)reader.readLine());
            }
            aUrl = new AuthenticatedURL();
            conn = aUrl.openConnection(url, token);
            conn.connect();
            Assert.assertEquals((long)200L, (long)conn.getResponseCode());
            Assert.assertEquals((Object)tokenStr, (Object)token.toString());
        }
        finally {
            this.stop();
        }
    }

    private HttpClient getHttpClient() {
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.setDefaultAuthSchemeRegistry(s -> httpContext -> new SPNegoScheme(true, true));
        Credentials useJaasCreds = new Credentials(){

            public String getPassword() {
                return null;
            }

            public Principal getUserPrincipal() {
                return null;
            }
        };
        BasicCredentialsProvider jaasCredentialProvider = new BasicCredentialsProvider();
        jaasCredentialProvider.setCredentials(AuthScope.ANY, useJaasCreds);
        builder.setDefaultCredentialsProvider((CredentialsProvider)jaasCredentialProvider);
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doHttpClientRequest(HttpClient httpClient, HttpUriRequest request) throws Exception {
        HttpResponse response = null;
        try {
            response = httpClient.execute(request);
            int httpStatus = response.getStatusLine().getStatusCode();
            Assert.assertEquals((long)200L, (long)httpStatus);
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _testAuthenticationHttpClient(Authenticator authenticator, boolean doPost) throws Exception {
        this.start();
        try {
            HttpClient httpClient = this.getHttpClient();
            this.doHttpClientRequest(httpClient, (HttpUriRequest)new HttpGet(this.getBaseURL()));
            if (doPost) {
                HttpPost post = new HttpPost(this.getBaseURL());
                byte[] postBytes = this.POST.getBytes();
                ByteArrayInputStream bis = new ByteArrayInputStream(postBytes);
                InputStreamEntity entity = new InputStreamEntity((InputStream)bis, (long)postBytes.length);
                Assert.assertFalse((boolean)entity.isRepeatable());
                post.setEntity((HttpEntity)entity);
                this.doHttpClientRequest(httpClient, (HttpUriRequest)post);
            }
        }
        finally {
            this.stop();
        }
    }

    public static class TestFilter
    extends AuthenticationFilter {
        protected Properties getConfiguration(String configPrefix, FilterConfig filterConfig) throws ServletException {
            return authenticatorConfig;
        }
    }

    public static class TestServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.setStatus(200);
        }

        protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            ServletInputStream is = req.getInputStream();
            ServletOutputStream os = resp.getOutputStream();
            int c = is.read();
            while (c > -1) {
                os.write(c);
                c = is.read();
            }
            is.close();
            os.close();
            resp.setStatus(200);
        }
    }

    private static class TestConnectionConfigurator
    implements ConnectionConfigurator {
        boolean invoked;

        private TestConnectionConfigurator() {
        }

        public HttpURLConnection configure(HttpURLConnection conn) throws IOException {
            this.invoked = true;
            return conn;
        }
    }
}

