/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.hive;

import java.io.IOException;
import java.util.Collection;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.sink.hive.HiveEventSerializer;
import org.apache.hive.hcatalog.streaming.DelimitedInputWriter;
import org.apache.hive.hcatalog.streaming.HiveEndPoint;
import org.apache.hive.hcatalog.streaming.RecordWriter;
import org.apache.hive.hcatalog.streaming.StreamingException;
import org.apache.hive.hcatalog.streaming.TransactionBatch;

public class HiveDelimitedTextSerializer
implements HiveEventSerializer {
    public static final String ALIAS = "DELIMITED";
    public static final String defaultDelimiter = ",";
    public static final String SERIALIZER_DELIMITER = "serializer.delimiter";
    public static final String SERIALIZER_FIELDNAMES = "serializer.fieldnames";
    public static final String SERIALIZER_SERDE_SEPARATOR = "serializer.serdeSeparator";
    private String delimiter;
    private String[] fieldToColMapping = null;
    private Character serdeSeparator = null;

    @Override
    public void write(TransactionBatch txnBatch, Event e) throws StreamingException, IOException, InterruptedException {
        txnBatch.write(e.getBody());
    }

    @Override
    public void write(TransactionBatch txnBatch, Collection<byte[]> events) throws StreamingException, IOException, InterruptedException {
        txnBatch.write(events);
    }

    @Override
    public RecordWriter createRecordWriter(HiveEndPoint endPoint) throws StreamingException, IOException, ClassNotFoundException {
        if (this.serdeSeparator == null) {
            return new DelimitedInputWriter(this.fieldToColMapping, this.delimiter, endPoint);
        }
        return new DelimitedInputWriter(this.fieldToColMapping, this.delimiter, endPoint, null, this.serdeSeparator.charValue());
    }

    public void configure(Context context) {
        this.delimiter = HiveDelimitedTextSerializer.parseDelimiterSpec(context.getString(SERIALIZER_DELIMITER, defaultDelimiter));
        String fieldNames = context.getString(SERIALIZER_FIELDNAMES);
        if (fieldNames == null) {
            throw new IllegalArgumentException("serializer.fieldnames is not specified for serializer " + this.getClass().getName());
        }
        String serdeSeparatorStr = context.getString(SERIALIZER_SERDE_SEPARATOR);
        this.serdeSeparator = HiveDelimitedTextSerializer.parseSerdeSeparatorSpec(serdeSeparatorStr);
        this.fieldToColMapping = fieldNames.trim().split(defaultDelimiter, -1);
    }

    private static String parseDelimiterSpec(String delimiter) {
        if (delimiter == null) {
            return null;
        }
        if (delimiter.charAt(0) == '\"' && delimiter.charAt(delimiter.length() - 1) == '\"') {
            return delimiter.substring(1, delimiter.length() - 1);
        }
        return delimiter;
    }

    private static Character parseSerdeSeparatorSpec(String separatorStr) {
        if (separatorStr == null) {
            return null;
        }
        if (separatorStr.length() == 1) {
            return Character.valueOf(separatorStr.charAt(0));
        }
        if (separatorStr.length() == 3 && separatorStr.charAt(2) == '\'' && separatorStr.charAt(separatorStr.length() - 1) == '\'') {
            return Character.valueOf(separatorStr.charAt(1));
        }
        throw new IllegalArgumentException("serializer.serdeSeparator spec is invalid for DELIMITED serializer ");
    }
}

