/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.flume.Channel;
import org.apache.flume.ChannelException;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.FlumeException;
import org.apache.flume.Sink;
import org.apache.flume.Transaction;
import org.apache.flume.api.RpcClient;
import org.apache.flume.conf.Configurable;
import org.apache.flume.instrumentation.SinkCounter;
import org.apache.flume.sink.AbstractSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRpcSink
extends AbstractSink
implements Configurable {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRpcSink.class);
    private String hostname;
    private Integer port;
    private RpcClient client;
    private Properties clientProps;
    private SinkCounter sinkCounter;
    private int cxnResetInterval;
    private final int DEFAULT_CXN_RESET_INTERVAL = 0;
    private final ScheduledExecutorService cxnResetExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("Rpc Sink Reset Thread").build());
    private final Lock resetLock = new ReentrantLock();

    @Override
    public void configure(Context context) {
        this.clientProps = new Properties();
        this.hostname = context.getString("hostname");
        this.port = context.getInteger("port");
        Preconditions.checkState((this.hostname != null ? 1 : 0) != 0, (Object)"No hostname specified");
        Preconditions.checkState((this.port != null ? 1 : 0) != 0, (Object)"No port specified");
        this.clientProps.setProperty("hosts", "h1");
        this.clientProps.setProperty("hosts.h1", this.hostname + ":" + this.port);
        for (Map.Entry entry : context.getParameters().entrySet()) {
            this.clientProps.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        if (this.sinkCounter == null) {
            this.sinkCounter = new SinkCounter(this.getName());
        }
        this.cxnResetInterval = context.getInteger("reset-connection-interval", Integer.valueOf(0));
        if (this.cxnResetInterval == 0) {
            logger.info("Connection reset is set to " + String.valueOf(0) + ". Will not reset connection to next " + "hop");
        }
    }

    protected abstract RpcClient initializeRpcClient(Properties var1);

    private void createConnection() throws FlumeException {
        if (this.client == null) {
            logger.info("Rpc sink {}: Building RpcClient with hostname: {}, port: {}", new Object[]{this.getName(), this.hostname, this.port});
            try {
                this.client = this.initializeRpcClient(this.clientProps);
                Preconditions.checkNotNull((Object)this.client, (Object)("Rpc Client could not be initialized. " + this.getName() + " could not be started"));
                this.sinkCounter.incrementConnectionCreatedCount();
                if (this.cxnResetInterval > 0) {
                    this.cxnResetExecutor.schedule(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            AbstractRpcSink.this.resetLock.lock();
                            try {
                                AbstractRpcSink.this.destroyConnection();
                                AbstractRpcSink.this.createConnection();
                            }
                            catch (Throwable throwable) {
                                logger.error("Error while trying to expire connection", throwable);
                            }
                            finally {
                                AbstractRpcSink.this.resetLock.unlock();
                            }
                        }
                    }, (long)this.cxnResetInterval, TimeUnit.SECONDS);
                }
            }
            catch (Exception ex) {
                this.sinkCounter.incrementConnectionFailedCount();
                if (ex instanceof FlumeException) {
                    throw (FlumeException)((Object)ex);
                }
                throw new FlumeException((Throwable)ex);
            }
            logger.debug("Rpc sink {}: Created RpcClient: {}", (Object)this.getName(), (Object)this.client);
        }
    }

    private void destroyConnection() {
        if (this.client != null) {
            logger.debug("Rpc sink {} closing Rpc client: {}", (Object)this.getName(), (Object)this.client);
            try {
                this.client.close();
                this.sinkCounter.incrementConnectionClosedCount();
            }
            catch (FlumeException e) {
                this.sinkCounter.incrementConnectionFailedCount();
                logger.error("Rpc sink " + this.getName() + ": Attempt to close Rpc " + "client failed. Exception follows.", (Throwable)e);
            }
        }
        this.client = null;
    }

    private void verifyConnection() throws FlumeException {
        if (this.client == null) {
            this.createConnection();
        } else if (!this.client.isActive()) {
            this.destroyConnection();
            this.createConnection();
        }
    }

    @Override
    public void start() {
        logger.info("Starting {}...", (Object)this);
        this.sinkCounter.start();
        try {
            this.createConnection();
        }
        catch (FlumeException e) {
            logger.warn("Unable to create Rpc client using hostname: " + this.hostname + ", port: " + this.port, (Throwable)e);
            this.destroyConnection();
        }
        super.start();
        logger.info("Rpc sink {} started.", (Object)this.getName());
    }

    @Override
    public void stop() {
        logger.info("Rpc sink {} stopping...", (Object)this.getName());
        this.destroyConnection();
        this.cxnResetExecutor.shutdown();
        try {
            if (this.cxnResetExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.cxnResetExecutor.shutdownNow();
            }
        }
        catch (Exception ex) {
            logger.error("Interrupted while waiting for connection reset executor to shut down");
        }
        this.sinkCounter.stop();
        super.stop();
        logger.info("Rpc sink {} stopped. Metrics: {}", (Object)this.getName(), (Object)this.sinkCounter);
    }

    @Override
    public String toString() {
        return "RpcSink " + this.getName() + " { host: " + this.hostname + ", port: " + this.port + " }";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sink.Status process() throws EventDeliveryException {
        Sink.Status status;
        block12: {
            status = Sink.Status.READY;
            Channel channel = this.getChannel();
            Transaction transaction = channel.getTransaction();
            this.resetLock.lock();
            try {
                Event event;
                transaction.begin();
                this.verifyConnection();
                LinkedList batch = Lists.newLinkedList();
                for (int i = 0; i < this.client.getBatchSize() && (event = channel.take()) != null; ++i) {
                    batch.add(event);
                }
                int size = batch.size();
                int batchSize = this.client.getBatchSize();
                if (size == 0) {
                    this.sinkCounter.incrementBatchEmptyCount();
                    status = Sink.Status.BACKOFF;
                } else {
                    if (size < batchSize) {
                        this.sinkCounter.incrementBatchUnderflowCount();
                    } else {
                        this.sinkCounter.incrementBatchCompleteCount();
                    }
                    this.sinkCounter.addToEventDrainAttemptCount(size);
                    this.client.appendBatch((List)batch);
                }
                transaction.commit();
                this.sinkCounter.addToEventDrainSuccessCount(size);
            }
            catch (Throwable t) {
                transaction.rollback();
                if (t instanceof Error) {
                    throw (Error)t;
                }
                if (t instanceof ChannelException) {
                    logger.error("Rpc Sink " + this.getName() + ": Unable to get event from" + " channel " + channel.getName() + ". Exception follows.", t);
                    status = Sink.Status.BACKOFF;
                    break block12;
                }
                this.destroyConnection();
                throw new EventDeliveryException("Failed to send events", t);
            }
            finally {
                this.resetLock.unlock();
                transaction.close();
            }
        }
        return status;
    }

    @VisibleForTesting
    RpcClient getUnderlyingClient() {
        return this.client;
    }
}

