/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.tpcds.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.api.java.utils.ParameterTool;

public class AnswerFormatter {
    private static final int SPACE_BETWEEN_COL = 1;
    private static final String RESULT_HEAD_STRING_BAR = "|";
    private static final String RESULT_HEAD_STRING_DASH = "--";
    private static final String RESULT_HEAD_STRING_SPACE = " ";
    private static final String COL_DELIMITER = "|";
    private static final String ANSWER_FILE_SUFFIX = ".ans";
    private static final String REGEX_SPLIT_BAR = "\\|";
    private static final String FILE_SEPARATOR = "/";
    private static final List<String> ORIGIN_ANSWER_FILE = Arrays.asList("1", "2", "3", "4", "5_NULLS_FIRST", "6_NULLS_FIRST", "7", "8_SQL_SERVER", "9", "10", "11", "12", "13", "14a_SQL_SERVER", "14b_NULLS_FIRST", "15_NULLS_FIRST", "16", "17", "18_SQL_SERVER", "19", "20_NULLS_FIRST", "21_NULLS_FIRST", "22_NULLS_FIRST", "23a_NULLS_FIRST", "23b_NULLS_FIRST", "24a", "24b", "25", "26", "27_NULLS_FIRST", "28", "29", "30", "31", "32", "33", "34_NULLS_FIRST", "35_NULLS_FIRST", "36_NULLS_FIRST", "37", "38", "39a", "39b", "40", "41", "42", "43", "44", "45", "46_NULLS_FIRST", "47", "48", "49", "50", "51", "52", "53", "54", "55", "56_NULLS_FIRST", "57", "58", "59", "60", "61", "62_NULLS_FIRST", "63", "64", "65_NULLS_FIRST", "66_NULLS_FIRST", "67_NULLS_FIRST", "68_NULLS_FIRST", "69", "70_SQL_SERVER", "71_NULLS_LAST", "72_NULLS_FIRST", "73", "74", "75", "76_NULLS_FIRST", "77_SQL_SERVER", "78", "79_NULLS_FIRST", "80_NULLS_FIRST", "81", "82", "83", "84", "85", "86_NULLS_FIRST", "87", "88", "89", "90", "91", "92", "93_NULLS_FIRST", "94", "95", "96", "97", "98_NULLS_FIRST", "99_NULLS_FIRST");

    public static void main(String[] args) throws Exception {
        ParameterTool params = ParameterTool.fromArgs((String[])args);
        String originDir = params.getRequired("originDir");
        String destDir = params.getRequired("destDir");
        for (int i = 0; i < ORIGIN_ANSWER_FILE.size(); ++i) {
            String file = ORIGIN_ANSWER_FILE.get(i);
            String originFileName = file + ANSWER_FILE_SUFFIX;
            String destFileName = file.split("_")[0] + ANSWER_FILE_SUFFIX;
            File originFile = new File(originDir + FILE_SEPARATOR + originFileName);
            File destFile = new File(destDir + FILE_SEPARATOR + destFileName);
            AnswerFormatter.format(originFile, destFile);
        }
    }

    private static void format(File originFile, File destFile) throws Exception {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(originFile));
        BufferedWriter writer = new BufferedWriter(new FileWriter(destFile));
        ArrayList<String> content = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            content.add(line);
        }
        if (AnswerFormatter.isFormat1(content).booleanValue()) {
            List<Integer> colLengthList = Arrays.stream(((String)content.get(1)).split(REGEX_SPLIT_BAR)).map(col -> col.length()).collect(Collectors.toList());
            AnswerFormatter.writeContent(writer, content, colLengthList);
        } else if (AnswerFormatter.isFormat2(content).booleanValue()) {
            List<Integer> colLengthList = Arrays.stream(((String)content.get(1)).split(RESULT_HEAD_STRING_SPACE)).map(col -> col.length()).collect(Collectors.toList());
            AnswerFormatter.writeContent(writer, content, colLengthList);
        } else {
            AnswerFormatter.writeContent(writer, content, null);
        }
        reader.close();
        writer.close();
    }

    private static Boolean isFormat1(List<String> content) {
        return content.size() > 1 && content.get(0).contains("|") && content.get(1).contains(RESULT_HEAD_STRING_DASH);
    }

    private static Boolean isFormat2(List<String> content) {
        return content.size() > 1 && content.get(1).contains(RESULT_HEAD_STRING_DASH);
    }

    private static String formatRow(String row, List<Integer> colLengthList) {
        StringBuilder sb = new StringBuilder();
        int end = 0;
        for (int i = 0; i < colLengthList.size(); ++i) {
            int start = i == 0 ? end : end + 1;
            start = start < row.length() ? start : row.length();
            end = start + colLengthList.get(i) < row.length() ? start + colLengthList.get(i) : row.length();
            sb.append(row.substring(start, end).trim());
            if (i == colLengthList.size() - 1) continue;
            sb.append("|");
        }
        return sb.toString();
    }

    private static void writeContent(BufferedWriter writer, List<String> content, List<Integer> colLengthList) throws Exception {
        if (colLengthList != null) {
            for (int i = 2; i < content.size() && !content.get(i).isEmpty() && !content.get(i).endsWith("rows selected.)"); ++i) {
                String row = content.get(i);
                String formatRow = AnswerFormatter.formatRow(row, colLengthList);
                writer.write(formatRow);
                writer.write("\n");
            }
        } else {
            for (int i = 1; !(i >= content.size() || i == content.size() - 1 && content.get(i).endsWith("rows)")); ++i) {
                String formattedLine = content.get(i);
                writer.write(formattedLine);
                writer.write("\n");
            }
        }
    }
}

