/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.tpcds.stats;

import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.stats.CatalogColumnStatistics;
import org.apache.flink.table.catalog.stats.CatalogTableStatistics;

public class CatalogTableStats {
    private final CatalogTableStatistics catalogTableStatistics;
    private final CatalogColumnStatistics catalogColumnStatistics;

    public CatalogTableStats(CatalogTableStatistics catalogTableStatistics, CatalogColumnStatistics catalogColumnStatistics) {
        this.catalogTableStatistics = catalogTableStatistics;
        this.catalogColumnStatistics = catalogColumnStatistics;
    }

    public void register2Catalog(TableEnvironment tEnv, String table) {
        tEnv.getCatalog(tEnv.getCurrentCatalog()).ifPresent(catalog -> {
            try {
                catalog.alterTableStatistics(new ObjectPath(tEnv.getCurrentDatabase(), table), this.catalogTableStatistics, false);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        tEnv.getCatalog(tEnv.getCurrentCatalog()).ifPresent(catalog -> {
            try {
                catalog.alterTableColumnStatistics(new ObjectPath(tEnv.getCurrentDatabase(), table), this.catalogColumnStatistics, false);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }
}

