/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.extraction;

import java.lang.reflect.Executable;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.shaded.guava32.com.google.common.collect.ImmutableList;
import org.apache.flink.table.types.extraction.ExtractionUtils;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;

public class ExtractionUtilsTest {
    @Test
    void testAutoboxing() {
        AssertionsForClassTypes.assertThat((boolean)ExtractionUtils.isAssignable(Integer.TYPE, Integer.class, (ExtractionUtils.Autoboxing)ExtractionUtils.Autoboxing.STRICT)).isTrue();
        AssertionsForClassTypes.assertThat((boolean)ExtractionUtils.isAssignable(Integer.class, Integer.TYPE, (ExtractionUtils.Autoboxing)ExtractionUtils.Autoboxing.STRICT)).isFalse();
        AssertionsForClassTypes.assertThat((boolean)ExtractionUtils.isAssignable(Integer.class, Integer.TYPE, (ExtractionUtils.Autoboxing)ExtractionUtils.Autoboxing.JVM)).isTrue();
        AssertionsForClassTypes.assertThat((boolean)ExtractionUtils.isAssignable(Integer.class, Number.class, (ExtractionUtils.Autoboxing)ExtractionUtils.Autoboxing.STRICT)).isTrue();
    }

    @Test
    void testResolveParameters() {
        List methods = ExtractionUtils.collectMethods(LongClass.class, (String)"method");
        Method method = (Method)methods.get(0);
        Type longType = ExtractionUtils.resolveVariableWithClassContext(LongClass.class, (Type)method.getGenericParameterTypes()[0]);
        Type futureType = ExtractionUtils.resolveVariableWithClassContext(LongClass.class, (Type)method.getGenericParameterTypes()[1]);
        Type listOfFutures = ExtractionUtils.resolveVariableWithClassContext(LongClass.class, (Type)method.getGenericParameterTypes()[2]);
        Type arrayType = ExtractionUtils.resolveVariableWithClassContext(LongClass.class, (Type)method.getGenericParameterTypes()[3]);
        AssertionsForClassTypes.assertThat((Object)longType).isEqualTo(Long.class);
        AssertionsForClassTypes.assertThat((Object)futureType).isInstanceOf(ParameterizedType.class);
        AssertionsForClassTypes.assertThat((Object)((ParameterizedType)futureType).getRawType()).isEqualTo(CompletableFuture.class);
        AssertionsForClassTypes.assertThat((Object)((ParameterizedType)futureType).getActualTypeArguments()[0]).isEqualTo(Long.class);
        AssertionsForClassTypes.assertThat((Object)listOfFutures).isInstanceOf(ParameterizedType.class);
        AssertionsForClassTypes.assertThat((Object)((ParameterizedType)listOfFutures).getRawType()).isEqualTo(List.class);
        AssertionsForClassTypes.assertThat((Object)((ParameterizedType)listOfFutures).getActualTypeArguments()[0]).isInstanceOf(ParameterizedType.class);
        ParameterizedType innerFuture = (ParameterizedType)((ParameterizedType)listOfFutures).getActualTypeArguments()[0];
        AssertionsForClassTypes.assertThat((Object)innerFuture.getRawType()).isEqualTo(CompletableFuture.class);
        AssertionsForClassTypes.assertThat((Object)innerFuture.getActualTypeArguments()[0]).isEqualTo(Long.class);
        AssertionsForClassTypes.assertThat((Object)arrayType).isInstanceOf(GenericArrayType.class);
        AssertionsForClassTypes.assertThat((Object)((GenericArrayType)arrayType).getGenericComponentType()).isEqualTo(Long.class);
    }

    @Test
    void testResolveParametersDeeper() {
        List methods = ExtractionUtils.collectMethods(FutureClass.class, (String)"method");
        Method method = (Method)methods.get(0);
        Type futureType = ExtractionUtils.resolveVariableWithClassContext(FutureClass.class, (Type)method.getGenericParameterTypes()[0]);
        Type listOfFutures = ExtractionUtils.resolveVariableWithClassContext(FutureClass.class, (Type)method.getGenericParameterTypes()[1]);
        AssertionsForClassTypes.assertThat((Object)futureType).isInstanceOf(ParameterizedType.class);
        AssertionsForClassTypes.assertThat((Object)((ParameterizedType)futureType).getRawType()).isEqualTo(CompletableFuture.class);
        AssertionsForClassTypes.assertThat((Object)((ParameterizedType)futureType).getActualTypeArguments()[0]).isEqualTo(Long.class);
        AssertionsForClassTypes.assertThat((Object)listOfFutures).isInstanceOf(ParameterizedType.class);
        AssertionsForClassTypes.assertThat((Object)((ParameterizedType)listOfFutures).getRawType()).isEqualTo(List.class);
        AssertionsForClassTypes.assertThat((Object)((ParameterizedType)listOfFutures).getActualTypeArguments()[0]).isInstanceOf(ParameterizedType.class);
        ParameterizedType innerFuture = (ParameterizedType)((ParameterizedType)listOfFutures).getActualTypeArguments()[0];
        AssertionsForClassTypes.assertThat((Object)innerFuture.getRawType()).isEqualTo(CompletableFuture.class);
        AssertionsForClassTypes.assertThat((Object)innerFuture.getActualTypeArguments()[0]).isEqualTo(Long.class);
    }

    @Test
    void testExtractExecutableNamesWithMultiLocalVariableBlocks() {
        ImmutableList expectedParameterNames = ImmutableList.of((Object)"generic", (Object)"genericFuture", (Object)"listOfGenericFuture", (Object)"array");
        List methods = ExtractionUtils.collectMethods(MultiLocalVariableWithoutInitializationClass.class, (String)"method");
        Method method = (Method)methods.get(0);
        List parameterNames = ExtractionUtils.extractExecutableNames((Executable)method);
        AssertionsForClassTypes.assertThat((Object)parameterNames).isEqualTo((Object)expectedParameterNames);
        methods = ExtractionUtils.collectMethods(MultiLocalVariableBlocksWithInitializationClass.class, (String)"method");
        method = (Method)methods.get(0);
        parameterNames = ExtractionUtils.extractExecutableNames((Executable)method);
        AssertionsForClassTypes.assertThat((Object)parameterNames).isEqualTo((Object)expectedParameterNames);
    }

    @Test
    void testExtractExecutableNamesWithParameterNameShadowed() {
        ImmutableList expectedParameterNames = ImmutableList.of((Object)"generic", (Object)"result", (Object)"genericFuture", (Object)"listOfGenericFuture", (Object)"array");
        List methods = ExtractionUtils.collectMethods(ParameterNameShadowedClass.class, (String)"method");
        Method method = (Method)methods.get(0);
        List parameterNames = ExtractionUtils.extractExecutableNames((Executable)method);
        AssertionsForClassTypes.assertThat((Object)parameterNames).isEqualTo((Object)expectedParameterNames);
    }

    public static class ParameterNameShadowedClass {
        public void method(Long generic, Object result, CompletableFuture<Long> genericFuture, List<CompletableFuture<Long>> listOfGenericFuture, Long[] array) {
        }
    }

    public static class MultiLocalVariableBlocksWithInitializationClass
    extends ClassBase<Long> {
        public void method(Long generic, CompletableFuture<Long> genericFuture, List<CompletableFuture<Long>> listOfGenericFuture, Long[] array) {
            String localVariable = "";
            localVariable = generic == null ? "null" : (generic < 0L ? "negative" : (generic > 0L ? "positive" : "zero"));
            System.err.println("localVariable: " + localVariable);
        }
    }

    public static class MultiLocalVariableWithoutInitializationClass
    extends ClassBase<Long> {
        public void method(Long generic, CompletableFuture<Long> genericFuture, List<CompletableFuture<Long>> listOfGenericFuture, Long[] array) {
            String localVariable = generic == null ? "null" : (generic < 0L ? "negative" : (generic > 0L ? "positive" : "zero"));
            System.err.println("localVariable: " + localVariable);
        }
    }

    public static class FutureClass
    extends ClassBase2<CompletableFuture<Long>> {
    }

    public static class ClassBase2<T> {
        public void method(T generic, List<T> list) {
        }
    }

    public static class LongClass
    extends ClassBase<Long> {
    }

    public static class ClassBase<T> {
        public void method(T generic, CompletableFuture<T> genericFuture, List<CompletableFuture<T>> listOfGenericFuture, T[] array) {
        }
    }
}

