/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.factories.workflow;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.factories.WorkflowSchedulerFactory;
import org.apache.flink.table.factories.WorkflowSchedulerFactoryUtil;
import org.apache.flink.table.factories.workflow.TestWorkflowSchedulerFactory;
import org.apache.flink.table.workflow.WorkflowScheduler;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;

public class WorkflowSchedulerFactoryUtilTest {
    @Test
    void testCreateWorkflowScheduler() {
        Map<String, String> options = this.getDefaultConfig();
        WorkflowScheduler actual = WorkflowSchedulerFactoryUtil.createWorkflowScheduler((Configuration)Configuration.fromMap(options), (ClassLoader)Thread.currentThread().getContextClassLoader());
        TestWorkflowSchedulerFactory.TestWorkflowScheduler expected = new TestWorkflowSchedulerFactory.TestWorkflowScheduler("user1", "9999", "project1");
        Assertions.assertThat((Object)actual).isEqualTo((Object)expected);
    }

    @Test
    void testCreateWorkflowSchedulerWithoutType() {
        WorkflowScheduler actual = WorkflowSchedulerFactoryUtil.createWorkflowScheduler((Configuration)new Configuration(), (ClassLoader)Thread.currentThread().getContextClassLoader());
        Assertions.assertThat((Object)actual).isNull();
    }

    @Test
    void testCreateWorkflowSchedulerWithUnknownType() {
        Map<String, String> options = this.getDefaultConfig();
        options.put("workflow-scheduler.type", "unknown");
        this.validateException(options, String.format("Could not find any factory for identifier 'unknown' that implements '%s' in the classpath.", WorkflowSchedulerFactory.class.getCanonicalName()));
    }

    @Test
    void testCreateWorkflowSchedulerWithMissingOptions() {
        Map<String, String> options = this.getDefaultConfig();
        options.remove("workflow-scheduler.test.user-name");
        this.validateException(options, "One or more required options are missing.\n\nMissing required options are:\n\nuser-name");
    }

    private void validateException(Map<String, String> options, String errorMessage) {
        Assertions.assertThatThrownBy(() -> WorkflowSchedulerFactoryUtil.createWorkflowScheduler((Configuration)Configuration.fromMap((Map)options), (ClassLoader)Thread.currentThread().getContextClassLoader())).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(ValidationException.class, (String)errorMessage)});
    }

    private Map<String, String> getDefaultConfig() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("workflow-scheduler.type", "test");
        config.put("workflow-scheduler.test.user-name", "user1");
        config.put("workflow-scheduler.test.password", "9999");
        config.put("workflow-scheduler.test.project-name", "project1");
        return config;
    }
}

