/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.internal.TableResultImpl;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.ddl.CreateOperation;

@Internal
public class CreateTableOperation
implements CreateOperation {
    private final ObjectIdentifier tableIdentifier;
    private final ResolvedCatalogTable catalogTable;
    private final boolean ignoreIfExists;
    private final boolean isTemporary;

    public CreateTableOperation(ObjectIdentifier tableIdentifier, ResolvedCatalogTable catalogTable, boolean ignoreIfExists, boolean isTemporary) {
        this.tableIdentifier = tableIdentifier;
        this.catalogTable = catalogTable;
        this.ignoreIfExists = ignoreIfExists;
        this.isTemporary = isTemporary;
    }

    public ResolvedCatalogTable getCatalogTable() {
        return this.catalogTable;
    }

    public ObjectIdentifier getTableIdentifier() {
        return this.tableIdentifier;
    }

    public boolean isIgnoreIfExists() {
        return this.ignoreIfExists;
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("catalogTable", this.catalogTable.toProperties());
        params.put("identifier", this.tableIdentifier);
        params.put("ignoreIfExists", this.ignoreIfExists);
        params.put("isTemporary", this.isTemporary);
        return OperationUtils.formatWithChildren("CREATE TABLE", params, Collections.emptyList(), Operation::asSummaryString);
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        if (this.isTemporary) {
            ctx.getCatalogManager().createTemporaryTable((CatalogBaseTable)this.catalogTable, this.tableIdentifier, this.ignoreIfExists);
        } else {
            ctx.getCatalogManager().createTable((CatalogBaseTable)this.catalogTable, this.tableIdentifier, this.ignoreIfExists);
        }
        return TableResultImpl.TABLE_RESULT_OK;
    }
}

