/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptivebatch;

import java.util.function.Function;

public class BisectionSearchUtils {
    public static long findMinLegalValue(Function<Long, Boolean> legalChecker, long low, long high) {
        if (!legalChecker.apply(high).booleanValue()) {
            return -1L;
        }
        while (low <= high) {
            long mid = (low + high) / 2L;
            if (legalChecker.apply(mid).booleanValue()) {
                high = mid - 1L;
                continue;
            }
            low = mid + 1L;
        }
        return high + 1L;
    }

    public static long findMaxLegalValue(Function<Long, Boolean> legalChecker, long low, long high) {
        if (!legalChecker.apply(low).booleanValue()) {
            return -1L;
        }
        while (low <= high) {
            long mid = (low + high) / 2L;
            if (legalChecker.apply(mid).booleanValue()) {
                low = mid + 1L;
                continue;
            }
            high = mid - 1L;
        }
        return low - 1L;
    }
}

