/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators;

import java.time.Duration;
import java.util.ArrayList;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.mocks.MockSource;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.runtime.operators.testutils.MockEnvironmentBuilder;
import org.apache.flink.runtime.util.TestingTaskManagerRuntimeInfo;
import org.apache.flink.streaming.api.operators.SourceOperatorFactory;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.util.SourceOperatorTestHarness;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class SourceOperatorLatencyMetricsTest {
    private static final long MAX_PROCESSING_TIME = 100L;
    private static final long LATENCY_MARK_INTERVAL = 10L;

    SourceOperatorLatencyMetricsTest() {
    }

    @Test
    void testLatencyMarkEmissionDisabled() throws Exception {
        this.testLatencyMarkEmission(false, new Configuration(), new ExecutionConfig());
    }

    @Test
    void testLatencyMarkEmissionEnabledViaExecutionConfig() throws Exception {
        Configuration taskConfiguration = new Configuration();
        ExecutionConfig executionConfig = new ExecutionConfig();
        executionConfig.setLatencyTrackingInterval(10L);
        this.testLatencyMarkEmission(true, taskConfiguration, executionConfig);
    }

    @Test
    void testLatencyMarkEmissionEnabledViaFlinkConfig() throws Exception {
        Configuration taskConfiguration = new Configuration();
        taskConfiguration.set(MetricOptions.LATENCY_INTERVAL, (Object)Duration.ofMillis(10L));
        ExecutionConfig executionConfig = new ExecutionConfig();
        this.testLatencyMarkEmission(true, taskConfiguration, executionConfig);
    }

    @Test
    void testLatencyMarkEmissionEnabledOverrideViaExecutionConfig() throws Exception {
        Configuration taskConfiguration = new Configuration();
        taskConfiguration.set(MetricOptions.LATENCY_INTERVAL, (Object)Duration.ofMillis(0L));
        ExecutionConfig executionConfig = new ExecutionConfig();
        executionConfig.setLatencyTrackingInterval(10L);
        this.testLatencyMarkEmission(true, taskConfiguration, executionConfig);
    }

    @Test
    void testLatencyMarkEmissionDisabledOverrideViaExecutionConfig() throws Exception {
        Configuration taskConfiguration = new Configuration();
        taskConfiguration.set(MetricOptions.LATENCY_INTERVAL, (Object)Duration.ofMillis(10L));
        ExecutionConfig executionConfig = new ExecutionConfig();
        executionConfig.setLatencyTrackingInterval(0L);
        this.testLatencyMarkEmission(false, taskConfiguration, executionConfig);
    }

    private void testLatencyMarkEmission(boolean shouldExpectLatencyMarkers, Configuration taskManagerConfig, ExecutionConfig executionConfig) throws Exception {
        try (SourceOperatorTestHarness testHarness = new SourceOperatorTestHarness(new SourceOperatorFactory((Source)new MockSource(Boundedness.CONTINUOUS_UNBOUNDED, 1), WatermarkStrategy.noWatermarks()), new MockEnvironmentBuilder().setTaskManagerRuntimeInfo(new TestingTaskManagerRuntimeInfo(taskManagerConfig)).setExecutionConfig(executionConfig).build());){
            testHarness.open();
            testHarness.setup();
            for (long processingTime = 0L; processingTime <= 100L; ++processingTime) {
                testHarness.getProcessingTimeService().setCurrentTime(processingTime);
                testHarness.emitNext();
            }
            ArrayList<LatencyMarker> expectedOutput = new ArrayList<LatencyMarker>();
            if (!shouldExpectLatencyMarkers) {
                Assertions.assertThat(testHarness.getOutput()).isEmpty();
            } else {
                expectedOutput.add(new LatencyMarker(1L, testHarness.getOperator().getOperatorID(), 0));
                for (long markedTime = 10L; markedTime <= 100L; markedTime += 10L) {
                    expectedOutput.add(new LatencyMarker(markedTime, testHarness.getOperator().getOperatorID(), 0));
                }
                Assertions.assertThat(testHarness.getOutput()).containsExactlyElementsOf(expectedOutput);
            }
        }
    }
}

