/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import java.time.Duration;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobGraphTestUtils;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.runtime.testtasks.NoOpInvokable;
import org.apache.flink.runtime.testutils.InternalMiniClusterExtension;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.runtime.util.JobVertexConnectionUtils;
import org.apache.flink.streaming.api.graph.ExecutionPlan;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class AdaptiveSchedulerSlotSharingITCase {
    private static final int NUMBER_TASK_MANAGERS = 1;
    private static final int NUMBER_SLOTS_PER_TASK_MANAGER = 1;
    private static final int PARALLELISM = 1;
    @RegisterExtension
    private static final InternalMiniClusterExtension INTERNAL_MINI_CLUSTER_EXTENSION = new InternalMiniClusterExtension(new MiniClusterResourceConfiguration.Builder().setConfiguration(AdaptiveSchedulerSlotSharingITCase.getConfiguration()).setNumberTaskManagers(1).setNumberSlotsPerTaskManager(1).build());

    AdaptiveSchedulerSlotSharingITCase() {
    }

    private static Configuration getConfiguration() {
        Configuration configuration = new Configuration();
        configuration.set(JobManagerOptions.SCHEDULER, (Object)JobManagerOptions.SchedulerType.Adaptive);
        configuration.set(TaskManagerOptions.SLOT_TIMEOUT, (Object)Duration.ofSeconds(5L));
        return configuration;
    }

    @Test
    void testSchedulingOfJobRequiringSlotSharing() throws Exception {
        this.runJob();
        this.runJob();
    }

    private void runJob() throws Exception {
        MiniCluster miniCluster = INTERNAL_MINI_CLUSTER_EXTENSION.getMiniCluster();
        JobGraph jobGraph = AdaptiveSchedulerSlotSharingITCase.createJobGraphWithSlotSharingGroup();
        miniCluster.submitJob((ExecutionPlan)jobGraph).join();
        JobResult jobResult = (JobResult)miniCluster.requestJobResult(jobGraph.getJobID()).join();
        jobResult.toJobExecutionResult(this.getClass().getClassLoader());
        Assertions.assertThat((boolean)jobResult.isSuccess()).isTrue();
    }

    private static JobGraph createJobGraphWithSlotSharingGroup() {
        SlotSharingGroup slotSharingGroup = new SlotSharingGroup();
        JobVertex source = new JobVertex("Source");
        source.setInvokableClass(NoOpInvokable.class);
        source.setParallelism(1);
        source.setSlotSharingGroup(slotSharingGroup);
        JobVertex sink = new JobVertex("sink");
        sink.setInvokableClass(NoOpInvokable.class);
        sink.setParallelism(1);
        sink.setSlotSharingGroup(slotSharingGroup);
        JobVertexConnectionUtils.connectNewDataSetAsInput(sink, source, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
        return JobGraphTestUtils.streamingJobGraph(source, sink);
    }
}

