/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.resourcemanager.slotmanager.DefaultResourceTracker;
import org.apache.flink.runtime.slots.ResourceRequirement;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.junit.jupiter.api.Test;

class DefaultResourceTrackerTest {
    private static final JobID JOB_ID_1 = JobID.generate();
    private static final JobID JOB_ID_2 = JobID.generate();

    DefaultResourceTrackerTest() {
    }

    @Test
    void testInitialBehavior() {
        DefaultResourceTracker tracker = new DefaultResourceTracker();
        Assertions.assertThat((boolean)tracker.isEmpty()).isTrue();
        tracker.notifyLostResource(JobID.generate(), ResourceProfile.ANY);
    }

    @Test
    void testClearDoesNotThrowException() {
        DefaultResourceTracker tracker = new DefaultResourceTracker();
        tracker.clear();
    }

    @Test
    void testGetRequiredResources() {
        DefaultResourceTracker tracker = new DefaultResourceTracker();
        ResourceRequirement requirement1 = ResourceRequirement.create((ResourceProfile)ResourceProfile.ANY, (int)1);
        ResourceRequirement requirement2 = ResourceRequirement.create((ResourceProfile)ResourceProfile.ANY, (int)2);
        tracker.notifyResourceRequirements(JOB_ID_1, Collections.singletonList(requirement1));
        tracker.notifyResourceRequirements(JOB_ID_2, Collections.singletonList(requirement2));
        Map requiredResources = tracker.getMissingResources();
        DefaultResourceTrackerTest.assertMapKeyedEntriesContainsValue(requiredResources, JOB_ID_1, requirement1);
        DefaultResourceTrackerTest.assertMapKeyedEntriesContainsValue(requiredResources, JOB_ID_2, requirement2);
    }

    private static <K, VE> void assertMapKeyedEntriesContainsValue(Map<K, Collection<VE>> requiredResources, final K jobID, final VE resourceRequirementToContain) {
        Assertions.assertThat(requiredResources).hasEntrySatisfying(new Condition<K>(){

            public boolean matches(K key) {
                return jobID.equals(key);
            }
        }, new Condition<Collection<VE>>(){

            public boolean matches(Collection<VE> value) {
                if (value == null || value.isEmpty()) {
                    return false;
                }
                return value.contains(resourceRequirementToContain);
            }
        });
    }

    @Test
    void testGetAcquiredResources() {
        DefaultResourceTracker tracker = new DefaultResourceTracker();
        ResourceRequirement requirement1 = ResourceRequirement.create((ResourceProfile)ResourceProfile.ANY, (int)1);
        ResourceRequirement requirement2 = ResourceRequirement.create((ResourceProfile)ResourceProfile.ANY, (int)2);
        tracker.notifyAcquiredResource(JOB_ID_1, requirement1.getResourceProfile());
        for (int x = 0; x < requirement2.getNumberOfRequiredSlots(); ++x) {
            tracker.notifyAcquiredResource(JOB_ID_2, requirement2.getResourceProfile());
        }
        Assertions.assertThat((Collection)tracker.getAcquiredResources(JOB_ID_1)).contains((Object[])new ResourceRequirement[]{requirement1});
        Assertions.assertThat((Collection)tracker.getAcquiredResources(JOB_ID_2)).contains((Object[])new ResourceRequirement[]{requirement2});
        tracker.notifyLostResource(JOB_ID_1, requirement1.getResourceProfile());
        Assertions.assertThat((Collection)tracker.getAcquiredResources(JOB_ID_1)).isEmpty();
    }

    @Test
    void testTrackerRemovedOnRequirementReset() {
        DefaultResourceTracker tracker = new DefaultResourceTracker();
        tracker.notifyResourceRequirements(JOB_ID_1, Collections.singletonList(ResourceRequirement.create((ResourceProfile)ResourceProfile.ANY, (int)1)));
        Assertions.assertThat((boolean)tracker.isEmpty()).isFalse();
        tracker.notifyResourceRequirements(JOB_ID_1, Collections.emptyList());
        Assertions.assertThat((boolean)tracker.isEmpty()).isTrue();
    }

    @Test
    void testTrackerRemovedOnResourceLoss() {
        DefaultResourceTracker tracker = new DefaultResourceTracker();
        tracker.notifyAcquiredResource(JOB_ID_1, ResourceProfile.ANY);
        Assertions.assertThat((boolean)tracker.isEmpty()).isFalse();
        tracker.notifyLostResource(JOB_ID_1, ResourceProfile.ANY);
        Assertions.assertThat((boolean)tracker.isEmpty()).isTrue();
    }

    @Test
    void testTrackerRetainedOnResourceLossIfRequirementExists() {
        DefaultResourceTracker tracker = new DefaultResourceTracker();
        tracker.notifyAcquiredResource(JOB_ID_1, ResourceProfile.ANY);
        tracker.notifyResourceRequirements(JOB_ID_1, Collections.singletonList(ResourceRequirement.create((ResourceProfile)ResourceProfile.ANY, (int)1)));
        tracker.notifyLostResource(JOB_ID_1, ResourceProfile.ANY);
        Assertions.assertThat((boolean)tracker.isEmpty()).isFalse();
        tracker.notifyResourceRequirements(JOB_ID_1, Collections.emptyList());
        Assertions.assertThat((boolean)tracker.isEmpty()).isTrue();
    }

    @Test
    void testTrackerRetainedOnRequirementResetIfResourceExists() {
        DefaultResourceTracker tracker = new DefaultResourceTracker();
        tracker.notifyAcquiredResource(JOB_ID_1, ResourceProfile.ANY);
        tracker.notifyResourceRequirements(JOB_ID_1, Collections.singletonList(ResourceRequirement.create((ResourceProfile)ResourceProfile.ANY, (int)1)));
        tracker.notifyResourceRequirements(JOB_ID_1, Collections.emptyList());
        Assertions.assertThat((boolean)tracker.isEmpty()).isFalse();
        tracker.notifyLostResource(JOB_ID_1, ResourceProfile.ANY);
        Assertions.assertThat((boolean)tracker.isEmpty()).isTrue();
    }
}

