/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nonnull;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.core.testutils.OneShotLatch;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.runtime.jobmaster.JobManagerSharedServices;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.util.Hardware;
import org.apache.flink.runtime.util.TestingFatalErrorHandler;
import org.apache.flink.util.function.ThrowingRunnable;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class JobManagerSharedServicesTest {
    private static final int CPU_CORES = Hardware.getNumberCPUCores();
    @TempDir
    private File TEMPORARY_FOLDER;

    JobManagerSharedServicesTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testFutureExecutorNoConfiguration() throws Exception {
        Configuration config = new Configuration();
        JobManagerSharedServices jobManagerSharedServices = this.buildJobManagerSharedServices(config);
        try {
            ScheduledExecutorService futureExecutor = jobManagerSharedServices.getFutureExecutor();
            this.assertExecutorPoolSize(futureExecutor, CPU_CORES);
        }
        finally {
            jobManagerSharedServices.shutdown();
        }
    }

    @Test
    void testFutureExecutorConfiguration() throws Exception {
        int futurePoolSize = 8;
        Configuration config = new Configuration();
        config.set(JobManagerOptions.JOB_MANAGER_FUTURE_POOL_SIZE, (Object)8);
        JobManagerSharedServices jobManagerSharedServices = this.buildJobManagerSharedServices(config);
        this.assertExecutorPoolSize(jobManagerSharedServices.getFutureExecutor(), 8);
        jobManagerSharedServices.shutdown();
    }

    @Test
    void testIoExecutorNoConfiguration() throws Exception {
        Configuration config = new Configuration();
        JobManagerSharedServices jobManagerSharedServices = this.buildJobManagerSharedServices(config);
        try {
            this.assertExecutorPoolSize(jobManagerSharedServices.getIoExecutor(), CPU_CORES);
        }
        finally {
            jobManagerSharedServices.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testIoExecutorConfiguration() throws Exception {
        int ioPoolSize = 5;
        Configuration config = new Configuration();
        config.set(JobManagerOptions.JOB_MANAGER_IO_POOL_SIZE, (Object)5);
        JobManagerSharedServices jobManagerSharedServices = this.buildJobManagerSharedServices(config);
        try {
            this.assertExecutorPoolSize(jobManagerSharedServices.getIoExecutor(), 5);
        }
        finally {
            jobManagerSharedServices.shutdown();
        }
    }

    @Nonnull
    private JobManagerSharedServices buildJobManagerSharedServices(Configuration configuration) throws Exception {
        return JobManagerSharedServices.fromConfiguration((Configuration)configuration, (BlobServer)new BlobServer(configuration, this.TEMPORARY_FOLDER, (BlobStore)new VoidBlobStore()), (FatalErrorHandler)new TestingFatalErrorHandler());
    }

    private void assertExecutorPoolSize(Executor executor, int expectedPoolSize) throws InterruptedException {
        CountDownLatch expectedPoolSizeLatch = new CountDownLatch(expectedPoolSize);
        int expectedPoolSizePlusOne = expectedPoolSize + 1;
        CountDownLatch expectedPoolSizePlusOneLatch = new CountDownLatch(expectedPoolSizePlusOne);
        OneShotLatch releaseLatch = new OneShotLatch();
        ThrowingRunnable countsDown = () -> {
            expectedPoolSizePlusOneLatch.countDown();
            expectedPoolSizeLatch.countDown();
            releaseLatch.await();
        };
        for (int i = 0; i < expectedPoolSizePlusOne; ++i) {
            executor.execute(ThrowingRunnable.unchecked((ThrowingRunnable)countsDown));
        }
        expectedPoolSizeLatch.await();
        Assertions.assertThat((long)expectedPoolSizePlusOneLatch.getCount()).isOne();
        releaseLatch.trigger();
    }
}

