/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.remote;

import java.io.File;
import java.io.IOException;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageIdMappingUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStoragePartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.SegmentPartitionFile;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageResourceRegistry;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierShuffleDescriptor;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.remote.RemoteTierMasterAgent;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class RemoteTierMasterAgentTest {
    @TempDir
    private File tempFolder;

    RemoteTierMasterAgentTest() {
    }

    @Test
    void testAddAndReleasePartition() throws IOException {
        ResultPartitionID resultPartitionID = new ResultPartitionID();
        TieredStoragePartitionId partitionId = TieredStorageIdMappingUtils.convertId((ResultPartitionID)resultPartitionID);
        File partitionFile = new File(SegmentPartitionFile.getPartitionPath((TieredStoragePartitionId)partitionId, (String)this.tempFolder.getAbsolutePath()));
        Assertions.assertThat((boolean)partitionFile.createNewFile()).isTrue();
        Assertions.assertThat((boolean)partitionFile.exists()).isTrue();
        TieredStorageResourceRegistry resourceRegistry = new TieredStorageResourceRegistry();
        RemoteTierMasterAgent masterAgent = new RemoteTierMasterAgent(this.tempFolder.getAbsolutePath(), resourceRegistry);
        TierShuffleDescriptor tierShuffleDescriptor = masterAgent.addPartitionAndGetShuffleDescriptor(new JobID(), 1, resultPartitionID);
        Assertions.assertThat((boolean)partitionFile.exists()).isTrue();
        masterAgent.releasePartition(tierShuffleDescriptor);
        Assertions.assertThat((boolean)partitionFile.exists()).isFalse();
    }
}

