/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGateBuilder;
import org.apache.flink.runtime.io.network.partition.consumer.TestInputChannel;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty.NettyConnectionReader;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty.NettyConnectionReaderImpl;
import org.apache.flink.util.ExceptionUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class NettyConnectionReaderTest {
    private static final int INPUT_CHANNEL_INDEX = 0;
    private CompletableFuture<Integer> requiredSegmentIdFuture;

    NettyConnectionReaderTest() {
    }

    @BeforeEach
    void before() {
        this.requiredSegmentIdFuture = new CompletableFuture();
    }

    @Test
    void testReadBuffer() {
        int bufferNumber = 1;
        Supplier<InputChannel> inputChannelSupplier = NettyConnectionReaderTest.createInputChannelSupplier(bufferNumber, this.requiredSegmentIdFuture);
        NettyConnectionReader reader = NettyConnectionReaderTest.createNettyConnectionReader(inputChannelSupplier);
        Optional buffer = reader.readBuffer(0, 0);
        Assertions.assertThat((Optional)buffer).isPresent();
        Assertions.assertThat((boolean)((Buffer)buffer.get()).isBuffer()).isTrue();
        Assertions.assertThat(this.requiredSegmentIdFuture).isNotDone();
    }

    @Test
    void testReadEmptyBuffer() {
        int bufferNumber = 0;
        Supplier<InputChannel> inputChannelSupplier = NettyConnectionReaderTest.createInputChannelSupplier(bufferNumber, this.requiredSegmentIdFuture);
        NettyConnectionReader reader = NettyConnectionReaderTest.createNettyConnectionReader(inputChannelSupplier);
        Optional buffer = reader.readBuffer(0, 0);
        Assertions.assertThat((Optional)buffer).isNotPresent();
        Assertions.assertThat(this.requiredSegmentIdFuture).isNotDone();
    }

    @Test
    void testReadDifferentSegments() throws ExecutionException, InterruptedException {
        int bufferNumber = 0;
        Supplier<InputChannel> inputChannelSupplier = NettyConnectionReaderTest.createInputChannelSupplier(bufferNumber, this.requiredSegmentIdFuture);
        NettyConnectionReader reader = NettyConnectionReaderTest.createNettyConnectionReader(inputChannelSupplier);
        reader.readBuffer(0, 0);
        Assertions.assertThat(this.requiredSegmentIdFuture).isNotDone();
        reader.readBuffer(0, 1);
        Assertions.assertThat((Integer)this.requiredSegmentIdFuture.get()).isEqualTo(1);
    }

    @Test
    void testPeekNextBufferSubpartitionId() throws IOException {
        int bufferNumber = 0;
        Supplier<InputChannel> inputChannelSupplier = NettyConnectionReaderTest.createInputChannelSupplier(bufferNumber, this.requiredSegmentIdFuture);
        NettyConnectionReader reader = NettyConnectionReaderTest.createNettyConnectionReader(inputChannelSupplier);
        Assertions.assertThat((int)reader.peekNextBufferSubpartitionId()).isZero();
    }

    private static Supplier<InputChannel> createInputChannelSupplier(int bufferNumber, CompletableFuture<Integer> requiredSegmentIdFuture) {
        TestInputChannel inputChannel = new TestInputChannel(new SingleInputGateBuilder().build(), 0, requiredSegmentIdFuture);
        try {
            for (int index = 0; index < bufferNumber; ++index) {
                inputChannel.read((Buffer)new NetworkBuffer(MemorySegmentFactory.allocateUnpooledSegment((int)0), FreeingBufferRecycler.INSTANCE, Buffer.DataType.DATA_BUFFER), index == bufferNumber - 1 ? Buffer.DataType.NONE : Buffer.DataType.DATA_BUFFER);
            }
        }
        catch (IOException | InterruptedException e) {
            ExceptionUtils.rethrow((Throwable)e, (String)"Failed to create test input channel.");
        }
        return () -> inputChannel;
    }

    private static NettyConnectionReader createNettyConnectionReader(Supplier<InputChannel> inputChannelSupplier) {
        return new NettyConnectionReaderImpl(inputChannelSupplier);
    }
}

