/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.StandaloneCheckpointRecoveryFactory;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.JobResultStore;
import org.apache.flink.runtime.highavailability.TestingHighAvailabilityServices;
import org.apache.flink.runtime.highavailability.nonha.embedded.EmbeddedJobResultStore;
import org.apache.flink.runtime.jobmanager.ExecutionPlanStore;
import org.apache.flink.runtime.jobmanager.StandaloneExecutionPlanStore;
import org.apache.flink.runtime.leaderelection.LeaderElection;
import org.apache.flink.runtime.leaderelection.StandaloneLeaderElection;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.leaderretrieval.StandaloneLeaderRetrievalService;

public class TestingHighAvailabilityServicesBuilder {
    private LeaderRetrievalService resourceManagerLeaderRetriever = new StandaloneLeaderRetrievalService("localhost", HighAvailabilityServices.DEFAULT_LEADER_ID);
    private LeaderRetrievalService dispatcherLeaderRetriever = new StandaloneLeaderRetrievalService("localhost", HighAvailabilityServices.DEFAULT_LEADER_ID);
    private LeaderRetrievalService webMonitorEndpointLeaderRetriever = new StandaloneLeaderRetrievalService("localhost", HighAvailabilityServices.DEFAULT_LEADER_ID);
    private Function<JobID, LeaderRetrievalService> jobMasterLeaderRetrieverFunction = jobId -> new StandaloneLeaderRetrievalService("localhost", HighAvailabilityServices.DEFAULT_LEADER_ID);
    private Function<JobID, LeaderElection> jobMasterLeaderElectionFunction = jobId -> new StandaloneLeaderElection(UUID.randomUUID());
    private LeaderElection resourceManagerLeaderElection = new StandaloneLeaderElection(UUID.randomUUID());
    private LeaderElection dispatcherLeaderElection = new StandaloneLeaderElection(UUID.randomUUID());
    private LeaderElection webMonitorEndpointLeaderElection = new StandaloneLeaderElection(UUID.randomUUID());
    private CheckpointRecoveryFactory checkpointRecoveryFactory = new StandaloneCheckpointRecoveryFactory();
    private ExecutionPlanStore executionPlanStore = new StandaloneExecutionPlanStore();
    private JobResultStore jobResultStore = new EmbeddedJobResultStore();
    private CompletableFuture<Void> closeFuture = new CompletableFuture();
    private CompletableFuture<Void> cleanupAllDataFuture = new CompletableFuture();

    public TestingHighAvailabilityServices build() {
        TestingHighAvailabilityServices testingHighAvailabilityServices = new TestingHighAvailabilityServices();
        testingHighAvailabilityServices.setResourceManagerLeaderRetriever(this.resourceManagerLeaderRetriever);
        testingHighAvailabilityServices.setDispatcherLeaderRetriever(this.dispatcherLeaderRetriever);
        testingHighAvailabilityServices.setClusterRestEndpointLeaderRetriever(this.webMonitorEndpointLeaderRetriever);
        testingHighAvailabilityServices.setJobMasterLeaderRetrieverFunction(this.jobMasterLeaderRetrieverFunction);
        testingHighAvailabilityServices.setJobMasterLeaderElectionFunction(this.jobMasterLeaderElectionFunction);
        testingHighAvailabilityServices.setResourceManagerLeaderElection(this.resourceManagerLeaderElection);
        testingHighAvailabilityServices.setDispatcherLeaderElection(this.dispatcherLeaderElection);
        testingHighAvailabilityServices.setClusterRestEndpointLeaderElection(this.webMonitorEndpointLeaderElection);
        testingHighAvailabilityServices.setCheckpointRecoveryFactory(this.checkpointRecoveryFactory);
        testingHighAvailabilityServices.setExecutionPlanStore(this.executionPlanStore);
        testingHighAvailabilityServices.setJobResultStore(this.jobResultStore);
        testingHighAvailabilityServices.setCloseFuture(this.closeFuture);
        testingHighAvailabilityServices.setCleanupAllDataFuture(this.cleanupAllDataFuture);
        return testingHighAvailabilityServices;
    }

    public TestingHighAvailabilityServicesBuilder setResourceManagerLeaderRetriever(LeaderRetrievalService resourceManagerLeaderRetriever) {
        this.resourceManagerLeaderRetriever = resourceManagerLeaderRetriever;
        return this;
    }

    public TestingHighAvailabilityServicesBuilder setDispatcherLeaderRetriever(LeaderRetrievalService dispatcherLeaderRetriever) {
        this.dispatcherLeaderRetriever = dispatcherLeaderRetriever;
        return this;
    }

    public TestingHighAvailabilityServicesBuilder setWebMonitorEndpointLeaderRetriever(LeaderRetrievalService webMonitorEndpointLeaderRetriever) {
        this.webMonitorEndpointLeaderRetriever = webMonitorEndpointLeaderRetriever;
        return this;
    }

    public TestingHighAvailabilityServicesBuilder setJobMasterLeaderRetrieverFunction(Function<JobID, LeaderRetrievalService> jobMasterLeaderRetrieverFunction) {
        this.jobMasterLeaderRetrieverFunction = jobMasterLeaderRetrieverFunction;
        return this;
    }

    public TestingHighAvailabilityServicesBuilder setJobMasterLeaderElectionFunction(Function<JobID, LeaderElection> jobMasterLeaderElectionFunction) {
        this.jobMasterLeaderElectionFunction = jobMasterLeaderElectionFunction;
        return this;
    }

    public TestingHighAvailabilityServicesBuilder setResourceManagerLeaderElection(LeaderElection resourceManagerLeaderElection) {
        this.resourceManagerLeaderElection = resourceManagerLeaderElection;
        return this;
    }

    public TestingHighAvailabilityServicesBuilder setDispatcherLeaderElection(LeaderElection dispatcherLeaderElection) {
        this.dispatcherLeaderElection = dispatcherLeaderElection;
        return this;
    }

    public TestingHighAvailabilityServicesBuilder setWebMonitorEndpointLeaderElection(LeaderElection webMonitorEndpointLeaderElection) {
        this.webMonitorEndpointLeaderElection = webMonitorEndpointLeaderElection;
        return this;
    }

    public TestingHighAvailabilityServicesBuilder setCheckpointRecoveryFactory(CheckpointRecoveryFactory checkpointRecoveryFactory) {
        this.checkpointRecoveryFactory = checkpointRecoveryFactory;
        return this;
    }

    public TestingHighAvailabilityServicesBuilder setExecutionPlanStore(ExecutionPlanStore executionPlanStore) {
        this.executionPlanStore = executionPlanStore;
        return this;
    }

    public TestingHighAvailabilityServicesBuilder setJobResultStore(JobResultStore jobResultStore) {
        this.jobResultStore = jobResultStore;
        return this;
    }

    public TestingHighAvailabilityServicesBuilder setCloseFuture(CompletableFuture<Void> closeFuture) {
        this.closeFuture = closeFuture;
        return this;
    }

    public TestingHighAvailabilityServicesBuilder setCleanupAllDataFuture(CompletableFuture<Void> cleanupAllDataFuture) {
        this.cleanupAllDataFuture = cleanupAllDataFuture;
        return this;
    }
}

