/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework;

import java.io.File;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.runtime.clusterframework.BootstrapTools;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.apache.flink.util.OperatingSystem;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class BootstrapToolsTest {
    @TempDir
    private static Path temporaryFolder;

    BootstrapToolsTest() {
    }

    @Test
    void testSubstituteConfigKey() {
        String deprecatedKey1 = "deprecated-key";
        String deprecatedKey2 = "another-out_of-date_key";
        String deprecatedKey3 = "yet-one-more";
        String designatedKey1 = "newkey1";
        String designatedKey2 = "newKey2";
        String designatedKey3 = "newKey3";
        String value1 = "value1";
        String value2Designated = "designated-value2";
        String value2Deprecated = "deprecated-value2";
        Configuration cfg = new Configuration();
        cfg.setString(deprecatedKey1, value1);
        cfg.setString(deprecatedKey2, value2Deprecated);
        cfg.setString(designatedKey2, value2Designated);
        BootstrapTools.substituteDeprecatedConfigKey((Configuration)cfg, (String)deprecatedKey1, (String)designatedKey1);
        BootstrapTools.substituteDeprecatedConfigKey((Configuration)cfg, (String)deprecatedKey2, (String)designatedKey2);
        BootstrapTools.substituteDeprecatedConfigKey((Configuration)cfg, (String)deprecatedKey3, (String)designatedKey3);
        Assertions.assertThat((String)cfg.getString(designatedKey1, null)).isEqualTo(value1);
        Assertions.assertThat((String)cfg.getString(designatedKey2, null)).isEqualTo(value2Designated);
        Assertions.assertThat((String)cfg.getString(designatedKey3, null)).isNull();
        Assertions.assertThat((String)cfg.getString(deprecatedKey3, null)).isNull();
    }

    @Test
    void testSubstituteConfigKeyPrefix() {
        String deprecatedPrefix1 = "deprecated-prefix";
        String deprecatedPrefix2 = "-prefix-2";
        String deprecatedPrefix3 = "prefix-3";
        String designatedPrefix1 = "p1";
        String designatedPrefix2 = "ppp";
        String designatedPrefix3 = "zzz";
        String depr1 = deprecatedPrefix1 + "var";
        String depr2 = deprecatedPrefix2 + "env";
        String depr3 = deprecatedPrefix2 + "x";
        String desig1 = designatedPrefix1 + "var";
        String desig2 = designatedPrefix2 + "env";
        String desig3 = designatedPrefix2 + "x";
        String val1 = "1";
        String val2 = "2";
        String val3Depr = "3-";
        String val3Desig = "3+";
        Configuration cfg = new Configuration();
        cfg.setString(depr1, val1);
        cfg.setString(depr2, val2);
        cfg.setString(depr3, val3Depr);
        cfg.setString(desig3, val3Desig);
        BootstrapTools.substituteDeprecatedConfigPrefix((Configuration)cfg, (String)deprecatedPrefix1, (String)designatedPrefix1);
        BootstrapTools.substituteDeprecatedConfigPrefix((Configuration)cfg, (String)deprecatedPrefix2, (String)designatedPrefix2);
        BootstrapTools.substituteDeprecatedConfigPrefix((Configuration)cfg, (String)deprecatedPrefix3, (String)designatedPrefix3);
        Assertions.assertThat((String)cfg.getString(desig1, null)).isEqualTo(val1);
        Assertions.assertThat((String)cfg.getString(desig2, null)).isEqualTo(val2);
        Assertions.assertThat((String)cfg.getString(desig3, null)).isEqualTo(val3Desig);
        for (String key : cfg.keySet()) {
            Assertions.assertThat((boolean)key.startsWith(designatedPrefix3)).isFalse();
            Assertions.assertThat((boolean)key.startsWith(deprecatedPrefix3)).isFalse();
        }
    }

    @Test
    void testUpdateTmpDirectoriesInConfiguration() {
        Configuration config = new Configuration();
        BootstrapTools.updateTmpDirectoriesInConfiguration((Configuration)config, (String)"default/directory/path");
        Assertions.assertThat((String)((String)config.get(CoreOptions.TMP_DIRS))).isEqualTo("default/directory/path");
        BootstrapTools.updateTmpDirectoriesInConfiguration((Configuration)config, (String)"not/default/directory/path");
        Assertions.assertThat((String)((String)config.get(CoreOptions.TMP_DIRS))).isEqualTo("default/directory/path");
        config.set(CoreOptions.TMP_DIRS, (Object)"");
        BootstrapTools.updateTmpDirectoriesInConfiguration((Configuration)config, (String)"some/new/path");
        Assertions.assertThat((String)((String)config.get(CoreOptions.TMP_DIRS))).isEmpty();
    }

    @Test
    void testShouldNotUpdateTmpDirectoriesInConfigurationIfNoValueConfigured() {
        Configuration config = new Configuration();
        BootstrapTools.updateTmpDirectoriesInConfiguration((Configuration)config, null);
        Assertions.assertThat((String)((String)CoreOptions.TMP_DIRS.defaultValue())).isEqualTo((String)config.get(CoreOptions.TMP_DIRS));
    }

    @Test
    void testGetDynamicPropertiesAsString() {
        Configuration baseConfig = new Configuration();
        baseConfig.setString("key.a", "a");
        baseConfig.setString("key.b", "b1");
        Configuration targetConfig = new Configuration();
        targetConfig.setString("key.b", "b2");
        targetConfig.setString("key.c", "c");
        String dynamicProperties = BootstrapTools.getDynamicPropertiesAsString((Configuration)baseConfig, (Configuration)targetConfig);
        if (OperatingSystem.isWindows()) {
            Assertions.assertThat((String)dynamicProperties).isEqualTo("-Dkey.b=\"b2\" -Dkey.c=\"c\"");
        } else {
            Assertions.assertThat((String)dynamicProperties).isEqualTo("-Dkey.b='b2' -Dkey.c='c'");
        }
    }

    @Test
    void testEscapeDynamicPropertyValueWithSingleQuote() {
        String value1 = "#a,b&c^d*e@f(g!h";
        Assertions.assertThat((String)BootstrapTools.escapeWithSingleQuote((String)"#a,b&c^d*e@f(g!h")).isEqualTo("'#a,b&c^d*e@f(g!h'");
        String value2 = "'foobar";
        Assertions.assertThat((String)BootstrapTools.escapeWithSingleQuote((String)"'foobar")).isEqualTo("''\\''foobar'");
        String value3 = "foo''bar";
        Assertions.assertThat((String)BootstrapTools.escapeWithSingleQuote((String)"foo''bar")).isEqualTo("'foo'\\'''\\''bar'");
        String value4 = "'foo' 'bar'";
        Assertions.assertThat((String)BootstrapTools.escapeWithSingleQuote((String)"'foo' 'bar'")).isEqualTo("''\\''foo'\\'' '\\''bar'\\'''");
    }

    @Test
    void testEscapeDynamicPropertyValueWithDoubleQuote() {
        String value1 = "#a,b&c^d*e@f(g!h";
        Assertions.assertThat((String)BootstrapTools.escapeWithDoubleQuote((String)"#a,b&c^d*e@f(g!h")).isEqualTo("\"#a,b&c\"^^\"d*e@f(g!h\"");
        String value2 = "foo\"bar'";
        Assertions.assertThat((String)BootstrapTools.escapeWithDoubleQuote((String)"foo\"bar'")).isEqualTo("\"foo\\\"bar'\"");
        String value3 = "\"foo\" \"bar\"";
        Assertions.assertThat((String)BootstrapTools.escapeWithDoubleQuote((String)"\"foo\" \"bar\"")).isEqualTo("\"\\\"foo\\\" \\\"bar\\\"\"");
    }

    @Test
    void testGetEnvironmentVariables() {
        Configuration testConf = new Configuration();
        testConf.setString("containerized.master.env.LD_LIBRARY_PATH", "/usr/lib/native");
        Map res = ConfigurationUtils.getPrefixedKeyValuePairs((String)"containerized.master.env.", (Configuration)testConf);
        ((MapAssert)Assertions.assertThat((Map)res).hasSize(1)).containsEntry((Object)"LD_LIBRARY_PATH", (Object)"/usr/lib/native");
    }

    @Test
    void testGetEnvironmentVariablesErroneous() {
        Configuration testConf = new Configuration();
        testConf.setString("containerized.master.env.", "/usr/lib/native");
        Map res = ConfigurationUtils.getPrefixedKeyValuePairs((String)"containerized.master.env.", (Configuration)testConf);
        Assertions.assertThat((Map)res).isEmpty();
    }

    @Test
    void testWriteConfigurationAndReloadWithStandardYaml() throws Exception {
        File flinkConfDir = TempDirUtils.newFolder((Path)temporaryFolder).getAbsoluteFile();
        Configuration flinkConfig = new Configuration();
        ConfigOption listStringConfigOption = ConfigOptions.key((String)"test-list-string-key").stringType().asList().noDefaultValue();
        List<String> list = Arrays.asList("A,B,C,D", "A'B'C'D", "A;BCD", "AB\"C\"D", "AB'\"D:B");
        flinkConfig.set(listStringConfigOption, list);
        Assertions.assertThat((List)((List)flinkConfig.get(listStringConfigOption))).containsExactlyInAnyOrderElementsOf(list);
        ConfigOption listDurationConfigOption = ConfigOptions.key((String)"test-list-duration-key").durationType().asList().noDefaultValue();
        List<Duration> durationList = Arrays.asList(Duration.ofSeconds(3L), Duration.ofMinutes(1L));
        flinkConfig.set(listDurationConfigOption, durationList);
        Assertions.assertThat((List)((List)flinkConfig.get(listDurationConfigOption))).containsExactlyInAnyOrderElementsOf(durationList);
        ConfigOption listMemoryConfigOption = ConfigOptions.key((String)"test-list-memory-key").memoryType().asList().noDefaultValue();
        List<MemorySize> memorySizeList = Arrays.asList(MemorySize.ofMebiBytes((long)10L), MemorySize.ofMebiBytes((long)20L), MemorySize.ZERO);
        flinkConfig.set(listMemoryConfigOption, memorySizeList);
        Assertions.assertThat((List)((List)flinkConfig.get(listMemoryConfigOption))).containsExactlyInAnyOrderElementsOf(memorySizeList);
        ConfigOption mapConfigOption = ConfigOptions.key((String)"test-map-key").mapType().noDefaultValue();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key1", "A,B,C,D");
        map.put("key2", "A;BCD");
        map.put("key3", "A'B'C'D");
        map.put("key4", "AB\"C\"D");
        map.put("key5", "AB'\"D:B");
        flinkConfig.set(mapConfigOption, map);
        Assertions.assertThat((Map)((Map)flinkConfig.get(mapConfigOption))).containsAllEntriesOf(map);
        ConfigOption listMapConfigOption = ConfigOptions.key((String)"test-list-map-key").mapType().asList().noDefaultValue();
        List listMap = Collections.singletonList(map);
        flinkConfig.set(listMapConfigOption, listMap);
        Assertions.assertThat((List)((List)flinkConfig.get(listMapConfigOption))).containsExactlyInAnyOrderElementsOf(listMap);
        ConfigOption durationConfigOption = ConfigOptions.key((String)"test-duration-key").durationType().noDefaultValue();
        Duration duration = Duration.ofMillis(3000L);
        flinkConfig.set(durationConfigOption, (Object)duration);
        Assertions.assertThat((Duration)((Duration)flinkConfig.get(durationConfigOption))).isEqualTo((Object)duration);
        ConfigOption memoryConfigOption = ConfigOptions.key((String)"test-memory-key").memoryType().noDefaultValue();
        MemorySize memorySize = MemorySize.ofMebiBytes((long)10L);
        flinkConfig.set(memoryConfigOption, (Object)memorySize);
        Assertions.assertThat((Comparable)memorySize).isEqualTo(flinkConfig.get(memoryConfigOption));
        BootstrapTools.writeConfiguration((Configuration)flinkConfig, (File)new File(flinkConfDir, GlobalConfiguration.getFlinkConfFilename()));
        Configuration loadedFlinkConfig = GlobalConfiguration.loadConfiguration((String)flinkConfDir.getAbsolutePath());
        Assertions.assertThat((List)((List)loadedFlinkConfig.get(listStringConfigOption))).containsExactlyInAnyOrderElementsOf(list);
        Assertions.assertThat((List)((List)loadedFlinkConfig.get(listDurationConfigOption))).containsExactlyInAnyOrderElementsOf(durationList);
        Assertions.assertThat((Map)((Map)loadedFlinkConfig.get(mapConfigOption))).containsAllEntriesOf(map);
        Assertions.assertThat((Duration)((Duration)loadedFlinkConfig.get(durationConfigOption))).isEqualTo((Object)duration);
    }
}

