/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.traces;

import java.util.HashMap;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.traces.SimpleSpan;
import org.apache.flink.traces.Span;

@Experimental
public class SpanBuilder {
    private final HashMap<String, Object> attributes = new HashMap();
    private final Class<?> classScope;
    private final String name;
    private long startTsMillis;
    private long endTsMillis;

    SpanBuilder(Class<?> classScope, String name) {
        this.classScope = classScope;
        this.name = name;
    }

    public Span build() {
        long endTsMillisToBuild;
        long startTsMillisToBuild = this.startTsMillis;
        if (startTsMillisToBuild == 0L) {
            startTsMillisToBuild = System.currentTimeMillis();
        }
        if ((endTsMillisToBuild = this.endTsMillis) == 0L) {
            endTsMillisToBuild = startTsMillisToBuild;
        }
        return new SimpleSpan(this.classScope.getCanonicalName(), this.name, startTsMillisToBuild, endTsMillisToBuild, this.attributes);
    }

    public SpanBuilder setStartTsMillis(long startTsMillis) {
        this.startTsMillis = startTsMillis;
        return this;
    }

    public SpanBuilder setEndTsMillis(long endTsMillis) {
        this.endTsMillis = endTsMillis;
        return this;
    }

    public SpanBuilder setAttribute(String key, String value) {
        this.attributes.put(key, value);
        return this;
    }

    public SpanBuilder setAttribute(String key, long value) {
        this.attributes.put(key, value);
        return this;
    }

    public SpanBuilder setAttribute(String key, double value) {
        this.attributes.put(key, value);
        return this;
    }
}

