/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types;

import java.io.IOException;
import org.apache.flink.annotation.Public;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.CopyableValue;
import org.apache.flink.types.ResettableValue;

@Public
public class DoubleValue
implements Comparable<DoubleValue>,
ResettableValue<DoubleValue>,
CopyableValue<DoubleValue> {
    private static final long serialVersionUID = 1L;
    private double value;

    public DoubleValue() {
        this.value = 0.0;
    }

    public DoubleValue(double value) {
        this.value = value;
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public void setValue(double value) {
        this.value = value;
    }

    @Override
    public void setValue(DoubleValue value) {
        this.value = value.value;
    }

    @Override
    public void read(DataInputView in) throws IOException {
        this.value = in.readDouble();
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        out.writeDouble(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public int compareTo(DoubleValue o) {
        double other = o.value;
        return this.value < other ? -1 : (this.value > other ? 1 : 0);
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.value);
        return 31 + (int)(temp ^ temp >>> 32);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DoubleValue) {
            DoubleValue other = (DoubleValue)obj;
            return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(other.value);
        }
        return false;
    }

    @Override
    public int getBinaryLength() {
        return 8;
    }

    @Override
    public void copyTo(DoubleValue target) {
        target.value = this.value;
    }

    @Override
    public DoubleValue copy() {
        return new DoubleValue(this.value);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.write(source, 8);
    }
}

