/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.plugin.PluginDescriptor;
import org.apache.flink.core.plugin.PluginLoader;
import org.apache.flink.core.plugin.PluginManager;
import org.apache.flink.shaded.guava32.com.google.common.base.Joiner;
import org.apache.flink.shaded.guava32.com.google.common.collect.Iterators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
@ThreadSafe
public class DefaultPluginManager
implements PluginManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPluginManager.class);
    private final ClassLoader parentClassLoader;
    private final Collection<PluginDescriptor> pluginDescriptors;
    private final Lock pluginLoadersLock;
    @GuardedBy(value="pluginLoadersLock")
    private final Map<String, PluginLoader> pluginLoaders;
    private final String[] alwaysParentFirstPatterns;

    @VisibleForTesting
    DefaultPluginManager() {
        this.parentClassLoader = null;
        this.pluginDescriptors = null;
        this.pluginLoadersLock = null;
        this.pluginLoaders = null;
        this.alwaysParentFirstPatterns = null;
    }

    public DefaultPluginManager(Collection<PluginDescriptor> pluginDescriptors, String[] alwaysParentFirstPatterns) {
        this(pluginDescriptors, DefaultPluginManager.class.getClassLoader(), alwaysParentFirstPatterns);
    }

    public DefaultPluginManager(Collection<PluginDescriptor> pluginDescriptors, ClassLoader parentClassLoader, String[] alwaysParentFirstPatterns) {
        this.pluginDescriptors = pluginDescriptors;
        this.pluginLoadersLock = new ReentrantLock();
        this.pluginLoaders = new HashMap<String, PluginLoader>();
        this.parentClassLoader = parentClassLoader;
        this.alwaysParentFirstPatterns = alwaysParentFirstPatterns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> Iterator<P> load(Class<P> service) {
        ArrayList<Iterator<P>> combinedIterators = new ArrayList<Iterator<P>>(this.pluginDescriptors.size());
        for (PluginDescriptor pluginDescriptor : this.pluginDescriptors) {
            PluginLoader pluginLoader;
            String pluginId = pluginDescriptor.getPluginId();
            this.pluginLoadersLock.lock();
            try {
                if (this.pluginLoaders.containsKey(pluginId)) {
                    LOG.info("Plugin loader with ID found, reusing it: {}", (Object)pluginId);
                    pluginLoader = this.pluginLoaders.get(pluginId);
                } else {
                    LOG.info("Plugin loader with ID not found, creating it: {}", (Object)pluginId);
                    pluginLoader = PluginLoader.create(pluginDescriptor, this.parentClassLoader, this.alwaysParentFirstPatterns);
                    this.pluginLoaders.putIfAbsent(pluginId, pluginLoader);
                }
            }
            finally {
                this.pluginLoadersLock.unlock();
            }
            combinedIterators.add(pluginLoader.load(service));
        }
        return Iterators.concat(combinedIterators.iterator());
    }

    public String toString() {
        return "PluginManager{parentClassLoader=" + this.parentClassLoader + ", pluginDescriptors=" + this.pluginDescriptors + ", pluginLoaders=" + Joiner.on((String)",").withKeyValueSeparator("=").join(this.pluginLoaders) + ", alwaysParentFirstPatterns=" + Arrays.toString(this.alwaysParentFirstPatterns) + "}";
    }
}

