/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime.kryo;

import com.esotericsoftware.kryo.Serializer;
import java.io.IOException;
import java.util.LinkedHashMap;
import org.apache.flink.api.common.SerializableSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.java.typeutils.runtime.KryoRegistration;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializerSnapshotData;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.LinkedOptionalMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KryoSerializerSnapshot<T>
implements TypeSerializerSnapshot<T> {
    private static final Logger LOG = LoggerFactory.getLogger(KryoSerializerSnapshot.class);
    private static final int VERSION = 2;
    private KryoSerializerSnapshotData<T> snapshotData;

    public KryoSerializerSnapshot() {
    }

    KryoSerializerSnapshot(Class<T> typeClass, LinkedHashMap<Class<?>, SerializableSerializer<?>> defaultKryoSerializers, LinkedHashMap<Class<?>, Class<? extends Serializer<?>>> defaultKryoSerializerClasses, LinkedHashMap<String, KryoRegistration> kryoRegistrations) {
        this.snapshotData = KryoSerializerSnapshotData.createFrom(typeClass, defaultKryoSerializers, defaultKryoSerializerClasses, kryoRegistrations);
    }

    @Override
    public int getCurrentVersion() {
        return 2;
    }

    @Override
    public void writeSnapshot(DataOutputView out) throws IOException {
        this.snapshotData.writeSnapshotData(out);
    }

    @Override
    public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
        this.snapshotData = KryoSerializerSnapshotData.createFrom(in, userCodeClassLoader);
    }

    @Override
    public TypeSerializer<T> restoreSerializer() {
        return new KryoSerializer<T>(this.snapshotData.getTypeClass(), this.snapshotData.getDefaultKryoSerializers().unwrapOptionals(), this.snapshotData.getDefaultKryoSerializerClasses().unwrapOptionals(), this.snapshotData.getKryoRegistrations().unwrapOptionals());
    }

    @Override
    public TypeSerializerSchemaCompatibility<T> resolveSchemaCompatibility(TypeSerializerSnapshot<T> oldSerializerSnapshot) {
        if (!(oldSerializerSnapshot instanceof KryoSerializerSnapshot)) {
            return TypeSerializerSchemaCompatibility.incompatible();
        }
        KryoSerializerSnapshot oldKryoSerializerSnapshot = (KryoSerializerSnapshot)oldSerializerSnapshot;
        if (this.snapshotData.getTypeClass() != oldKryoSerializerSnapshot.snapshotData.getTypeClass()) {
            return TypeSerializerSchemaCompatibility.incompatible();
        }
        return this.resolveSchemaCompatibility(oldKryoSerializerSnapshot);
    }

    @Override
    private TypeSerializerSchemaCompatibility<T> resolveSchemaCompatibility(KryoSerializerSnapshot<T> oldKryoSerializerSnapshot) {
        LinkedOptionalMap.MergeResult<Class<?>, SerializableSerializer<?>> reconfiguredDefaultKryoSerializers = LinkedOptionalMap.mergeRightIntoLeft(oldKryoSerializerSnapshot.snapshotData.getDefaultKryoSerializers(), this.snapshotData.getDefaultKryoSerializers());
        if (reconfiguredDefaultKryoSerializers.hasMissingKeys()) {
            this.logMissingKeys(reconfiguredDefaultKryoSerializers);
            return TypeSerializerSchemaCompatibility.incompatible();
        }
        LinkedOptionalMap.MergeResult<Class<?>, Class<Serializer<?>>> reconfiguredDefaultKryoSerializerClasses = LinkedOptionalMap.mergeRightIntoLeft(oldKryoSerializerSnapshot.snapshotData.getDefaultKryoSerializerClasses(), this.snapshotData.getDefaultKryoSerializerClasses());
        if (reconfiguredDefaultKryoSerializerClasses.hasMissingKeys()) {
            this.logMissingKeys(reconfiguredDefaultKryoSerializerClasses);
            return TypeSerializerSchemaCompatibility.incompatible();
        }
        LinkedOptionalMap.MergeResult<String, KryoRegistration> reconfiguredRegistrations = LinkedOptionalMap.mergeRightIntoLeft(oldKryoSerializerSnapshot.snapshotData.getKryoRegistrations(), this.snapshotData.getKryoRegistrations());
        if (reconfiguredRegistrations.hasMissingKeys()) {
            this.logMissingKeys(reconfiguredRegistrations);
            return TypeSerializerSchemaCompatibility.incompatible();
        }
        return this.resolveSchemaCompatibility(reconfiguredDefaultKryoSerializers, reconfiguredDefaultKryoSerializerClasses, reconfiguredRegistrations);
    }

    private TypeSerializerSchemaCompatibility<T> resolveSchemaCompatibility(LinkedOptionalMap.MergeResult<Class<?>, SerializableSerializer<?>> reconfiguredDefaultKryoSerializers, LinkedOptionalMap.MergeResult<Class<?>, Class<? extends Serializer<?>>> reconfiguredDefaultKryoSerializerClasses, LinkedOptionalMap.MergeResult<String, KryoRegistration> reconfiguredRegistrations) {
        if (reconfiguredDefaultKryoSerializers.isOrderedSubset() && reconfiguredDefaultKryoSerializerClasses.isOrderedSubset() && reconfiguredRegistrations.isOrderedSubset()) {
            return TypeSerializerSchemaCompatibility.compatibleAsIs();
        }
        KryoSerializer<T> reconfiguredSerializer = new KryoSerializer<T>(this.snapshotData.getTypeClass(), reconfiguredDefaultKryoSerializers.getMerged(), reconfiguredDefaultKryoSerializerClasses.getMerged(), reconfiguredRegistrations.getMerged());
        return TypeSerializerSchemaCompatibility.compatibleWithReconfiguredSerializer(reconfiguredSerializer);
    }

    private void logMissingKeys(LinkedOptionalMap.MergeResult<?, ?> mergeResult) {
        mergeResult.missingKeys().forEach(key -> LOG.warn("The Kryo registration for a previously registered class {} does not have a proper serializer, because its previous serializer cannot be loaded or is no longer valid but a new serializer is not available", key));
    }
}

