/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.KryoBufferUnderflowException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.flink.annotation.Internal;

@Internal
public class NoFetchingInput
extends Input {
    public NoFetchingInput(InputStream inputStream) {
        super(inputStream, 8);
    }

    public int read() throws KryoException {
        this.require(1);
        return this.buffer[this.position++] & 0xFF;
    }

    public boolean canReadInt() throws KryoException {
        throw new UnsupportedOperationException("NoFetchingInput cannot prefetch data.");
    }

    public boolean canReadLong() throws KryoException {
        throw new UnsupportedOperationException("NoFetchingInput cannot prefetch data.");
    }

    protected int require(int required) throws KryoException {
        int count;
        int remaining = this.limit - this.position;
        if (remaining >= required) {
            return remaining;
        }
        if (required > this.capacity) {
            throw new KryoException("Buffer too small: capacity: " + this.capacity + ", required: " + required);
        }
        if (remaining > 0) {
            count = this.fill(this.buffer, this.limit, required - this.limit);
            if (count == -1) {
                throw new KryoBufferUnderflowException("Buffer underflow.");
            }
            if ((remaining += count) >= required) {
                this.limit += count;
                return remaining;
            }
        }
        System.arraycopy(this.buffer, this.position, this.buffer, 0, remaining);
        this.total += (long)this.position;
        this.position = 0;
        do {
            if ((count = this.fill(this.buffer, remaining, required - remaining)) != -1) continue;
            throw new KryoBufferUnderflowException("Buffer underflow.");
        } while ((remaining += count) < required);
        this.limit = remaining;
        return remaining;
    }

    public int read(byte[] bytes, int offset, int count) throws KryoException {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        try {
            return this.inputStream.read(bytes, offset, count);
        }
        catch (IOException ex) {
            throw new KryoException((Throwable)ex);
        }
    }

    public void skip(int count) throws KryoException {
        try {
            this.inputStream.skip(count);
        }
        catch (IOException ex) {
            throw new KryoException((Throwable)ex);
        }
    }

    public void readBytes(byte[] bytes, int offset, int count) throws KryoException {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        if (count == 0) {
            return;
        }
        try {
            int c;
            int bytesRead = 0;
            do {
                if ((c = this.inputStream.read(bytes, offset + bytesRead, count - bytesRead)) != -1) continue;
                throw new KryoException((Throwable)new EOFException("No more bytes left."));
            } while ((bytesRead += c) != count);
        }
        catch (IOException ex) {
            throw new KryoException((Throwable)ex);
        }
    }
}

