/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base.array;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.base.FloatComparator;
import org.apache.flink.api.common.typeutils.base.array.PrimitiveArrayComparator;

@Internal
public class FloatPrimitiveArrayComparator
extends PrimitiveArrayComparator<float[], FloatComparator> {
    public FloatPrimitiveArrayComparator(boolean ascending) {
        super(ascending, new FloatComparator(ascending));
    }

    @Override
    public int hash(float[] record) {
        int result = 0;
        for (float field : record) {
            result += Float.floatToIntBits(field);
        }
        return result;
    }

    @Override
    public int compare(float[] first, float[] second) {
        for (int x = 0; x < Math.min(first.length, second.length); ++x) {
            int cmp = Float.compare(first[x], second[x]);
            if (cmp == 0) continue;
            return this.ascending ? cmp : -cmp;
        }
        int cmp = first.length - second.length;
        return this.ascending ? cmp : -cmp;
    }

    @Override
    public TypeComparator<float[]> duplicate() {
        FloatPrimitiveArrayComparator dupe = new FloatPrimitiveArrayComparator(this.ascending);
        dupe.setReference((float[])this.reference);
        return dupe;
    }
}

