/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.state.v2;

import javax.annotation.Nonnull;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.state.v2.StateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.util.Preconditions;

@Experimental
public class ReducingStateDescriptor<T>
extends StateDescriptor<T> {
    private final ReduceFunction<T> reduceFunction;

    public ReducingStateDescriptor(@Nonnull String name, @Nonnull ReduceFunction<T> reduceFunction, @Nonnull TypeInformation<T> typeInfo) {
        super(name, typeInfo);
        this.reduceFunction = Preconditions.checkNotNull(reduceFunction);
    }

    public ReducingStateDescriptor(@Nonnull String stateId, @Nonnull ReduceFunction<T> reduceFunction, @Nonnull TypeSerializer<T> serializer) {
        super(stateId, serializer);
        this.reduceFunction = Preconditions.checkNotNull(reduceFunction);
    }

    public ReducingStateDescriptor(String name, ReduceFunction<T> reduceFunction, Class<T> typeClass) {
        super(name, typeClass);
        this.reduceFunction = Preconditions.checkNotNull(reduceFunction);
    }

    public ReduceFunction<T> getReduceFunction() {
        return this.reduceFunction;
    }

    @Override
    public StateDescriptor.Type getType() {
        return StateDescriptor.Type.REDUCING;
    }
}

