/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators.base;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.functions.CoGroupFunction;
import org.apache.flink.api.common.functions.DefaultOpenContext;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.CopyingListCollector;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.api.common.operators.BinaryOperatorInformation;
import org.apache.flink.api.common.operators.DualInputOperator;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.util.ListKeyGroupedIterator;
import org.apache.flink.api.common.operators.util.UserCodeClassWrapper;
import org.apache.flink.api.common.operators.util.UserCodeObjectWrapper;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;
import org.apache.flink.api.common.typeinfo.AtomicType;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.common.typeutils.GenericPairComparator;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypePairComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;

@Internal
public class CoGroupOperatorBase<IN1, IN2, OUT, FT extends CoGroupFunction<IN1, IN2, OUT>>
extends DualInputOperator<IN1, IN2, OUT, FT> {
    private Ordering groupOrder1;
    private Ordering groupOrder2;
    private Partitioner<?> customPartitioner;
    private boolean combinableFirst = false;
    private boolean combinableSecond = false;

    public CoGroupOperatorBase(UserCodeWrapper<FT> udf, BinaryOperatorInformation<IN1, IN2, OUT> operatorInfo, int[] keyPositions1, int[] keyPositions2, String name) {
        super(udf, operatorInfo, keyPositions1, keyPositions2, name);
    }

    public CoGroupOperatorBase(FT udf, BinaryOperatorInformation<IN1, IN2, OUT> operatorInfo, int[] keyPositions1, int[] keyPositions2, String name) {
        this(new UserCodeObjectWrapper<FT>(udf), operatorInfo, keyPositions1, keyPositions2, name);
    }

    public CoGroupOperatorBase(Class<? extends FT> udf, BinaryOperatorInformation<IN1, IN2, OUT> operatorInfo, int[] keyPositions1, int[] keyPositions2, String name) {
        this(new UserCodeClassWrapper<FT>(udf), operatorInfo, keyPositions1, keyPositions2, name);
    }

    public void setGroupOrder(int inputNum, Ordering order) {
        if (inputNum == 0) {
            this.groupOrder1 = order;
        } else if (inputNum == 1) {
            this.groupOrder2 = order;
        } else {
            throw new IndexOutOfBoundsException();
        }
    }

    public void setGroupOrderForInputOne(Ordering order) {
        this.setGroupOrder(0, order);
    }

    public void setGroupOrderForInputTwo(Ordering order) {
        this.setGroupOrder(1, order);
    }

    public Ordering getGroupOrder(int inputNum) {
        if (inputNum == 0) {
            return this.groupOrder1;
        }
        if (inputNum == 1) {
            return this.groupOrder2;
        }
        throw new IndexOutOfBoundsException();
    }

    public Ordering getGroupOrderForInputOne() {
        return this.getGroupOrder(0);
    }

    public Ordering getGroupOrderForInputTwo() {
        return this.getGroupOrder(1);
    }

    public boolean isCombinableFirst() {
        return this.combinableFirst;
    }

    public void setCombinableFirst(boolean combinableFirst) {
        this.combinableFirst = combinableFirst;
    }

    public boolean isCombinableSecond() {
        return this.combinableSecond;
    }

    public void setCombinableSecond(boolean combinableSecond) {
        this.combinableSecond = combinableSecond;
    }

    public void setCustomPartitioner(Partitioner<?> customPartitioner) {
        this.customPartitioner = customPartitioner;
    }

    public Partitioner<?> getCustomPartitioner() {
        return this.customPartitioner;
    }

    @Override
    protected List<OUT> executeOnCollections(List<IN1> input1, List<IN2> input2, RuntimeContext ctx, ExecutionConfig executionConfig) throws Exception {
        TypeComparator inputSortComparator2;
        boolean[] allSortDirections;
        boolean[] groupSortDirections;
        int[] allSortKeys;
        int[] groupSortKeys;
        TypeComparator inputSortComparator1;
        TypeInformation inputType1 = ((BinaryOperatorInformation)this.getOperatorInfo()).getFirstInputType();
        TypeInformation inputType2 = ((BinaryOperatorInformation)this.getOperatorInfo()).getSecondInputType();
        int[] inputKeys1 = this.getKeyColumns(0);
        int[] inputKeys2 = this.getKeyColumns(1);
        boolean[] inputDirections1 = new boolean[inputKeys1.length];
        boolean[] inputDirections2 = new boolean[inputKeys2.length];
        Arrays.fill(inputDirections1, true);
        Arrays.fill(inputDirections2, true);
        TypeSerializer inputSerializer1 = inputType1.createSerializer(executionConfig.getSerializerConfig());
        TypeSerializer inputSerializer2 = inputType2.createSerializer(executionConfig.getSerializerConfig());
        TypeComparator inputComparator1 = this.getTypeComparator(executionConfig, inputType1, inputKeys1, inputDirections1);
        TypeComparator inputComparator2 = this.getTypeComparator(executionConfig, inputType2, inputKeys2, inputDirections2);
        if (this.groupOrder1 == null || this.groupOrder1.getNumberOfFields() == 0) {
            inputSortComparator1 = inputComparator1;
        } else {
            groupSortKeys = this.groupOrder1.getFieldPositions();
            allSortKeys = new int[inputKeys1.length + this.groupOrder1.getNumberOfFields()];
            System.arraycopy(inputKeys1, 0, allSortKeys, 0, inputKeys1.length);
            System.arraycopy(groupSortKeys, 0, allSortKeys, inputKeys1.length, groupSortKeys.length);
            groupSortDirections = this.groupOrder1.getFieldSortDirections();
            allSortDirections = new boolean[inputKeys1.length + groupSortKeys.length];
            Arrays.fill(allSortDirections, 0, inputKeys1.length, true);
            System.arraycopy(groupSortDirections, 0, allSortDirections, inputKeys1.length, groupSortDirections.length);
            inputSortComparator1 = this.getTypeComparator(executionConfig, inputType1, allSortKeys, allSortDirections);
        }
        if (this.groupOrder2 == null || this.groupOrder2.getNumberOfFields() == 0) {
            inputSortComparator2 = inputComparator2;
        } else {
            groupSortKeys = this.groupOrder2.getFieldPositions();
            allSortKeys = new int[inputKeys2.length + this.groupOrder2.getNumberOfFields()];
            System.arraycopy(inputKeys2, 0, allSortKeys, 0, inputKeys2.length);
            System.arraycopy(groupSortKeys, 0, allSortKeys, inputKeys2.length, groupSortKeys.length);
            groupSortDirections = this.groupOrder2.getFieldSortDirections();
            allSortDirections = new boolean[inputKeys2.length + groupSortKeys.length];
            Arrays.fill(allSortDirections, 0, inputKeys2.length, true);
            System.arraycopy(groupSortDirections, 0, allSortDirections, inputKeys2.length, groupSortDirections.length);
            inputSortComparator2 = this.getTypeComparator(executionConfig, inputType2, allSortKeys, allSortDirections);
        }
        CoGroupSortListIterator<IN1, IN2> coGroupIterator = new CoGroupSortListIterator<IN1, IN2>(input1, inputSortComparator1, inputComparator1, inputSerializer1, input2, inputSortComparator2, inputComparator2, inputSerializer2);
        CoGroupFunction function = (CoGroupFunction)this.userFunction.getUserCodeObject();
        FunctionUtils.setFunctionRuntimeContext(function, ctx);
        FunctionUtils.openFunction(function, DefaultOpenContext.INSTANCE);
        ArrayList result = new ArrayList();
        CopyingListCollector resultCollector = new CopyingListCollector(result, this.getOperatorInfo().getOutputType().createSerializer(executionConfig.getSerializerConfig()));
        while (coGroupIterator.next()) {
            function.coGroup(coGroupIterator.getValues1(), coGroupIterator.getValues2(), resultCollector);
        }
        FunctionUtils.closeFunction(function);
        return result;
    }

    private <T> TypeComparator<T> getTypeComparator(ExecutionConfig executionConfig, TypeInformation<T> inputType, int[] inputKeys, boolean[] inputSortDirections) {
        if (inputType instanceof CompositeType) {
            return ((CompositeType)inputType).createComparator(inputKeys, inputSortDirections, 0, executionConfig);
        }
        if (inputType instanceof AtomicType) {
            return ((AtomicType)((Object)inputType)).createComparator(inputSortDirections[0], executionConfig);
        }
        throw new InvalidProgramException("Input type of coGroup must be one of composite types or atomic types.");
    }

    private static class CoGroupSortListIterator<IN1, IN2> {
        private final ListKeyGroupedIterator<IN1> iterator1;
        private final ListKeyGroupedIterator<IN2> iterator2;
        private final TypePairComparator<IN1, IN2> pairComparator;
        private MatchStatus matchStatus;
        private Iterable<IN1> firstReturn;
        private Iterable<IN2> secondReturn;

        private CoGroupSortListIterator(List<IN1> input1, final TypeComparator<IN1> inputSortComparator1, TypeComparator<IN1> inputComparator1, TypeSerializer<IN1> serializer1, List<IN2> input2, final TypeComparator<IN2> inputSortComparator2, TypeComparator<IN2> inputComparator2, TypeSerializer<IN2> serializer2) {
            this.pairComparator = new GenericPairComparator<IN1, IN2>(inputComparator1, inputComparator2);
            this.iterator1 = new ListKeyGroupedIterator<IN1>(input1, serializer1, inputComparator1);
            this.iterator2 = new ListKeyGroupedIterator<IN2>(input2, serializer2, inputComparator2);
            Collections.sort(input1, new Comparator<IN1>(){

                @Override
                public int compare(IN1 o1, IN1 o2) {
                    return inputSortComparator1.compare(o1, o2);
                }
            });
            Collections.sort(input2, new Comparator<IN2>(){

                @Override
                public int compare(IN2 o1, IN2 o2) {
                    return inputSortComparator2.compare(o1, o2);
                }
            });
        }

        private boolean next() throws IOException {
            boolean firstEmpty = true;
            boolean secondEmpty = true;
            if (this.matchStatus != MatchStatus.FIRST_EMPTY) {
                if (this.matchStatus == MatchStatus.FIRST_REMAINED) {
                    firstEmpty = false;
                } else if (this.iterator1.nextKey()) {
                    this.pairComparator.setReference(this.iterator1.getValues().getCurrent());
                    firstEmpty = false;
                }
            }
            if (this.matchStatus != MatchStatus.SECOND_EMPTY) {
                if (this.matchStatus == MatchStatus.SECOND_REMAINED) {
                    secondEmpty = false;
                } else if (this.iterator2.nextKey()) {
                    secondEmpty = false;
                }
            }
            if (firstEmpty && secondEmpty) {
                return false;
            }
            if (firstEmpty && !secondEmpty) {
                this.firstReturn = Collections.emptySet();
                this.secondReturn = this.iterator2.getValues();
                this.matchStatus = MatchStatus.FIRST_EMPTY;
                return true;
            }
            if (!firstEmpty && secondEmpty) {
                this.firstReturn = this.iterator1.getValues();
                this.secondReturn = Collections.emptySet();
                this.matchStatus = MatchStatus.SECOND_EMPTY;
                return true;
            }
            int comp = this.pairComparator.compareToReference(this.iterator2.getValues().getCurrent());
            if (0 == comp) {
                this.firstReturn = this.iterator1.getValues();
                this.secondReturn = this.iterator2.getValues();
                this.matchStatus = MatchStatus.NONE_REMAINED;
            } else if (0 < comp) {
                this.firstReturn = this.iterator1.getValues();
                this.secondReturn = Collections.emptySet();
                this.matchStatus = MatchStatus.SECOND_REMAINED;
            } else {
                this.firstReturn = Collections.emptySet();
                this.secondReturn = this.iterator2.getValues();
                this.matchStatus = MatchStatus.FIRST_REMAINED;
            }
            return true;
        }

        private Iterable<IN1> getValues1() {
            return this.firstReturn;
        }

        private Iterable<IN2> getValues2() {
            return this.secondReturn;
        }

        private static enum MatchStatus {
            NONE_REMAINED,
            FIRST_REMAINED,
            SECOND_REMAINED,
            FIRST_EMPTY,
            SECOND_EMPTY;

        }
    }
}

