/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util.concurrent;

import java.time.Duration;
import org.apache.flink.util.concurrent.ExponentialBackoffRetryStrategy;
import org.apache.flink.util.concurrent.RetryStrategy;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ExponentialBackoffRetryStrategyTest {
    ExponentialBackoffRetryStrategyTest() {
    }

    @Test
    void testGettersNotCapped() {
        ExponentialBackoffRetryStrategy retryStrategy = new ExponentialBackoffRetryStrategy(10, Duration.ofMillis(5L), Duration.ofMillis(20L));
        Assertions.assertThat((int)retryStrategy.getNumRemainingRetries()).isEqualTo(10);
        Assertions.assertThat((Duration)retryStrategy.getRetryDelay()).isEqualTo((Object)Duration.ofMillis(5L));
        RetryStrategy nextRetryStrategy = retryStrategy.getNextRetryStrategy();
        Assertions.assertThat((int)nextRetryStrategy.getNumRemainingRetries()).isEqualTo(9);
        Assertions.assertThat((Duration)nextRetryStrategy.getRetryDelay()).isEqualTo((Object)Duration.ofMillis(10L));
    }

    @Test
    void testGettersHitCapped() {
        ExponentialBackoffRetryStrategy retryStrategy = new ExponentialBackoffRetryStrategy(5, Duration.ofMillis(15L), Duration.ofMillis(20L));
        Assertions.assertThat((int)retryStrategy.getNumRemainingRetries()).isEqualTo(5);
        Assertions.assertThat((Duration)retryStrategy.getRetryDelay()).isEqualTo((Object)Duration.ofMillis(15L));
        RetryStrategy nextRetryStrategy = retryStrategy.getNextRetryStrategy();
        Assertions.assertThat((int)nextRetryStrategy.getNumRemainingRetries()).isEqualTo(4);
        Assertions.assertThat((Duration)nextRetryStrategy.getRetryDelay()).isEqualTo((Object)Duration.ofMillis(20L));
    }

    @Test
    void testGettersAtCap() {
        ExponentialBackoffRetryStrategy retryStrategy = new ExponentialBackoffRetryStrategy(5, Duration.ofMillis(20L), Duration.ofMillis(20L));
        Assertions.assertThat((int)retryStrategy.getNumRemainingRetries()).isEqualTo(5);
        Assertions.assertThat((Duration)retryStrategy.getRetryDelay()).isEqualTo((Object)Duration.ofMillis(20L));
        RetryStrategy nextRetryStrategy = retryStrategy.getNextRetryStrategy();
        Assertions.assertThat((int)nextRetryStrategy.getNumRemainingRetries()).isEqualTo(4);
        Assertions.assertThat((Duration)nextRetryStrategy.getRetryDelay()).isEqualTo((Object)Duration.ofMillis(20L));
    }

    @Test
    void testRetryFailure() {
        Assertions.assertThatThrownBy(() -> new ExponentialBackoffRetryStrategy(0, Duration.ofMillis(20L), Duration.ofMillis(20L)).getNextRetryStrategy()).isInstanceOf(IllegalStateException.class);
    }
}

