/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import org.apache.flink.util.WrappingProxy;
import org.apache.flink.util.WrappingProxyUtil;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class WrappingProxyUtilTest {
    WrappingProxyUtilTest() {
    }

    @Test
    void testThrowsExceptionIfTooManyProxies() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> WrappingProxyUtil.stripProxy((WrappingProxy)new SelfWrappingProxy(128))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Are there loops in the object graph?");
    }

    @Test
    void testStripsAllProxies() {
        SelfWrappingProxy wrappingProxy = new SelfWrappingProxy(127);
        Assertions.assertThat((Object)((Wrapped)WrappingProxyUtil.stripProxy((WrappingProxy)wrappingProxy))).isNotInstanceOf(SelfWrappingProxy.class);
    }

    private static class SelfWrappingProxy
    extends Wrapped
    implements WrappingProxy<Wrapped> {
        private int levels;

        private SelfWrappingProxy(int levels) {
            this.levels = levels;
        }

        public Wrapped getWrappedDelegate() {
            if (this.levels-- == 0) {
                return new Wrapped();
            }
            return this;
        }
    }

    private static class Wrapped {
        private Wrapped() {
        }
    }
}

