/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.flink.util.FileUtils;

public class UserClassLoaderJarTestUtils {
    private UserClassLoaderJarTestUtils() {
        throw new RuntimeException();
    }

    public static File createJarFile(File tmpDir, String jarName, String className, String javaCode) throws IOException {
        return UserClassLoaderJarTestUtils.createJarFile(tmpDir, jarName, Collections.singletonMap(className, javaCode));
    }

    public static File createJarFile(File tmpDir, String jarName, Map<String, String> classNameCodes) throws IOException {
        ArrayList<File> javaFiles = new ArrayList<File>();
        for (Map.Entry<String, String> entry : classNameCodes.entrySet()) {
            File javaFile = Paths.get(tmpDir.toString(), entry.getKey() + ".java").toFile();
            javaFile.createNewFile();
            FileUtils.writeFileUtf8((File)javaFile, (String)entry.getValue());
            javaFiles.add(javaFile);
        }
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnostics, null, null);
        Iterable<? extends JavaFileObject> compilationUnit = fileManager.getJavaFileObjectsFromFiles(javaFiles);
        JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnostics, Collections.emptyList(), null, compilationUnit);
        task.call();
        File jarFile = Paths.get(tmpDir.toString(), jarName).toFile();
        JarOutputStream jos = new JarOutputStream(new FileOutputStream(jarFile));
        for (String className : classNameCodes.keySet()) {
            File classFile = Paths.get(tmpDir.toString(), className + ".class").toFile();
            JarEntry jarEntry = new JarEntry(className + ".class");
            jos.putNextEntry(jarEntry);
            byte[] classBytes = FileUtils.readAllBytes((Path)classFile.toPath());
            jos.write(classBytes);
            jos.closeEntry();
        }
        jos.close();
        return jarFile;
    }
}

