/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.apache.flink.util.TimeUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TimeUtilsTest {
    TimeUtilsTest() {
    }

    @Test
    void testParseDurationNanos() {
        Assertions.assertThat((int)TimeUtils.parseDuration((String)"424562ns").getNano()).isEqualTo(424562);
        Assertions.assertThat((int)TimeUtils.parseDuration((String)"424562nano").getNano()).isEqualTo(424562);
        Assertions.assertThat((int)TimeUtils.parseDuration((String)"424562nanos").getNano()).isEqualTo(424562);
        Assertions.assertThat((int)TimeUtils.parseDuration((String)"424562nanosecond").getNano()).isEqualTo(424562);
        Assertions.assertThat((int)TimeUtils.parseDuration((String)"424562nanoseconds").getNano()).isEqualTo(424562);
        Assertions.assertThat((int)TimeUtils.parseDuration((String)"424562 ns").getNano()).isEqualTo(424562);
        Assertions.assertThat((Duration)TimeUtils.parseDuration((String)"9223372036854775807000001 ns")).isEqualByComparingTo((Comparable)Duration.ofMillis(Long.MAX_VALUE).plusNanos(1L));
    }

    @Test
    void testParseDurationMicros() {
        Assertions.assertThat((int)TimeUtils.parseDuration((String)"565731\u00b5s").getNano()).isEqualTo(565731000L);
        Assertions.assertThat((int)TimeUtils.parseDuration((String)"565731micro").getNano()).isEqualTo(565731000L);
        Assertions.assertThat((int)TimeUtils.parseDuration((String)"565731micros").getNano()).isEqualTo(565731000L);
        Assertions.assertThat((int)TimeUtils.parseDuration((String)"565731microsecond").getNano()).isEqualTo(565731000L);
        Assertions.assertThat((int)TimeUtils.parseDuration((String)"565731microseconds").getNano()).isEqualTo(565731000L);
        Assertions.assertThat((int)TimeUtils.parseDuration((String)"565731 \u00b5s").getNano()).isEqualTo(565731000L);
    }

    @Test
    void testParseDurationMillis() {
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"1234").toMillis()).isEqualTo(1234L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"1234ms").toMillis()).isEqualTo(1234L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"1234milli").toMillis()).isEqualTo(1234L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"1234millis").toMillis()).isEqualTo(1234L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"1234millisecond").toMillis()).isEqualTo(1234L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"1234milliseconds").toMillis()).isEqualTo(1234L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"1234 ms").toMillis()).isEqualTo(1234L);
    }

    @Test
    void testParseDurationSeconds() {
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"667766s").getSeconds()).isEqualTo(667766L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"667766sec").getSeconds()).isEqualTo(667766L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"667766secs").getSeconds()).isEqualTo(667766L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"667766second").getSeconds()).isEqualTo(667766L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"667766seconds").getSeconds()).isEqualTo(667766L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"667766 s").getSeconds()).isEqualTo(667766L);
    }

    @Test
    void testParseDurationMinutes() {
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"7657623m").toMinutes()).isEqualTo(7657623L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"7657623min").toMinutes()).isEqualTo(7657623L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"7657623minute").toMinutes()).isEqualTo(7657623L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"7657623minutes").toMinutes()).isEqualTo(7657623L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"7657623 min").toMinutes()).isEqualTo(7657623L);
    }

    @Test
    void testParseDurationHours() {
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"987654h").toHours()).isEqualTo(987654L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"987654hour").toHours()).isEqualTo(987654L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"987654hours").toHours()).isEqualTo(987654L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"987654 h").toHours()).isEqualTo(987654L);
    }

    @Test
    void testParseDurationDays() {
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"987654d").toDays()).isEqualTo(987654L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"987654day").toDays()).isEqualTo(987654L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"987654days").toDays()).isEqualTo(987654L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"987654 d").toDays()).isEqualTo(987654L);
    }

    @Test
    void testParseDurationUpperCase() {
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"1 NS").toNanos()).isOne();
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"1 MICRO").toNanos()).isEqualTo(1000L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"1 MS").toMillis()).isOne();
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"1 S").getSeconds()).isOne();
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"1 MIN").toMinutes()).isOne();
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"1 H").toHours()).isOne();
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"1 D").toDays()).isOne();
    }

    @Test
    void testParseDurationTrim() {
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"      155      ").toMillis()).isEqualTo(155L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"      155      ms   ").toMillis()).isEqualTo(155L);
    }

    @Test
    void testParseDurationInvalid() {
        Assertions.assertThatThrownBy(() -> TimeUtils.parseDuration(null)).isInstanceOf(NullPointerException.class);
        Assertions.assertThatThrownBy(() -> TimeUtils.parseDuration((String)"")).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> TimeUtils.parseDuration((String)"     ")).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> TimeUtils.parseDuration((String)"foobar or fubar or foo bazz")).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> TimeUtils.parseDuration((String)"16 gjah")).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> TimeUtils.parseDuration((String)"16 16 17 18 ms")).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> TimeUtils.parseDuration((String)"-100 ms")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testParseDurationNumberOverflow() {
        Assertions.assertThatThrownBy(() -> TimeUtils.parseDuration((String)"100000000000000000000000000000000 ms")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testGetStringInMillis() {
        Assertions.assertThat((String)TimeUtils.getStringInMillis((Duration)Duration.ofMillis(4567L))).isEqualTo("4567ms");
        Assertions.assertThat((String)TimeUtils.getStringInMillis((Duration)Duration.ofSeconds(4567L))).isEqualTo("4567000ms");
        Assertions.assertThat((String)TimeUtils.getStringInMillis((Duration)Duration.of(4567L, ChronoUnit.MICROS))).isEqualTo("4ms");
    }
}

